package com.ejianc.business.process.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 班组主表
 * 
 * @author generator
 * 
 */
public class TeamVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Integer supplementFlag; // 是否主合同：0-主合同 1-补充协议
    private String compileName; // 编制人
    private Long compileId; // 编制人id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date compileDate; // 编制日期
    private Long orgId; // 项目组织ID
    private String orgName; // 项目组织名称
    private String parentOrgCode; // 组织编码
    private String parentOrgName; // 组织名称
    private Long parentOrgId; // 组织id
    private String memo; // 备注
    private Date commitData; // 提交日期
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private String commitUserCode; // 提交人账号
    private String commitUserName; // 提交人名字

    private Integer contractType; //合同类型：0-劳务合同 1-专业合同
    private String contractTypeName;//合同类型名称


    private Long projectId; // 项目Id
    private String projectName; // 项目名称（带入）
    private String projectCode; // 项目编号
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private String teamUsers;//班组
    private String compileDateStr;//编制日期



    private List<TeamDetailVO> teamDetailList = new ArrayList<>(); // 班组子表

    public String getCompileDateStr() {
        return compileDateStr;
    }

    public void setCompileDateStr(String compileDateStr) {
        this.compileDateStr = compileDateStr;
    }

    public String getTeamUsers() {
        return teamUsers;
    }

    public void setTeamUsers(String teamUsers) {
        this.teamUsers = teamUsers;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public List<TeamDetailVO> getTeamDetailList() {
        return teamDetailList;
    }

    public void setTeamDetailList(List<TeamDetailVO> teamDetailList) {
        this.teamDetailList = teamDetailList;
    }

    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public String getCompileName() {
        return compileName;
    }

    public void setCompileName(String compileName) {
        this.compileName = compileName;
    }
    public Long getCompileId() {
        return compileId;
    }
    @ReferDeserialTransfer
    public void setCompileId(Long compileId) {
        this.compileId = compileId;
    }
    public Date getCompileDate() {
        return compileDate;
    }

    public void setCompileDate(Date compileDate) {
        this.compileDate = compileDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getCommitData() {
        return commitData;
    }

    public void setCommitData(Date commitData) {
        this.commitData = commitData;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    
}
