package com.ejianc.business.prosub.vo;


import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 分包明细末级结算清单报表vo
 *
 * @author generator
 */
public class ContractSettleDetailsReportVO implements Serializable {
    private static final long serialVersionUID = 1L;

    private Integer addType;// 合同新增方式：参照定标结果新增-0，直接新增-1
    private Integer supplementFlag;// 是否补充协议(1:是，0：否)
    private Integer performanceStatus;// 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除
    private String pcContractCardUrl;// 合同穿透URL
    private String pcSettleCardUrl;// 结算单穿透URL
    private Long settleId;// 结算单主表id
    private Long contractId;// 合同主表id
    private Long contractDetailId;// 合同子表id
    private String contractCode;// 合同编码
    private String contractName;// 合同名称
    private String projectName;// 项目名称
    private String parentOrgName;// 所属单位
    private String supplierName;// 乙方
    private String employeeName;// 经办人
    private String detailCode;// 清单编码
    private String detailName;// 清单名称
    private String settleBillCode;// 结算单编码
    private String detailWorkContent;// 工作内容
    private String detailRule;// 计量规则
    private String detailUnit;// 单位
    private BigDecimal contractDetailPrice; //合同明细单价（含税）
    private BigDecimal contractNum;// 合同数量
    private BigDecimal contractTaxMny;// 合同金额
    private Integer settleType;// 结算单类型
    private BigDecimal settleDetailNumCount;// 结算数量-合计
    private BigDecimal settleDetailTaxMnyCount;// 结算金额-合计
    private BigDecimal processSettleDetailPrice; //月度结算单价 =  月度结算金额 / 月度结算数量
    private BigDecimal processNum;// 月度结算数量-合计
    private BigDecimal processTaxMny;// 月度结算金额-合计
    private BigDecimal nodeSettleDetailPrice; //节点结算单价 = 节点结算金额 / 节点结算数量
    private BigDecimal nodeNum;// 节点结算数量-合计
    private BigDecimal nodeTaxMny;// 节点结算金额-合计
    private BigDecimal finishSettleDetailPrice; //终结算单价 = 最终结算金额 / 最终结算金额
    private BigDecimal finalNum;// 最终结算数量-合计
    private BigDecimal finalTaxMny;// 最终结算金额-合计
    private BigDecimal finalRate;// 最终结算比例
    private String finalRateStr;// 最终结算比例字符串格式百分比
    private BigDecimal finalOverPrice; //最终超结单价 = 最终超结金额 / 最终超结数量
    private BigDecimal finalOverNum;// 最终超结数量-合计
    private BigDecimal finalOverTaxMny;// 最终超结金额-合计
    private BigDecimal finalOverRate;// 最终超结比例
    private String finalOverRateStr;// 最终超结比例字符串格式百分比
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate;// 结算日期

    public String getPcSettleCardUrl() {
        return pcSettleCardUrl;
    }

    public void setPcSettleCardUrl(String pcSettleCardUrl) {
        this.pcSettleCardUrl = pcSettleCardUrl;
    }

    public Integer getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(Integer performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public String getPcContractCardUrl() {
        return pcContractCardUrl;
    }

    public void setPcContractCardUrl(String pcContractCardUrl) {
        this.pcContractCardUrl = pcContractCardUrl;
    }

    public Integer getAddType() {
        return addType;
    }

    public void setAddType(Integer addType) {
        this.addType = addType;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getSettleBillCode() {
        return settleBillCode;
    }

    public void setSettleBillCode(String settleBillCode) {
        this.settleBillCode = settleBillCode;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public String getFinalRateStr() {
        return finalRateStr;
    }

    public void setFinalRateStr(String finalRateStr) {
        this.finalRateStr = finalRateStr;
    }

    public String getFinalOverRateStr() {
        return finalOverRateStr;
    }

    public void setFinalOverRateStr(String finalOverRateStr) {
        this.finalOverRateStr = finalOverRateStr;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getDetailCode() {
        return detailCode;
    }

    public void setDetailCode(String detailCode) {
        this.detailCode = detailCode;
    }

    public String getDetailName() {
        return detailName;
    }

    public void setDetailName(String detailName) {
        this.detailName = detailName;
    }

    public String getDetailWorkContent() {
        return detailWorkContent;
    }

    public void setDetailWorkContent(String detailWorkContent) {
        this.detailWorkContent = detailWorkContent;
    }

    public String getDetailRule() {
        return detailRule;
    }

    public void setDetailRule(String detailRule) {
        this.detailRule = detailRule;
    }

    public String getDetailUnit() {
        return detailUnit;
    }

    public void setDetailUnit(String detailUnit) {
        this.detailUnit = detailUnit;
    }

    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public BigDecimal getSettleDetailNumCount() {
        return settleDetailNumCount;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public void setSettleDetailNumCount(BigDecimal settleDetailNumCount) {
        this.settleDetailNumCount = settleDetailNumCount;
    }

    public BigDecimal getSettleDetailTaxMnyCount() {
        return settleDetailTaxMnyCount;
    }

    public void setSettleDetailTaxMnyCount(BigDecimal settleDetailTaxMnyCount) {
        this.settleDetailTaxMnyCount = settleDetailTaxMnyCount;
    }

    public BigDecimal getProcessNum() {
        return processNum;
    }

    public void setProcessNum(BigDecimal processNum) {
        this.processNum = processNum;
    }

    public BigDecimal getProcessTaxMny() {
        return processTaxMny;
    }

    public void setProcessTaxMny(BigDecimal processTaxMny) {
        this.processTaxMny = processTaxMny;
    }

    public BigDecimal getNodeNum() {
        return nodeNum;
    }

    public void setNodeNum(BigDecimal nodeNum) {
        this.nodeNum = nodeNum;
    }

    public BigDecimal getNodeTaxMny() {
        return nodeTaxMny;
    }

    public void setNodeTaxMny(BigDecimal nodeTaxMny) {
        this.nodeTaxMny = nodeTaxMny;
    }

    public BigDecimal getFinalNum() {
        return finalNum;
    }

    public void setFinalNum(BigDecimal finalNum) {
        this.finalNum = finalNum;
    }

    public BigDecimal getFinalTaxMny() {
        return finalTaxMny;
    }

    public void setFinalTaxMny(BigDecimal finalTaxMny) {
        this.finalTaxMny = finalTaxMny;
    }

    public BigDecimal getFinalRate() {
        return finalRate;
    }

    public void setFinalRate(BigDecimal finalRate) {
        this.finalRate = finalRate;
    }

    public BigDecimal getFinalOverNum() {
        return finalOverNum;
    }

    public void setFinalOverNum(BigDecimal finalOverNum) {
        this.finalOverNum = finalOverNum;
    }

    public BigDecimal getFinalOverTaxMny() {
        return finalOverTaxMny;
    }

    public void setFinalOverTaxMny(BigDecimal finalOverTaxMny) {
        this.finalOverTaxMny = finalOverTaxMny;
    }

    public BigDecimal getFinalOverRate() {
        return finalOverRate;
    }

    public void setFinalOverRate(BigDecimal finalOverRate) {
        this.finalOverRate = finalOverRate;
    }

    public BigDecimal getContractDetailPrice() {
        return contractDetailPrice;
    }

    public void setContractDetailPrice(BigDecimal contractDetailPrice) {
        this.contractDetailPrice = contractDetailPrice;
    }

    public BigDecimal getProcessSettleDetailPrice() {
        return processSettleDetailPrice;
    }

    public void setProcessSettleDetailPrice(BigDecimal processSettleDetailPrice) {
        this.processSettleDetailPrice = processSettleDetailPrice;
    }

    public BigDecimal getNodeSettleDetailPrice() {
        return nodeSettleDetailPrice;
    }

    public void setNodeSettleDetailPrice(BigDecimal nodeSettleDetailPrice) {
        this.nodeSettleDetailPrice = nodeSettleDetailPrice;
    }

    public BigDecimal getFinishSettleDetailPrice() {
        return finishSettleDetailPrice;
    }

    public void setFinishSettleDetailPrice(BigDecimal finishSettleDetailPrice) {
        this.finishSettleDetailPrice = finishSettleDetailPrice;
    }

    public BigDecimal getFinalOverPrice() {
        return finalOverPrice;
    }

    public void setFinalOverPrice(BigDecimal finalOverPrice) {
        this.finalOverPrice = finalOverPrice;
    }
}
