/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractFileService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractFileService contractFileService;

    @PostMapping(value={"/contractFileUpdate/updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/contractFileUpdate/getBillDataJson"})
    public CommonResponse<ContractVO> getBillDataJson(@RequestParam Long id) {
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(id));
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)contract), ContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            vo.setDetailList(vo.getDetailList().stream().filter(item -> null != item.getDetailNum()).collect(Collectors.toList()));
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(priceFmt.format(null != item.getDetailPrice() ? item.getDetailPrice() : BigDecimal.ZERO));
                item.setDetailTaxPriceStr(priceFmt.format(null != item.getDetailTaxPrice() ? item.getDetailTaxPrice() : BigDecimal.ZERO));
                item.setDetailMnyStr(mnyFmt.format(null != item.getDetailMny() ? item.getDetailMny() : BigDecimal.ZERO));
                item.setDetailTaxMnyStr(mnyFmt.format(null != item.getDetailTaxMny() ? item.getDetailTaxMny() : BigDecimal.ZERO));
                item.setDetailTaxStr(mnyFmt.format(null != item.getDetailTax() ? item.getDetailTax() : BigDecimal.ZERO));
                item.setDetailTaxRateStr(mnyFmt.format(null != item.getDetailTaxRate() ? item.getDetailTaxRate() : BigDecimal.ZERO));
                item.setDetailArtificialPriceStr(priceFmt.format(null != item.getDetailArtificialPrice() ? item.getDetailArtificialPrice() : BigDecimal.ZERO));
                item.setDetailArtificialTaxPriceStr(priceFmt.format(null != item.getDetailArtificialTaxPrice() ? item.getDetailArtificialTaxPrice() : BigDecimal.ZERO));
                item.setDetailArtificialMnyStr(mnyFmt.format(null != item.getDetailArtificialMny() ? item.getDetailArtificialMny() : BigDecimal.ZERO));
                item.setDetailArtificialTaxMnyStr(mnyFmt.format(null != item.getDetailArtificialTaxMny() ? item.getDetailArtificialTaxMny() : BigDecimal.ZERO));
                item.setDetailArtificialTaxStr(mnyFmt.format(null != item.getDetailArtificialTax() ? item.getDetailArtificialTax() : BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getOtherCostList())) {
            vo.getOtherCostList().stream().forEach(item -> {
                item.setCostPriceStr(priceFmt.format(null != item.getCostPrice() ? item.getCostPrice() : BigDecimal.ZERO));
                item.setCostTaxPriceStr(priceFmt.format(null != item.getCostTaxPrice() ? item.getCostTaxPrice() : BigDecimal.ZERO));
                item.setCostTaxRateStr(mnyFmt.format(null != item.getCostTaxPrice() ? item.getCostTaxPrice() : BigDecimal.ZERO));
                item.setCostTaxStr(mnyFmt.format(null != item.getCostTax() ? item.getCostTax() : BigDecimal.ZERO));
                item.setCostMnyStr(mnyFmt.format(null != item.getCostMny() ? item.getCostMny() : BigDecimal.ZERO));
                item.setCostTaxMnyStr(mnyFmt.format(null != item.getCostTaxMny() ? item.getCostTaxMny() : BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getPaymentList())) {
            vo.getPaymentList().stream().forEach(item -> item.setPaymentScaleStr(mnyFmt.format(null != item.getPaymentScale() ? item.getPaymentScale() : BigDecimal.ZERO)));
        }
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"/billFileUpdate/getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        JSONObject resp = this.contractFileService.getSignedFileInfo(billId, billType);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

