/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.OutFlagEnum;
import com.ejianc.business.prosub.pricelib.bean.PriceContractEntity;
import com.ejianc.business.prosub.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.prosub.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.prosub.pricelib.service.IPriceContractService;
import com.ejianc.business.prosub.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.prosub.pricelib.vo.PriceContractVO;
import com.ejianc.business.prosub.pricelib.vo.PriceLibVO;
import com.ejianc.business.prosub.pricelib.vo.PriceTrendVo;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.util.DateUtils;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceContractService")
public class PriceContractServiceImpl
extends BaseServiceImpl<PriceContractMapper, PriceContractEntity>
implements IPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IShareProsubApi shareProsubApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceLibList.size());
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public void savePriceContractByTiming(Date date) {
        List<ContractEntity> contractEntityList;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            contractEntityList = ((PriceContractMapper)this.baseMapper).getContractListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            contractEntityList = this.contractService.queryList(queryParam, false);
        }
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (CollectionUtils.isEmpty(contractEntityList)) {
            return;
        }
        List<Long> contractIdList = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<ContractDetailEntity> allDocDetailEntityList = ((PriceContractMapper)this.baseMapper).getContractDetailListByContractId(contractIdList);
        Map<Long, String> detailDocMap = allDocDetailEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, ContractDetailEntity::getDetailName, (key1, key2) -> key2));
        List detailEntityList = allDocDetailEntityList.stream().filter(e -> null != e.getDocId() && e.getDr() == 0 && null != e.getDetailNum()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return;
        }
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter("in", contractIdList));
        settleParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        settleParam.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u5b8c\u5de5.getCode()));
        List settleList = this.settleService.queryList(settleParam);
        Map<Object, Object> settleDateMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settleList)) {
            settleDateMap = settleList.stream().collect(Collectors.toMap(SettleEntity::getContractId, SettleEntity::getSettleDate, (key1, key2) -> key2));
        }
        List docCategoryIdList = detailEntityList.stream().map(ContractDetailEntity::getDocCategoryId).distinct().collect(Collectors.toList());
        this.logger.info("\u67e5\u8be2\u6863\u6848\u5206\u7c7bId\u5217\u8868-{}", (Object)JSONObject.toJSONString(docCategoryIdList));
        List docIs = detailEntityList.stream().filter(item -> null != item.getDetailNum()).map(ContractDetailEntity::getDocId).distinct().collect(Collectors.toList());
        CommonResponse labsubDocResponse = this.shareLabsubApi.queryCategoryListByIds(docCategoryIdList);
        CommonResponse prosubDocResponse = this.shareProsubApi.queryCategoryListByIds(docCategoryIdList);
        Map<Object, Object> docCategoryMap = new HashMap();
        Map<Object, Object> prosubDocCategoryMap = new HashMap();
        HashMap<Long, LabsubItemVO> labDocIdMap = new HashMap<Long, LabsubItemVO>();
        HashMap<Long, ProsubItemVO> proDocIdMap = new HashMap<Long, ProsubItemVO>();
        if (labsubDocResponse.isSuccess()) {
            List labsubDocCategoryVOList = (List)labsubDocResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)labsubDocCategoryVOList)) {
                docCategoryMap = labsubDocCategoryVOList.stream().collect(Collectors.toMap(BaseVO::getId, LabsubCategoryVO::getInnerCode, (key1, key2) -> key2));
                CommonResponse labsubDocItemResponse = this.shareLabsubApi.queryLabsubItemByIds(docIs);
                if (labsubDocItemResponse.isSuccess()) {
                    this.logger.info("\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u6e05\u5355\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)labsubDocItemResponse.getData()));
                    labDocIdMap.putAll(((List)labsubDocItemResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (key1, key2) -> key2)));
                } else {
                    this.logger.error("\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)labsubDocItemResponse));
                }
            } else {
                this.logger.info("\u67e5\u8be2\u52b3\u52a1\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(docCategoryIdList));
            }
        } else {
            this.logger.error("\u67e5\u8be2\u52b3\u52a1\u6863\u6848\u4fe1\u5206\u7c7b\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)labsubDocResponse));
        }
        if (prosubDocResponse.isSuccess()) {
            List prosubDocCategoryVOList = (List)prosubDocResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)prosubDocCategoryVOList)) {
                prosubDocCategoryMap = prosubDocCategoryVOList.stream().collect(Collectors.toMap(BaseVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key2));
                CommonResponse prosubDocItemResponse = this.shareProsubApi.queryProsubItemByIds(docIs);
                if (prosubDocItemResponse.isSuccess()) {
                    this.logger.info("\u67e5\u8be2\u6863\u6848\u6e05\u5355\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)prosubDocItemResponse.getData()));
                    proDocIdMap.putAll(((List)prosubDocItemResponse.getData()).stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (key1, key2) -> key2)));
                } else {
                    this.logger.error("\u67e5\u8be2\u4e13\u4e1a\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)prosubDocItemResponse));
                }
            } else {
                this.logger.info("\u67e5\u8be2\u6839\u636e\u6863\u6848Id\uff0c\u83b7\u53d6\u4e13\u4e1a\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(docCategoryIdList));
            }
        } else {
            this.logger.error("\u67e5\u8be2\u4e13\u4e1a\u6863\u6848\u4fe1\u5206\u7c7b\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)prosubDocResponse));
        }
        docCategoryMap.putAll(prosubDocCategoryMap);
        detailEntityList.stream().forEach(item -> {
            if (labDocIdMap.containsKey(item.getDocId())) {
                this.logger.info("\u52b3\u52a1\u5206\u5305\u6863\u6848-[{}]\u4ef7\u683c\u7c7b\u578b\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)item.getDetailName(), (Object)((LabsubItemVO)labDocIdMap.get(item.getDocId())).getPriceType());
                item.setDocPriceTypeName(((LabsubItemVO)labDocIdMap.get(item.getDocId())).getPriceType());
            }
            if (proDocIdMap.containsKey(item.getDocId())) {
                this.logger.info("\u4e13\u4e1a\u5206\u5305\u6863\u6848-[{}]\u4ef7\u683c\u7c7b\u578b\u8bbe\u7f6e\u4e3a\uff1a{}", (Object)item.getDetailName(), (Object)((ProsubItemVO)proDocIdMap.get(item.getDocId())).getPriceType());
                item.setDocPriceTypeName(((ProsubItemVO)proDocIdMap.get(item.getDocId())).getPriceType());
            }
        });
        List projectIdList = contractEntityList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map<Long, List<ContractDetailEntity>> detailMap = detailEntityList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getContractId));
        ArrayList<PriceContractEntity> saveEntityList = new ArrayList<PriceContractEntity>();
        for (ContractEntity entity : contractEntityList) {
            List<ContractDetailEntity> entityDetailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(entityDetailList)) continue;
            String cardType = "";
            if (entity.getAddType() == 1) {
                if (entity.getContractType() == 1) {
                    cardType = "proSubDirectCard";
                } else if (entity.getContractType() == 0) {
                    cardType = "laborSubDirectCard";
                }
            } else if (entity.getAddType() == 0) {
                if (entity.getContractType() == 1) {
                    cardType = "laborSubCard";
                } else if (entity.getContractType() == 0) {
                    cardType = "proSubCard";
                }
            }
            for (ContractDetailEntity detailEntity : entityDetailList) {
                if (detailEntity.getDocId() == null) continue;
                PriceContractEntity priceContractEntity = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                priceContractEntity.setSettlementDate((Date)settleDateMap.get(entity.getId()));
                priceContractEntity.setContractId(entity.getId());
                priceContractEntity.setContractName(entity.getContractName());
                priceContractEntity.setContractCode(entity.getBillCode());
                priceContractEntity.setContractFlag(entity.getSupplementFlag());
                priceContractEntity.setPcCardUrl("/ejc-prosub-frontend/#/laborSubList/contractMultiCards?id=" + entity.getId() + "&supplementFlag=" + entity.getSupplementFlag() + "&cardType=" + cardType + "&performanceStatus=" + entity.getPerformanceStatus());
                priceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                priceContractEntity.setSourceId(detailEntity.getId());
                priceContractEntity.setMeasureRule(detailEntity.getDetailMeasurementRules());
                priceContractEntity.setWorkContent(detailEntity.getDetailWorkContent());
                priceContractEntity.setContractTaxRate(detailEntity.getDetailTaxRate());
                priceContractEntity.setContractNum(detailEntity.getDetailNum());
                priceContractEntity.setContractPrice(detailEntity.getDetailPrice());
                priceContractEntity.setContractTaxPrice(detailEntity.getDetailTaxPrice());
                priceContractEntity.setContractMny(detailEntity.getDetailMny());
                priceContractEntity.setContractTaxMny(detailEntity.getDetailTaxMny());
                priceContractEntity.setMemo(detailEntity.getDetailMemo());
                priceContractEntity.setDocId(detailEntity.getDocId());
                priceContractEntity.setDocCode(detailEntity.getDetailCode());
                priceContractEntity.setDocName(detailEntity.getDetailName());
                priceContractEntity.setDocCategoryId(detailEntity.getDocCategoryId());
                priceContractEntity.setPriceTypeName(detailEntity.getDocPriceTypeName());
                if (null != detailEntity.getParentId()) {
                    priceContractEntity.setDocCategoryName(detailDocMap.get(detailEntity.getParentId()));
                }
                priceContractEntity.setDocInnerCode((String)docCategoryMap.get(detailEntity.getDocCategoryId()));
                priceContractEntity.setUnitName(detailEntity.getDetailUnit());
                priceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                priceContractEntity.setId(null);
                priceContractEntity.setCreateTime(null);
                priceContractEntity.setCreateUserCode(null);
                priceContractEntity.setUpdateTime(null);
                priceContractEntity.setUpdateUserCode(null);
                priceContractEntity.setDr(detailEntity.getDr());
                saveEntityList.add(priceContractEntity);
            }
        }
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(PriceContractEntity::getSourceId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(PriceContractEntity::getSourceId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveEntityList) {
                PriceContractEntity queryEntity = (PriceContractEntity)((Object)queryPriceMap.get(entity.getSourceId()));
                if (queryEntity == null) continue;
                entity.setId(queryEntity.getId());
                entity.setOutFlag(queryEntity.getOutFlag());
            }
        }
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove((Wrapper)wrapper, false);
        List delIdList = saveEntityList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delIdList)) {
            super.removeByIds(delIdList, false);
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    public static void main(String[] args) {
        ArrayList<ProsubCategoryVO> prosubDocCategoryVOList = new ArrayList<ProsubCategoryVO>();
        ProsubCategoryVO v1 = new ProsubCategoryVO();
        v1.setId(Long.valueOf(1L));
        ProsubCategoryVO v2 = new ProsubCategoryVO();
        v2.setId(Long.valueOf(2L));
        ProsubCategoryVO v3 = new ProsubCategoryVO();
        v3.setId(Long.valueOf(3L));
        prosubDocCategoryVOList.add(v1);
        prosubDocCategoryVOList.add(v2);
        prosubDocCategoryVOList.add(v3);
        Map<Long, String> prosubDocCategoryMap = prosubDocCategoryVOList.stream().collect(Collectors.toMap(BaseVO::getId, ProsubCategoryVO::getInnerCode, (key1, key2) -> key2));
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList.get(0);
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = (PriceContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate", "desc");
            param.getOrderMap().put("contractMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            if (myOrgList.contains(vo.getOrgId())) continue;
            vo.setPcCardUrl(null);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    private List<Long> getMyOrgList() {
        CommonResponse orgVOResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgVOResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            return orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private Map<String, Date> checkQueryParam(QueryParam param) {
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        if (!paramMap.containsKey("docId")) {
            throw new BusinessException("\u67e5\u8be2\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Date> rtnMap = new HashMap<String, Date>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        HashMap<Long, PriceLibVO> map = new HashMap<Long, PriceLibVO>();
        this.queryPriceContractGroupByDocId(map, startDate, orgIdList, param);
        this.queryPriceGuide(map);
        ArrayList<PriceLibVO> priceLibList = new ArrayList<PriceLibVO>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
            priceLibList.sort(Comparator.comparing(PriceLibVO::getDocCode, Comparator.nullsLast(String::compareTo)));
        }
        return priceLibList;
    }

    private void queryPriceContractGroupByDocId(Map<Long, PriceLibVO> libMap, Date startDate, List<Long> orgIdList, QueryParam param) {
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) {
            return;
        }
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getDocId));
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = ((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = ((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = ((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = ((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceContractEntity entity : value) {
                num = num.add(entity.getContractNum());
                mny = mny.add(entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setDocId(priceContract.getDocId());
                priceLibVO.setDocCode(priceContract.getDocCode());
                priceLibVO.setDocName(priceContract.getDocName());
                priceLibVO.setDocCategoryId(priceContract.getDocCategoryId());
                priceLibVO.setDocCategoryName(priceContract.getDocCategoryName());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setDocInnerCode(priceContract.getDocInnerCode());
                libMap.put(priceContract.getDocId(), priceLibVO);
            }
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
            priceLibVO.setId(priceLibVO.getDocId());
        }
    }

    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList, QueryParam param) {
        QueryParam contractParam = new QueryParam();
        List fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("docCode");
        fuzzyFields.add("docName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("area");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        CommonResponse response = this.paramConfigApi.getByCode(PRICE_LIB_CHECK_TYPE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u4ef7\u683c\u5e93\u67e5\u8be2\u4ef7\u683c\u7c7b\u578b\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        if (StringUtils.isNotBlank((CharSequence)valueData) && !valueData.contains("\u5168\u90e8")) {
            contractParam.getParams().put("priceTypeName", new Parameter("in", Arrays.asList(valueData.split(","))));
        }
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("performance_status", new Parameter("in", Arrays.asList(2, 5)));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("performance_status", new Parameter("in", Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter("ge", (Object)startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        return super.queryList(contractParam, false);
    }

    private List<Long> queryOrgIdList() {
        CommonResponse orgIdListResponse = this.priceDepotPowerSetApi.queryOrgList(InvocationInfoProxy.getOrgId());
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\u5931\u8d25:" + orgIdListResponse.getMsg());
        }
        return (List)orgIdListResponse.getData();
    }

    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, 4).subtract(BigDecimal.ONE).multiply(b);
    }

    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> docIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByDocIds(docIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getDocId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long docId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (!guideMap.containsKey(docId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(docId));
            BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
            BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }
}

