/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.mapper.PlanDetailChangeMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailChangeService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanDetailChangeVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="planChangeService")
public class PlanChangeServiceImpl
extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity>
implements IPlanChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanService masterPlanService;
    @Autowired
    private PlanChangeMapper planChangeMapper;
    @Autowired
    private PlanDetailChangeMapper masterPlanDetailChangeMapper;
    @Autowired
    private PlanChangeHisMapper masterPlanChangeHisMapper;
    @Autowired
    private IPlanDetailChangeService masterPlanDetailChangeService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;
    @Autowired
    private IPlanService planService;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Override
    public PlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_plan_id", (Object)sourcePlanId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (PlanChangeEntity)((Object)this.planChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity, Boolean isControl) {
        if (Boolean.FALSE.equals(isControl)) {
            if (CollectionUtils.isNotEmpty(saveEntity.getPlanDetailList())) {
                // empty if block
            }
            super.saveOrUpdate((Object)saveEntity, false);
            PlanEntity planEntity = (PlanEntity)((Object)this.masterPlanService.selectById(saveEntity.getSourcePlanId()));
            if (1 != planEntity.getChangeState()) {
                planEntity.setChangeState(1);
                planEntity.setChangeId(saveEntity.getId());
                this.masterPlanService.saveOrUpdate((Object)planEntity, false);
            }
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = this.planChangeMapper.selectBatchIds(changeIds);
        List planIds = changeList.stream().map(PlanChangeEntity::getSourcePlanId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", planIds);
        List planList = this.masterPlanService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_plan_id as planId"});
        query.in((Object)"source_plan_id", planIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_plan_id"});
        List queryResult = this.masterPlanChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = planList.iterator();
        while (iterator.hasNext()) {
            PlanEntity plan;
            plan.setChangeState(null != hisCountNumMap.get((plan = (PlanEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(plan.getId()) > 0 ? 2 : 0);
            plan.setChangeId(null);
        }
        this.masterPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<PlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PlanChangeEntity::getSourcePlanId, (Object)id);
        lambda.in(PlanChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        List recordVOList = BeanMapper.mapList((Iterable)entities, PlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
            if (recordVO.getChangeVersion() < 10) {
                recordVO.setHistoryCode(recordVO.getBillCode() + "-0" + recordVO.getChangeVersion());
            } else {
                recordVO.setHistoryCode(recordVO.getBillCode() + "-" + recordVO.getChangeVersion());
            }
        });
        return recordVOList;
    }

    @Override
    public PlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        PlanChangeEntity masterPlanChangeEntity = (PlanChangeEntity)((Object)super.selectById((Serializable)id));
        PlanChangeVO masterPlanChangeVO = (PlanChangeVO)BeanMapper.map((Object)((Object)masterPlanChangeEntity), PlanChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List masterPlanDetailChangeEntities = this.masterPlanDetailChangeService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)masterPlanDetailChangeEntities)) {
            masterPlanDetailChangeEntities.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (PlanDetailChangeEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class);
            List<PlanDetailChangeVO> usefulDetailList = this.selectUsefulByIds(resultMapList.stream().map(PlanDetailChangeVO::getTargetId).collect(Collectors.toList()));
            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<Long, Integer>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)) {
                for (PlanDetailChangeVO c : usefulDetailList) {
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailChangeVO c : resultMapList) {
                if (null != usefulDetailMap.get(c.getTargetId())) {
                    c.setUseNum(Integer.valueOf(1));
                    c.setRowState("edit");
                    continue;
                }
                c.setUseNum(null);
            }
            if (detailHasChildren) {
                masterPlanChangeVO.setPlanDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                masterPlanChangeVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanChangeVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailChangeVO.class));
        }
        return masterPlanChangeVO;
    }

    @Override
    public List<PlanDetailChangeVO> selectUsefulByIds(List<Long> planIdList) {
        return this.masterPlanDetailChangeMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public ExecutionVO targetCost(PlanChangeVO planChangeVO, String linkUrl, Integer subType, String billTypeCode, boolean lastSourceId) {
        ExecutionVO executionVO = new ExecutionVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(planChangeVO.getId());
        totalVO.setTenantId(planChangeVO.getTenantId());
        totalVO.setBillCode(planChangeVO.getBillCode());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setBillType(billTypeCode);
        if (lastSourceId) {
            if (null == planChangeVO.getId()) {
                totalVO.setLastSourceId(this.getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
            } else {
                PlanChangeEntity change = (PlanChangeEntity)((Object)super.selectById((Serializable)planChangeVO.getId()));
                if (null == change) {
                    totalVO.setLastSourceId(this.getLastExecutionVO(planChangeVO.getSourcePlanId()).getTotalVO().getSourceId());
                }
            }
        }
        if (subType == 0) {
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212.getCode());
        } else {
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u8ba1\u5212.getCode());
        totalVO.setProjectId(planChangeVO.getProjectId());
        totalVO.setOrgId(planChangeVO.getOrgId());
        totalVO.setMoney(planChangeVO.getTotalPlanMny());
        totalVO.setTaxMoney(planChangeVO.getTotalPlanTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (null != planChangeVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planChangeVO.getCreateTime()));
        }
        totalVO.setMemo(planChangeVO.getChangeReason());
        if (CollectionUtils.isNotEmpty((Collection)planChangeVO.getPlanDetailList())) {
            List planDetailChangeVOS = planChangeVO.getPlanDetailList().stream().filter(item -> item.getLeafFlag() != false && !"del".equals(item.getRowState()) && (null == item.getChangeType() || !item.getChangeType().equals(5))).collect(Collectors.toList());
            Assert.notEmpty(planDetailChangeVOS, (String)"\u6e05\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            for (PlanDetailChangeVO planDetailVO : planDetailChangeVOS) {
                LabsubCategoryVO categoryVO;
                CommonResponse res;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                Assert.notNull((Object)planDetailVO.getDocCategoryId(), (String)"\u6863\u6848\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a");
                if (0 == subType) {
                    res = this.shareLabsubApi.queryLabSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)planDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u52b3\u52a1\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (LabsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    res = this.shareLabsubApi.queryMajorSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        this.logger.error("\u6839\u636e\u6863\u6848\u5206\u7c7bid\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25,\u6863\u6848\u5206\u7c7bID:{}", (Object)planDetailVO.getDocCategoryId());
                        throw new BusinessException("\u6839\u636e\u5206\u7c7bID\u67e5\u8be2\u4e13\u4e1a\u5206\u5305\u6863\u6848\u5206\u7c7b\u4fe1\u606f\u5931\u8d25!");
                    }
                    categoryVO = (ProsubCategoryVO)res.getData();
                    if (categoryVO == null) {
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    } else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }
                Assert.notNull((Object)planDetailVO.getDocId(), (String)"\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if (null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public ExecutionVO getLastExecutionVO(Long sourcePlanId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"source_plan_id", (Object)sourcePlanId)).orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)wrapper);
        PlanChangeEntity tmp = null;
        String linkUrl = null;
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((CharSequence)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BASE_HOST;
        if (!list.isEmpty()) {
            tmp = (PlanChangeEntity)((Object)list.get(0));
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"plan_id", (Object)tmp.getId());
            tmp.setPlanDetailList(this.masterPlanDetailChangeMapper.selectList((Wrapper)detailWrapper));
            linkUrl = tmp.getSubType() == 0 ? frontendBaseHost + "ejc-prosub-frontend/#/labSubPlan/changeCard?id=" + tmp.getId() : frontendBaseHost + "ejc-prosub-frontend/#/proSubPlan/changeCard?id=" + tmp.getId();
            return this.targetCost((PlanChangeVO)BeanMapper.map((Object)((Object)tmp), PlanChangeVO.class), linkUrl, tmp.getSubType(), tmp.getSubType().equals(0) ? ProsubBillTypeEnum.\u52b3\u52a1\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode() : ProsubBillTypeEnum.\u4e13\u4e1a\u5206\u5305\u603b\u8ba1\u5212\u53d8\u66f4.getBillTypeCode(), false);
        }
        PlanEntity planEntity = (PlanEntity)((Object)this.planService.selectById(sourcePlanId));
        linkUrl = planEntity.getSubType() == 0 ? frontendBaseHost + "ejc-prosub-frontend/#/labSubPlan/card?id=" + planEntity.getId() : frontendBaseHost + "ejc-prosub-frontend/#/proSubPlan/card?id=" + planEntity.getId();
        return this.planService.targetCost((PlanVO)BeanMapper.map((Object)((Object)planEntity), PlanVO.class), linkUrl, planEntity.getSubType());
    }
}

