/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.ApplicationDetailEntity;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.service.IApplicationDetailService;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.vo.ApplicationDetailVO;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"application"})
public class ApplicationController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "APP_JOB";
    @Autowired
    private IApplicationService service;
    @Autowired
    private IApplicationDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplicationVO> saveOrUpdate(@RequestBody ApplicationVO saveOrUpdateVO) {
        ApplicationEntity entity = (ApplicationEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApplicationEntity.class));
        if (entity.getId() == null) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setUseFlag(0);
            entity.setBillState(0);
        }
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setEmployeeId(userContext.getUserId());
        entity.setEmployeeName(userContext.getUserName());
        List<ApplicationDetailEntity> detailList = entity.getDetailList();
        BigDecimal taxMny = detailList.isEmpty() ? BigDecimal.ZERO : detailList.stream().map(ApplicationDetailEntity::getListTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setTaxMny(taxMny);
        if (null != entity.getOrgId()) {
            CommonResponse orgResp = this.iOrgApi.getOneById(entity.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u90e8id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getOrgId(), (Object)orgResp.getMsg());
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u90e8\u4fe1\u606f\u5931\u8d25\uff01");
            }
            OrgVO orgVO = (OrgVO)orgResp.getData();
            if (null != orgVO && null != orgVO.getParentId()) {
                entity.setParentOrgId(orgVO.getParentId());
                entity.setParentOrgName(orgVO.getpFName());
                CommonResponse parentOrgResp = this.iOrgApi.getOneById(orgVO.getParentId());
                if (!parentOrgResp.isSuccess()) {
                    this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u90e8parentId-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)orgVO.getParentId(), (Object)parentOrgResp.getMsg());
                    throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u90e8\u7236\u7ea7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                OrgVO parentOrgVO = (OrgVO)parentOrgResp.getData();
                if (null != parentOrgVO && null != parentOrgVO.getCode()) {
                    entity.setParentOrgCode(parentOrgVO.getCode());
                }
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ApplicationVO vo = (ApplicationVO)BeanMapper.map((Object)((Object)entity), ApplicationVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplicationVO> queryDetail(Long id) {
        ApplicationEntity entity = (ApplicationEntity)((Object)this.service.selectById(id));
        ApplicationVO vo = (ApplicationVO)BeanMapper.map((Object)((Object)entity), ApplicationVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplicationVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryPage"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplicationVO>> queryPage(@RequestBody QueryParam param) {
        IPage page;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        List dataList = new ArrayList();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("create_time", "desc");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (StringUtils.isNotBlank((CharSequence)authOrgIds)) {
            if (null == param.getParams().get("orgId")) {
                page = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            } else {
                page = this.service.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            page = this.service.queryPage(param, false);
            dataList = page.getRecords();
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        if (null == param.getOrderMap().get("createTime")) {
            orderMap.put("create_time", "desc");
        }
        param.setOrderMap(orderMap);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List applicationVOS = BeanMapper.mapList(dataList, ApplicationVO.class);
        applicationVOS.forEach(application -> application.setUseFlagStr(application.getUseFlag() == 1 ? "\u96f6\u5de5\u5df2\u767b\u8bb0" : "\u96f6\u5de5\u672a\u767b\u8bb0"));
        pageData.setRecords(applicationVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryApplication"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplicationVO>> queryApplication(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("taxMny");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billState));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        List dataList = page.getRecords();
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List applicationVOS = BeanMapper.mapList((Iterable)dataList, ApplicationVO.class);
        applicationVOS.forEach(application -> {
            application.setUseFlagStr(application.getUseFlag() == 1 ? "\u96f6\u5de5\u5df2\u767b\u8bb0" : "\u96f6\u5de5\u672a\u767b\u8bb0");
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("applicationId", new Parameter("eq", (Object)application.getId()));
            List applicationDetailEntities = this.detailService.queryList(queryParam, false);
            if (!applicationDetailEntities.isEmpty()) {
                application.setDetailList(BeanMapper.mapList((Iterable)applicationDetailEntities, ApplicationDetailVO.class));
            }
        });
        pageData.setRecords(applicationVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody ApplicationVO applicationVO) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.mnyCtrl(applicationVO));
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        ApplicationEntity entity = (ApplicationEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728\uff01");
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.mnyCtrl((ApplicationVO)BeanMapper.map((Object)((Object)entity), ApplicationVO.class)));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("taxMny");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useWorkTypeName");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        this.logger.info("\u5bfc\u51fa\u6570\u636e----{}", (Object)JSONObject.toJSONString((Object)pageData));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), ApplicationVO.class);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            DecimalFormat decimalFormat = new DecimalFormat("#,###.00");
            decimalFormat.setRoundingMode(RoundingMode.HALF_DOWN);
            for (ApplicationVO item : list) {
                item.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
                item.setContractTypeStr(item.getContractType().equals(0) ? "\u52b3\u52a1\u5206\u5305\u5408\u540c" : "\u4e13\u4e1a\u5206\u5305\u5408\u540c");
                item.setTimeStr(sdf.format(item.getCreateTime()));
                item.setUseFlagStr(null != item.getUseFlag() && item.getUseFlag().equals(1) ? "\u96f6\u5de5\u5df2\u767b\u8bb0" : "\u96f6\u5de5\u672a\u767b\u8bb0");
            }
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            beans.put("records", list);
            ExcelExport.getInstance().export("application-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/contractApplicationRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> contractApplicationRecord(@RequestParam Long id) {
        JSONObject resp = new JSONObject();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(id));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contract.getId());
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        query.orderByDesc((Object)"create_time");
        List list = this.service.list((Wrapper)query);
        resp.put("applicationList", (Object)BeanMapper.mapList((Iterable)list, ApplicationVO.class));
        BigDecimal totalApplicationTaxMny = BigDecimal.ZERO;
        for (ApplicationEntity item : list) {
            totalApplicationTaxMny = totalApplicationTaxMny.add(item.getTaxMny());
        }
        resp.put("contractTaxMny", (Object)contract.getContractTaxMny());
        resp.put("totalApplicationTaxMny", (Object)totalApplicationTaxMny);
        resp.put("applicationRatio", (Object)totalApplicationTaxMny.divide(contract.getContractTaxMny(), 8, 4));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }
}

