/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.DeductionEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.mapper.DeductionMapper;
import com.ejianc.business.process.service.IDeductionService;
import com.ejianc.business.process.vo.MeasureVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="deductionService")
public class DeductionServiceImpl
extends BaseServiceImpl<DeductionMapper, DeductionEntity>
implements IDeductionService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "DEDUCTION_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/deduction/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/deduction/billDel";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String billType = "BT211230000000006";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(DeductionEntity deductionEntity, String billTypeCode, CooperateVO cooperateVO) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + deductionEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(deductionEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u6263\u5956\u7f5a\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)deductionEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        deductionEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        deductionEntity.setTenantId(null);
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"DEDUCTION_BILL_SYNC", (int)600);
            if (!locked) {
                this.executeUpdate(deductionEntity.getId(), false);
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "DEDUCTION_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)deductionEntity)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(deductionEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u6263\u5956\u7f5a\u5355\u636e\u53c2\u6570-{}", (Object)deductionEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/deduction/billSync", paramMap, deductionEntity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse supResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (supResp.isSuccess()) {
                        this.executeUpdate(deductionEntity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(deductionEntity.getId(), false);
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u6263\u5956\u7f5a\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{deductionEntity.getId(), deductionEntity.getSupplierId(), supResp.getMsg()});
                    }
                } else {
                    this.executeUpdate(deductionEntity.getId(), false);
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u6263\u5956\u7f5a\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{deductionEntity.getId(), deductionEntity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.executeUpdate(deductionEntity.getId(), false);
                this.logger.error("\u83b7\u53d6\u6263\u5956\u7f5a\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)deductionEntity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.executeUpdate(deductionEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u6263\u5956\u7f5a\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{deductionEntity.getId(), deductionEntity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "DEDUCTION_BILL_SYNC");
        }
        return syncFlag;
    }

    private void executeUpdate(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delPushBill(DeductionEntity deductionEntity, String billTypeCode) {
        boolean locked = false;
        boolean delSuc = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + deductionEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u6263\u5956\u7f5a\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)deductionEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
        }
        deductionEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"DEDUCTION_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "DEDUCTION_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", deductionEntity.getId().toString());
            paramMap.put("sourceSystemId", deductionEntity.getSourceSystemId());
            this.logger.info("\u6263\u5956\u7f5a\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)deductionEntity.getSupplierId(), (Object)deductionEntity.getId());
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/deduction/billDel", RequestMethod.POST, JSONObject.toJSONString(paramMap), deductionEntity.getSupplierId().toString());
            if (syncReqResp.isSuccess()) {
                CommonResponse supResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (supResp.isSuccess()) {
                    delSuc = true;
                } else {
                    this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u6263\u5956\u7f5a\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{deductionEntity.getSupplierId(), deductionEntity.getId(), supResp.getMsg()});
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u6263\u5956\u7f5a\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{deductionEntity.getSupplierId(), deductionEntity.getId(), syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u6263\u5956\u7f5a\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)deductionEntity.getId(), (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "DEDUCTION_BILL_SYNC");
        }
        return delSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        DeductionEntity deductionEntity = (DeductionEntity)((Object)super.selectById((Serializable)((Object)billId)));
        deductionEntity.setSupOperateTime(supOperateTime);
        deductionEntity.setSupOperatorName(supOperatorName);
        deductionEntity.setSupOperatorPhone(supOperatorPhone);
        deductionEntity.setSupOperatorUserCode(supOperatorUserCode);
        deductionEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
        String key = "BT211230000000006::" + deductionEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"DEDUCTION_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u6263\u5956\u7f5a\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)deductionEntity.getId());
                this.releaseLock(jedis, false, key, "DEDUCTION_BILL_SYNC");
                String string = "\u6263\u5956\u7f5a\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, "BT211230000000006", authority, deductionEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            deductionEntity.setAttachIds(attchIdsList);
            deductionEntity.setSupplierSignStatus(MeasureVO.SUP_HAS_SIGNED_STATUS);
            super.saveOrUpdate((Object)deductionEntity, false);
            String msgSendResult = this.sendMsg(deductionEntity, "\u4f9b\u65b9\u5df2\u7b7e\u5b57\u63d0\u9192", "\u6263\u5956\u7f5a\u5355\u636e[" + deductionEntity.getBillCode() + "]\u4f9b\u65b9\u5df2\u7b7e\u5b57\u5b8c\u6210");
            if (null != msgSendResult) {
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u6263\u5956\u7f5a\u5355\u636eid-{}\u7b7e\u5b57\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])new Long[]{deductionEntity.getCreateUserId(), deductionEntity.getEmployeeId()}), deductionEntity.getId(), msgSendResult});
            }
        }
        catch (Exception e) {
            this.logger.error("\u6263\u5956\u7f5a\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)deductionEntity.getId(), (Object)e);
            msg = "\u6263\u5956\u7f5a\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "DEDUCTION_BILL_SYNC");
        }
        return msg;
    }

    private String sendMsg(DeductionEntity deductionEntity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{deductionEntity.getCreateUserId().toString(), deductionEntity.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(deductionEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

