/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.settlePayment.controller;

import com.ejianc.business.prosub.settlePayment.SettlePaymentDetailVO;
import com.ejianc.business.prosub.settlePayment.SettlePaymentVO;
import com.ejianc.business.prosub.settlePayment.bean.SettlePaymentEntity;
import com.ejianc.business.prosub.settlePayment.service.ISettlePaymentService;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.service.INodeSettleService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settlePayment"})
public class SettlePaymentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LABOR_SETTLE_PAYMENT";
    private static final String PRO_BILL_CODE = "PRO_SETTLE_PAYMENT";
    @Autowired
    private ISettlePaymentService service;
    @Autowired
    private INodeSettleService nodeSettleService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettlePaymentVO> saveOrUpdate(@RequestBody SettlePaymentVO saveOrUpdateVO) {
        SettlePaymentEntity entity = (SettlePaymentEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettlePaymentEntity.class));
        Boolean flag = this.nodeSettleService.addSettlePaymentFlag(entity.getSettleId(), entity.getId());
        if (!flag.booleanValue()) {
            return CommonResponse.error((String)"\u8be5\u7ed3\u7b97\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u652f\u4ed8\u6bd4\u4f8b\u786e\u8ba4\u5355\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)(entity.getContractType() == 0 ? BILL_CODE : PRO_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SettlePaymentVO vo = (SettlePaymentVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), SettlePaymentVO.class);
        List voList = vo.getSettlePaymentDetailList();
        if (!voList.isEmpty()) {
            for (SettlePaymentDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettlePaymentDetailList(TreeNodeBUtil.buildTree((List)voList));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlePaymentVO> queryDetail(Long id) {
        SettlePaymentEntity entity = (SettlePaymentEntity)((Object)this.service.selectById(id));
        SettlePaymentVO vo = (SettlePaymentVO)BeanMapper.map((Object)((Object)entity), SettlePaymentVO.class);
        List voList = vo.getSettlePaymentDetailList();
        if (!voList.isEmpty()) {
            for (SettlePaymentDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettlePaymentDetailList(TreeNodeBUtil.buildTree((List)voList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlePaymentVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/addConvertBySettleId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettlePaymentVO> addConvertBySettleId(Long settleId) {
        SettlePaymentVO vo = this.service.addConvertBySettleId(settleId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

