package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanMapper;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanDetailService;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包总计划实体
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private IPlanChangeService planChangeService;

    @Autowired
    private IPlanDetailService planDetailService;

    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IDutyApi dutyApi;

    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    // 【目标成本劳务分包价格】控【劳务分包总计划】
    private final String LAB_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-D12WrV0223";
    // 【目标成本专业分包价格】控【专业分包总计划】
    private final String PRO_TARGET_COST_PRICE_CTRL_PLAN_PRICE = "P-yPfPb50221";

    //【分包清单历史最高价】 控【劳务分包总计划】
    private final String LAB_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-W3h8660273";
    //【分包清单历史最高价】 控【专业分包总计划】
    private final String PRO_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE = "P-Ic8ufh0276";
    //【分包清单历史最低价】 控【劳务分包总计划】
    private final String LAB_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-033zg70274";
    //【分包清单历史最低价】 控【专业分包总计划】
    private final String PRO_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE = "P-5cB3y00275";

    @Override
    public PlanVO queryByCode(String planCode) {
        PlanVO resp = null;
        QueryWrapper<PlanEntity> query = new QueryWrapper<>();
        query.eq("bill_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PlanEntity entity = planMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO queryByProjectId(Long projectId, Integer subType) {
        PlanVO resp = null;
        QueryWrapper<PlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("sub_type", subType);
        query.eq("dr", BaseVO.DR_UNDELETE);
        PlanEntity entity = planMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, PlanVO.class);
        }
        return resp;
    }

    @Override
    public PlanVO saveOrUpdateMasterPlan(PlanEntity saveEntity, Boolean isControl) {
        if(Boolean.FALSE.equals(isControl)) {
            //更新子表信息
            super.saveOrUpdate(saveEntity, false);
        }
        PlanVO planVO = null;
        List<PlanDetailEntity> detailEntityList = saveEntity.getPlanDetailList();
        if(CollectionUtils.isNotEmpty(detailEntityList)){
            if (Boolean.FALSE.equals(isControl)) {
                planVO = queryDetail(saveEntity.getId(), true);
            } else {
                planVO = BeanMapper.map(saveEntity, PlanVO.class);
            }
        }
        return planVO;
    }

    @Override
    public PlanVO queryDetail(Long id, boolean detailHasChildren) {
        PlanEntity masterPlanEntity = super.selectById(id);
        PlanVO masterPlanVO =  BeanMapper.map(masterPlanEntity, PlanVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("planId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<PlanDetailEntity> detailEntityListDb = planDetailService.queryList(queryParam, false);
        List<PlanDetailEntity> detailEntityList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }
        //设置总计划详情
        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(PlanDetailEntity cdEntity : detailEntityList){
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
            }
            List<PlanDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, PlanDetailVO.class);

            //判断当前清单是否被下游引用，如果引用，则该条数据不能被删除。
            //判断清单是否被下游数据引用（合同、招标）
            List<PlanDetailVO> usefulDetailList = selectUsefulByIds(resultMapList.stream().map(PlanDetailVO::getId).collect(Collectors.toList()));

            LinkedHashMap<Long, Integer> usefulDetailMap = new LinkedHashMap<>();
            if (CollectionUtils.isNotEmpty(usefulDetailList)){
                for (PlanDetailVO c : usefulDetailList){
                    usefulDetailMap.put(c.getId(), c.getUseNum());
                }
            }
            for (PlanDetailVO c : resultMapList){
                if (null != usefulDetailMap.get(c.getId())){
                    //如果被下游引用，则改变rowState不能删除
                    c.setUseNum(1);
                    c.setRowState("edit");
                }else {
                    c.setUseNum(null);
                }
            }


            if(detailHasChildren){
                masterPlanVO.setPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }else {
                masterPlanVO.setPlanDetailList(resultMapList);
            }
        } else {
            masterPlanVO.setPlanDetailList(BeanMapper.mapList(detailEntityList, PlanDetailVO.class));
        }

        if(null != masterPlanEntity.getChangeVersion() && masterPlanEntity.getChangeVersion() > 0){
            masterPlanVO.setPlanChangeHisList(planChangeService.queryDetailRecord(masterPlanEntity.getId()));
        }

        return masterPlanVO;
    }

    //查询当前明细id集合中的id是否被下游业务使用（合同、定标）
    @Override
    public List<PlanDetailVO> selectUsefulByIds(List<Long> planIdList) {
        return planMapper.selectUsefulByIds(planIdList);
    }

    @Override
    public List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId) {
        return planMapper.getContrastInfo(planId,oldPlanId);
    }


    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<PlanDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, PlanDetailEntity.class));
        }
    }

    @Override
    public ExecutionVO targetCost(PlanVO planVO, String linkUrl, Integer subType){
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(planVO.getId());
        totalVO.setTenantId(planVO.getTenantId());
        totalVO.setBillCode(planVO.getBillCode());
        totalVO.setOrgId(planVO.getOrgId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (subType==0){
            totalVO.setBillType(ProsubBillTypeEnum.劳务分包总计划.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包总计划.getCode());
        }else {
            totalVO.setBillType(ProsubBillTypeEnum.专业分包总计划.getBillTypeCode());
            totalVO.setBussinessType(BussinessTypeEnum.专业分包总计划.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.计划.getCode());
        totalVO.setProjectId(planVO.getProjectId());
        totalVO.setOrgId(planVO.getOrgId());
        totalVO.setMoney(planVO.getTotalPlanMny()); //总计划金额无税
        totalVO.setTaxMoney(planVO.getTotalPlanTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        if(null != planVO.getCreateTime()) {
            totalVO.setBillDate(sdf.format(planVO.getCreateTime()));
        }
        totalVO.setMemo(planVO.getMemo());

        if (CollectionUtils.isNotEmpty(planVO.getPlanDetailList())) {
            List<PlanDetailVO> planDetailVOS = planVO.getPlanDetailList().stream().filter(item -> item.getLeafFlag() && !"del".equals(item.getRowState())).collect(Collectors.toList());
            Assert.notEmpty(planDetailVOS, "计划明细不能为空");
            for (PlanDetailVO planDetailVO : planDetailVOS) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId());
                detailExecutionVO.setSourceBillId(planDetailVO.getPlanId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId()); // 档案分类id
                // 根据档案id判断是否是分类
                if (planDetailVO.getDocId()==null){
                    detailExecutionVO.setCategoryFlag(true);
                }else {
                    detailExecutionVO.setCategoryFlag(false);
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(false);

                // 根据档案分类id查询档案分类信息
                Assert.notNull(planDetailVO.getDocCategoryId(), "档案分类id不能为空");
                if (0 == subType){
                    // 劳务分包
                    CommonResponse<LabsubCategoryVO> res = shareLabsubApi.queryLabSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        logger.error("根据档案分类id查询劳务分包档案分类信息失败,档案分类ID:{}",planDetailVO.getDocCategoryId());
                        throw new BusinessException("根据分类ID查询劳务分包档案分类信息失败!");
                    }
                    LabsubCategoryVO categoryVO = res.getData();
                    if (categoryVO==null){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                } else {
                    // 专业分包
                    CommonResponse<ProsubCategoryVO> res = shareLabsubApi.queryMajorSubByCategoryId(planDetailVO.getDocCategoryId());
                    if (!res.isSuccess() || res.getData() == null) {
                        logger.error("根据档案分类id查询专业分包档案分类信息失败,档案分类ID:{}",planDetailVO.getDocCategoryId());
                        throw new BusinessException("根据分类ID查询专业分包档案分类信息失败!");
                    }
                    ProsubCategoryVO categoryVO = res.getData();
                    if (categoryVO==null){
                        detailExecutionVO.setCategoryInnerCode(null);
                        detailExecutionVO.setCategoryCode(null);
                    }else {
                        detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                        detailExecutionVO.setCategoryCode(categoryVO.getCategoryCode());
                        detailExecutionVO.setCategoryName(categoryVO.getCategoryName());
                    }
                }

                // 档案id
                Assert.notNull(planDetailVO.getDocId(), "档案id不能为空");
                detailExecutionVO.setDocId(planDetailVO.getDocId());
                if (subType==0){
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                }else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                }
                detailExecutionVO.setCode(planDetailVO.getDetailCode());
                detailExecutionVO.setName(planDetailVO.getDetailName());

                // todo:增加单位id
                // detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setPrice(planDetailVO.getPlanPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getPlanTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                if(null != planDetailVO.getCreateTime()) {
                    detailExecutionVO.setBillDate(sdf.format(planDetailVO.getCreateTime()));
                }
                detailExecutionVO.setMemo(planDetailVO.getMemo());
                detailExecutionVO.setSpec(planDetailVO.getDetailMeasureRules());
                detailExecutionVO.setUnitName(planDetailVO.getUnit());
                detailExecutionVO.setNum(planDetailVO.getPlanNum());
                detailExecutionVO.setMoney(planDetailVO.getPlanMny());
                detailExecutionVO.setTaxMoney(planDetailVO.getPlanTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public List<ParamsCheckVO> targetCostPriceCtrlPlanPrice(PlanVO planVO) {
        logger.info("prosub---PlanServiceImpl---targetCostPriceCtrlPlanPrice()--- 目标成本价控总计划价入参：{}", JSONObject.toJSONString(planVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        Integer contractType = planVO.getSubType();// 合同类型： 劳务分包-0，专业分包-1
        List<PlanDetailVO> detailList = planVO.getPlanDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_TARGET_COST_PRICE_CTRL_PLAN_PRICE, planVO.getOrgId());
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_TARGET_COST_PRICE_CTRL_PLAN_PRICE, planVO.getOrgId());
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询目标成本价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数目标成本价查询结果：{}", JSONObject.toJSONString(maxParamByCode));
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果

        List<Long> docIds = detailList.stream().filter(item -> null != item.getDetailName()).map(PlanDetailVO::getDocId).collect(Collectors.toList());
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(planVO.getProjectId(), 0 == contractType ? DocTypeEnum.劳务分包档案.getCode() : DocTypeEnum.专业分包档案.getCode() , docIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVOList;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();

        logger.info("目标成本价参数控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        if (null == dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVOList;
        }
        logger.info("目标成本价map信息返回："+JSONObject.toJSONString(dutyMap));
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(maxParamVOS)){
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (PlanDetailVO detailVO: detailList) {//遍历明细
                    if (null != detailVO.getPlanNum() && !"del".equals(detailVO.getRowState())){
                        BigDecimal maxPrice = !dutyMap.containsKey(detailVO.getDocId()) || null == dutyMap.get(detailVO.getDocId()) ? BigDecimal.ZERO : dutyMap.get(detailVO.getDocId()).setScale(4, BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                        BigDecimal price = null == detailVO.getPlanPrice() ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//档案单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        logger.info("marpriceparam:{},price:{},maxprice:{}", maxPriceParam,price,maxPrice);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName() + (detailVO.getWorkContent() == null ? "" : "+" + detailVO.getWorkContent()));
                            paramsCheckDsVO.setWarnName("计划单价大于目标成本单价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("计划单价：").append(price)
                                    .append("元，目标成本单价：(").append(maxPrice)
                                    .append("元),目标成本单价*").append(roleValueMax).append("%：").append(maxPriceParam)
                                    .append("元，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4, BigDecimal.ROUND_HALF_UP)).append("元");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlPlanPrice(PlanVO planVO) {
        logger.info("prosub---PlanServiceImpl---historyPriceCtrlPlanPrice()--- 历史价控总计划价入参：{}", JSONObject.toJSONString(planVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
        Integer contractType = planVO.getSubType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        Integer princeDepot = null;
        List<PlanDetailVO> detailList = planVO.getPlanDetailList();

        // 劳务
        if (0 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE, planVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE, planVO.getOrgId());
            princeDepot = PrinceDepotEnum.劳务分包价格库.getCode();
        }
        // 专业
        if (1 == contractType) {
            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MAX_PRICE_CTRL_PLAN_PRICE, planVO.getOrgId());
            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MIN_PRICE_CTRL_PLAN_PRICE, planVO.getOrgId());
            princeDepot = PrinceDepotEnum.专业分包价格库.getCode();
        }
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("总计划历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("总计划历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        // 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(princeDepot));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(princeDepot);
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (PlanDetailVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("总计划清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPlanPrice()==null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("总计划清单单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("总计划清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (PlanDetailVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("总计划清单：{}--高价：{}---低价：{}",detailVO.getDetailName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPlanPrice()==null ? BigDecimal.ZERO : detailVO.getPlanPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//清单单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getDetailName());
                            paramsCheckDsVO.setWarnName("总计划清单单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("总计划清单单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }
}
