package com.ejianc.business.plan.service;

import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.business.plan.vo.PlanDetailChangeVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Collection;
import java.util.List;

/**
 * 分包总计划变更实体
 * 
 * @author generator
 * 
 */
public interface IPlanChangeService extends IBaseService<PlanChangeEntity> {

    /**
     * 查询指定计划对应的未完成的变更
     *
     * @param sourcePlanId
     * @return
     */
    PlanChangeEntity getUnFinishedChange(Long sourcePlanId);

    /**
     * 保存更新总计划变更
     *
     * @param saveEntity
     * @return
     */
    PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity, Boolean isControl);

    /**
     * 根据Id删除对应的变更单据，并恢复计划单据的变更信息
     *
     * @param changeIds
     */
    void deleteChangePlan(List<Long> changeIds);

    List<PlanChangeHisVO> queryDetailRecord(Long id);

    PlanChangeVO queryDetail(Long id, boolean detailHasChildren);

    List<PlanDetailChangeVO> selectUsefulByIds(List<Long> planIdList);

    /**
     * @param planChangeVO 变更单据
     * @param linkUrl 详情页地址
     * @param subType 变更单子类型
     * @param billTypeCode 单据类型编码
     * @param lastSourceId 是否需要传递上一版本业务单据Id
     * @return
     */
    ExecutionVO targetCost(PlanChangeVO planChangeVO, String linkUrl, Integer subType, String billTypeCode, boolean lastSourceId);

    ExecutionVO getLastExecutionVO(Long sourcePlanId);

    /**
     * 目标成本价控总计划价
     * @param planChangeVO
     * @return
     */
    List<ParamsCheckVO> targetCostPriceCtrlPlanPrice(PlanChangeVO planChangeVO);

    List<ParamsCheckVO> historyPriceCtrlPlanPrice(PlanChangeVO planChangeVO);
}
