package com.ejianc.business.prosub.mapper;

import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.vo.ContractSettleDetailsReportVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 分包合同实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {

    /**
     * 根据ID修改合同履约状态
     * @param id 主键ID
     */
    Integer updatePerformanceStatusById(@Param("id") Long id);

    // 查询合同下所有单项结算末级清单-查询数据-select *
    List<ContractSettleDetailsReportVO> querySettleDetails(Map<String, Object> queryMap);

    // 查询合同下所有单项结算末级清单--查询总条数-select count(1)
    Long querySettleDetailsCount(Map<String, Object> queryMap);

    // 查询合同下所有单项结算末级清单-穿透到查询当前合同清单对应的结算类型的所有结算清单--查询数据-select *
    List<ContractSettleDetailsReportVO> queryLabProSettleDetailsList(Map<String, Object> queryMap);

    // 查询合同下所有单项结算末级清单-穿透到查询当前合同清单对应的结算类型的所有结算清单--查询总条数-select count(1)
    Long queryLabProSettleDetailsListCount(Map<String, Object> queryMap);

    List<Map<String, Object>> queryCountConNum(@Param("contractType") Integer contractType,
                                               @Param("tenantId") Long tenantId,
                                               @Param("projectId") Long projectId,
                                               @Param("cdIdList") List<Long> cdIdList);

    Map<String, Object> queryCountConTaxMny(@Param("contractType") Integer contractType,
                                               @Param("tenantId") Long tenantId,
                                               @Param("projectId") Long projectId,
                                               @Param("contractId") Long contractId,
                                            @Param("mainContractId") Long mainContractId);

}
