package com.ejianc.business.plan.service;

import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.vo.PlanContrastV0;
import com.ejianc.business.plan.vo.PlanDetailVO;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Collection;
import java.util.List;

/**
 * 分包总计划实体
 * 
 * @author generator
 * 
 */
public interface IPlanService extends IBaseService<PlanEntity> {

    /**
     * 根据编码查询物资总计划
     *
     * @param planCode
     * @return
     */
    PlanVO queryByCode(String planCode);

    /**
     * 根据项目Id来查询物资总计划
     *
     * @param projectId
     * @param subType
     * @return
     */
    PlanVO queryByProjectId(Long projectId, Integer subType);

    /**
     * 保存或更新物资总计划
     *
     * @param saveEntity
     */
    PlanVO saveOrUpdateMasterPlan(PlanEntity saveEntity, Boolean isControl);

    PlanVO queryDetail(Long id, boolean detailHasChildren);
    /**
     * 获取分包总计划对比信息
     *
     * @param
     */
    List<PlanContrastV0> getContrastInfo(Long planId, Long oldPlanId);

    List<PlanDetailVO> selectUsefulByIds(List<Long> planIdList);

    ExecutionVO targetCost(PlanVO planVO, String linkUrl, Integer subType);

    /**
     * 目标成本价控总计划价
     * @param planVO
     * @return
     */
    List<ParamsCheckVO> targetCostPriceCtrlPlanPrice(PlanVO planVO);

    List<ParamsCheckVO> historyPriceCtrlPlanPrice(PlanVO planVO);
}
