/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping
public class PlanApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanService planService;

    @GetMapping(value={"/api/plan/queryPlanByProjectId"})
    @ResponseBody
    CommonResponse<List<PlanVO>> queryPlanByProjectId(@RequestParam(value="projectId") Long projectId, @RequestParam(value="subType") Integer subType) {
        if (null == projectId || null == subType) {
            return CommonResponse.error((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u9879\u76eeid\u548c\u5206\u5305\u7c7b\u578b\uff01");
        }
        this.logger.info("\u63a5\u6536\u6570\u636e\uff1aprojectId{}\uff0csubType{}", (Object)projectId, (Object)subType);
        ArrayList<PlanVO> planVOList = new ArrayList<PlanVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"id"});
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"sub_type", (Object)subType);
        List planList = this.planService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)planList)) {
            for (PlanEntity planEntity : planList) {
                planVOList.add(this.planService.queryDetail(planEntity.getId(), false));
            }
        }
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76eeid\u548c\u5206\u5305\u7c7b\u578b\u67e5\u8be2\u603b\u8ba1\u5212\uff01", planVOList);
    }
}

