package com.ejianc.business.plan.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 总计划实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping
public class PlanApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPlanService planService;

    /**
     * 根据项目id和分包类型查询总计划
     * @param projectId
     * @param subType
     * @return
     */
    @GetMapping(value = "/api/plan/queryPlanByProjectId")
    @ResponseBody
    CommonResponse<List<PlanVO>> queryPlanByProjectId(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "subType") Integer subType){
        if (null == projectId || null == subType){
            return CommonResponse.error("请传入正确的项目id和分包类型！");
        }
        logger.info("接收数据：projectId{}，subType{}", projectId, subType);
        List<PlanVO> planVOList = new ArrayList<>();
        QueryWrapper<PlanEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id");
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", 1,3);
        queryWrapper.eq("sub_type", subType);
        List<PlanEntity> planList = planService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(planList)){
            for (PlanEntity planEntity : planList) {
                planVOList.add(planService.queryDetail(planEntity.getId(),false));
            }
        }
        return CommonResponse.success("根据项目id和分包类型查询总计划！", planVOList);
    }

}
