package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.enums.UseFlagEnum;
import com.ejianc.business.process.mapper.RegistrationMapper;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.vo.RegistrationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 零工登记主实体
 *
 * @author generator
 */
@Service("registrationService")
public class RegistrationServiceImpl extends BaseServiceImpl<RegistrationMapper, RegistrationEntity> implements IRegistrationService {

    // 劳务分包-零工申请，劳务分包-零工登记
    private static final String LAB_CHECK_PARAM_CODE = "P-34v45349";

    @Autowired
    private JedisPool jedisPool;

    private final String OPERATE = "REGISTRATION_BILL_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/registration/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/registration/billDel";

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * 零工登记单单据类型编码
     */
    private final String billType = "BT211230000000003";
    // 专业分包-零工申请，专业分包-零工登记
    private static final String PRO_CHECK_PARAM_NAME = "P-0lV6mY50";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IApplicationService applicationService;

    @Override
    public CommonResponse<RegistrationVO> getCommonById(Long id) {
        RegistrationEntity entity = this.selectById(id);
        return CommonResponse.success(BeanMapper.map(entity, RegistrationVO.class));
    }

    @Override
    public boolean pushBillToSupCenter(RegistrationEntity entity, String billTypeCode, CooperateVO cooperateVO) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(entity.getId(), false);
            logger.error("推送零工登记单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSourceSystemId(ejcCloudSystemCode.getData());
        // 清空租户ID
        entity.setTenantId(null);

        if(CollectionUtils.isNotEmpty(entity.getDeductList())) {
            entity.getDeductList().forEach(item -> item.setTenantId(null));
        }
        if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(item -> item.setTenantId(null));
        }

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                this.executeUpdate(entity.getId(), false);
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(entity));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();

                //Map<fileName, fileSourceType>
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                logger.info("向供应商-{}推送零工登记单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> supResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (supResp.isSuccess()) {
                        this.executeUpdate(entity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(entity.getId(), false);
                        logger.error("供方id-{}处理零工登记单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                    }
                } else {
                    this.executeUpdate(entity.getId(), false);
                    logger.error("发送请求推送零工登记单据id-{}给供方id-{} 失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                this.executeUpdate(entity.getId(), false);
                logger.error("获取零工登记单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            this.executeUpdate(entity.getId(), false);
            logger.error("推送零工登记单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    private <T extends BaseEntity> void clearTenantId(List<T> entityList) {
        entityList.forEach(item -> {
            item.setTenantId(null);
        });
    }


    /**
     * 更新单据推送状态
     *
     * @param id   单据id
     * @param flag 是否成功推送
     */
    private void executeUpdate(Long id, Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<RegistrationEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }


    @Override
    public boolean delPushBill(RegistrationEntity entity, String billTypeCode) {
        boolean locked = false, delSuc = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送零工登记单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        entity.setSourceSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("sourceId", entity.getId().toString());
            paramMap.put("sourceSystemId", entity.getSourceSystemId());

            logger.info("零工登记单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());

            //推送单据到指定的供方
            CommonResponse<String> syncReResp = systemDataPushService.exchangeDataWithEachLinkSystem(DEL_SUP_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReResp.isSuccess()) {
                CommonResponse<String> supResp = JSONObject.parseObject(syncReResp.getData(), CommonResponse.class);
                if (supResp.isSuccess()) {
                    delSuc = true;
                } else {
                    logger.error("供方-{}处理作废零工登记单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), supResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{}零工登记单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("通知供方零工登记单据id-{}作废异常，", entity.getId(), e);
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return delSuc;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        RegistrationEntity entity = super.selectById(billId);
        //设置供方签字信息
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);

        String key = billType + "::" + entity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("零工登记单据id-{}签字信息回写加锁失败！", entity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "零工登记单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, billType, authority, entity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            entity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());

            //更新单据
            super.saveOrUpdate(entity, false);

            //向单据制单人和经办人推送该消息
            String msgSendResult = sendMsg(entity, "供方已签字提醒", "零工登记单据[" + entity.getBillCode() + "]供方已签字完成");
            if (null != msgSendResult) {
                logger.error("向用户-{}发送零工登记单据id-{}签字提醒失败，原因：{}", StringUtils.join(entity.getCreateUserId(), entity.getEmployeeId()),
                        entity.getId(), msgSendResult);
            }
        } catch (Exception e) {
            logger.error("零工登记单据id-{}签字信息回写异常，", entity.getId(), e);
            msg = "零工登记单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    private String sendMsg(RegistrationEntity entity, String subject, String content) {
        String[] msgRecUserIds = new String[]{entity.getCreateUserId().toString(), entity.getEmployeeId().toString()};
        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }


    @Override
    public ParamsCheckVO mnyCtrl(RegistrationVO registrationVO) {

        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();

        CommonResponse<List<BillParamVO>> billParamByCode = new CommonResponse<>();
        // 劳务分包合同
        if (0 == registrationVO.getContractType()) {
            //查询是否为零工合同，若是零工合同则不受参数控制
            ContractEntity contract = contractService.selectById(registrationVO.getContractId());
            if(!"laborSub-2".equals(contract.getContractCategoryProperty())) {
                billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, registrationVO.getOrgId());
            } else {
                logger.info("零工登记-【{}】所属合同-【{}】为零工合同，不进行参数控制！", JSONObject.toJSONString(registrationVO), JSONObject.toJSONString(contract));
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }

        }
        // 专业分包合同
        if (1 == registrationVO.getContractType()) {
            billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, registrationVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            logger.info("获取控制参数配置失败！");
            throw new BusinessException("获取控制参数配置失败！");
        }

        List<BillParamVO> data = billParamByCode.getData();
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        for (BillParamVO billParamVO : data) {
            List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            // 控制规则值
            BigDecimal roleValue = billParamVO.getRoleValue();

            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            if (!"none".equals(paramsCheck.getWarnType())) {
                // 金额计算

                // 最新版本合同金额，最新的合同金额
                ContractEntity contract = contractService.selectById(registrationVO.getContractId());
                if (null == contract) {
                    logger.info("获取合同信息失败！");
                    throw new BusinessException("获取合同信息失败！");
                }
                // 合同金额
                BigDecimal contractTaxMny = contract.getContractTaxMny().multiply(roleValue.divide(BigDecimal.valueOf(100), 2, RoundingMode.HALF_UP));

                // 本次零工登记金额
                BigDecimal taxMny = registrationVO.getTotalTaxMny();

                // 零工金额： 该合同所有【零工登记金额+零工申请未被零工登记引用金额+本次零工登记金额】
                BigDecimal totalTaxMny = BigDecimal.ZERO;

                // 零工登记金额
                QueryWrapper<RegistrationEntity> qw = new QueryWrapper<>();
                qw.eq("contract_id", registrationVO.getContractId());
                if (null != registrationVO.getId()){
                    qw.ne("id", registrationVO.getId());
                }
                List<RegistrationEntity> res = super.list(qw);
                if (CollectionUtils.isNotEmpty(res)) {
                    totalTaxMny = res.stream().map(RegistrationEntity::getTotalTaxMny).reduce(taxMny, BigDecimal::add);
                }else {
                    totalTaxMny = taxMny;
                }

                // 零工申请未被零工登记引用金额
                QueryWrapper<ApplicationEntity> ae = new QueryWrapper<>();
                ae.eq("contract_id", registrationVO.getContractId());
                ae.eq("use_flag", UseFlagEnum.零工未登记.getCode());
                List<ApplicationEntity> aes = applicationService.list(ae);
                if (CollectionUtils.isNotEmpty(aes)) {
                    totalTaxMny = aes.stream().map(ApplicationEntity::getTaxMny).reduce(totalTaxMny, BigDecimal::add);
                }


                // 控制金额
                if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                    // 超结金额
                    BigDecimal overTaxMny = totalTaxMny.subtract(contractTaxMny);

                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem("零工超合同");
                    paramsCheckDsVO.setWarnName("累计零工金额大于合同金额");

                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次零工金额：").append(taxMny.setScale(2, RoundingMode.DOWN)).append("，含本次累计零工金额：").append(totalTaxMny.setScale(2, RoundingMode.DOWN))
                            .append("，合同金额*").append(roleValue).append("%：").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("。超结金额：").append(overTaxMny.setScale(2, RoundingMode.DOWN));

                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    checkDsVOS.add(paramsCheckDsVO);
                    paramsCheck.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheck);
                } else {
                    // 未超结金额
                    paramsCheck.setWarnType(paramsArray[0]);
                }
            }
        }

        //设置最高预警登记
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));

        List<ParamsCheckVO> result = new ArrayList<>();
        if(null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if(null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for(ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }

        return paramsCheckVO;
    }

    /**
     * 更新零工申请登记状态
     *
     * @param applicationId  零工申请单id
     * @param userFlag 登记状态
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateUseFlag(Long applicationId, Integer userFlag) {
        Assert.notNull(applicationId, "零工申请单id不能为空！");
        Assert.notNull(userFlag, "登记状态不能为空！");

        // 更新零工申请登记状态
        UpdateWrapper<ApplicationEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", applicationId);
        updateWrapper.set("use_flag", userFlag);
        applicationService.update(updateWrapper);
    }


}
