/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.PicKingEntity;
import com.ejianc.business.process.bean.PicKingStoreEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IPicKingStoreService;
import com.ejianc.business.process.service.IPicKingTotalService;
import com.ejianc.business.process.service.IPickingEquipmentService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.vo.PicKingStoreVO;
import com.ejianc.business.process.vo.PicKingTotalVO;
import com.ejianc.business.process.vo.PicKingVO;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"picking"})
public class PickingController {
    private static final String BILL_CODE = "PICK_S";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPickingService service;
    @Autowired
    private IPicKingStoreService storeService;
    @Autowired
    private IPicKingTotalService totalService;
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IPickingEquipmentService equipmentService;
    private final String billTypeCode = "BT220117000000002";
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/picking/card";
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<PicKingVO> saveOrUpdate(@RequestBody PicKingVO saveorUpdateVO) {
        PicKingEntity entity = (PicKingEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PicKingEntity.class));
        if (entity.getId() == null) {
            FlowVO flowVO;
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setId(IdWorker.getId());
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            ArrayList<FlowVO> detail = new ArrayList<FlowVO>();
            if (entity.getOutList().size() > 0) {
                List<PicKingStoreEntity> outList = entity.getOutList();
                for (PicKingStoreEntity p : outList) {
                    p.setId(IdWorker.getId());
                    p.setPickingId(entity.getId());
                    flowVO = new FlowVO();
                    flowVO.setSettleDetailId(p.getId());
                    flowVO.setSourceId(p.getSourceId());
                    flowVO.setSourceDetailId(p.getSourceDetailId());
                    detail.add(flowVO);
                }
            }
            if (entity.getExitList().size() > 0) {
                List<PicKingStoreEntity> exitList = entity.getExitList();
                for (PicKingStoreEntity p : exitList) {
                    p.setId(IdWorker.getId());
                    p.setPickingId(entity.getId());
                    flowVO = new FlowVO();
                    flowVO.setSettleDetailId(p.getId());
                    flowVO.setSourceId(p.getSourceId());
                    flowVO.setSourceDetailId(p.getSourceDetailId());
                    detail.add(flowVO);
                }
            }
            StoreApiVO storeApiVO = new StoreApiVO();
            storeApiVO.setSettleCode(entity.getBillCode());
            storeApiVO.setSettleId(entity.getId());
            storeApiVO.setSettleDate(entity.getSettleDate());
            storeApiVO.setSettleFlag(Integer.valueOf(1));
            storeApiVO.setDetail(detail);
            CommonResponse stringCommonResponse = this.accountSettleApi.changeSettleFlag(storeApiVO);
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PicKingVO vo = (PicKingVO)BeanMapper.map((Object)((Object)entity), PicKingVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<PicKingVO> queryDetail(Long id) {
        QueryWrapper picKingWrapper = new QueryWrapper();
        picKingWrapper.eq((Object)"id", (Object)id);
        picKingWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        PicKingEntity entity = (PicKingEntity)((Object)this.service.getOne((Wrapper)picKingWrapper));
        this.logger.info(JSONObject.toJSONString((Object)((Object)entity)) + "@@@@@@@@@@@@@@@@@@@");
        if (entity != null) {
            QueryParam queryExit = new QueryParam();
            queryExit.getParams().put("picking_id", new Parameter("eq", (Object)entity.getId()));
            queryExit.getParams().put("return_store_flag", new Parameter("eq", (Object)1));
            List picKingStoreExit = this.storeService.queryList(queryExit, false);
            entity.setExitList(picKingStoreExit);
            QueryParam queryOut = new QueryParam();
            queryOut.getParams().put("picking_id", new Parameter("eq", (Object)entity.getId()));
            queryOut.getParams().put("return_store_flag", new Parameter("eq", (Object)0));
            List picKingStoreOut = this.storeService.queryList(queryOut, false);
            entity.setOutList(picKingStoreOut);
            QueryParam queryTotal = new QueryParam();
            queryTotal.getParams().put("picking_id", new Parameter("eq", (Object)entity.getId()));
            List totalEntities = this.totalService.queryList(queryTotal, false);
            entity.setTotalList(totalEntities);
            QueryParam queryEqu = new QueryParam();
            queryEqu.getParams().put("picking_id", new Parameter("eq", (Object)entity.getId()));
            List totalEquip = this.equipmentService.queryList(queryEqu, false);
            entity.setEquipmentList(totalEquip);
        }
        PicKingVO vo = (PicKingVO)BeanMapper.map((Object)((Object)entity), PicKingVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<PicKingVO> vos) {
        List collect = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : collect) {
            CommonResponse<PicKingVO> picKingVOCommonResponse = this.queryDetail(id);
            if (!picKingVOCommonResponse.isSuccess()) {
                // empty if block
            }
            PicKingVO entity = (PicKingVO)picKingVOCommonResponse.getData();
            this.toStore(entity, 0);
            this.service.deletePicking(id);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private void toStore(PicKingVO entity, Integer flag) {
        FlowVO flowVO;
        StoreApiVO storeApiVO = new StoreApiVO();
        storeApiVO.setSettleId(entity.getId());
        storeApiVO.setSettleFlag(flag);
        ArrayList<FlowVO> detail = new ArrayList<FlowVO>();
        if (entity.getOutList().size() > 0) {
            List outList = entity.getOutList();
            for (PicKingStoreVO p : outList) {
                flowVO = new FlowVO();
                flowVO.setSettleDetailId(p.getId());
                flowVO.setSourceId(p.getSourceId());
                flowVO.setSourceDetailId(p.getSourceDetailId());
                detail.add(flowVO);
            }
        }
        if (entity.getExitList().size() > 0) {
            List exitList = entity.getExitList();
            for (PicKingStoreVO p : exitList) {
                flowVO = new FlowVO();
                flowVO.setSettleDetailId(p.getId());
                flowVO.setSourceId(p.getSourceId());
                flowVO.setSourceDetailId(p.getSourceDetailId());
                detail.add(flowVO);
            }
        }
        storeApiVO.setDetail(detail);
        CommonResponse stringCommonResponse = this.accountSettleApi.changeSettleFlag(storeApiVO);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<PicKingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PicKingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPicKingData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<PicKingVO>> refPicKingData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="searchObject", required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PicKingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("create_time", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), PicKingVO.class);
            list.stream().forEach(item -> item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription()));
            HashMap<String, List> beans = new HashMap<String, List>(list.size());
            this.logger.error(JSONObject.toJSONString((Object)list));
            beans.put("records", list);
            ExcelExport.getInstance().export("pincking-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/queryTotalNum"}, method={RequestMethod.POST})
    public CommonResponse<List<PicKingTotalVO>> queryAlreadyApplyMny(@RequestBody PicKingVO vo) {
        List<PicKingTotalVO> entities = this.totalService.totalSumList(vo.getContractId(), vo.getProjectId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", entities);
    }

    @RequestMapping(value={"/queryPicking"}, method={RequestMethod.POST})
    public CommonResponse<PicKingVO> queryPicking(@RequestBody PicKingVO vo) {
        return this.service.queryPicking(vo.getContractId(), vo.getProjectId());
    }

    @PostMapping(value={"/supSignSync"})
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getBillShareLink"})
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        PicKingEntity entity = (PicKingEntity)((Object)this.service.selectById(id));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode("BT220117000000002");
            if (!cooperateResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)"BT220117000000002", (Object)cooperateResp.getMsg());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            boolean pushResult = this.service.pushBillToSupCenter((PicKingEntity)((Object)BeanMapper.map((Object)((Object)entity), PicKingEntity.class)), "BT220117000000002", (CooperateVO)cooperateResp.getData());
            if (!pushResult) {
                this.logger.error("\u5355\u636e-{}\u63a8\u9001\u7ed9\u4f9b\u5e94\u5546supplierId-{}\u5931\u8d25\uff01", (Object)id, (Object)entity.getSupplierId());
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, "BT220117000000002", entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/picking/card", null);
    }
}

