package com.ejianc.business.process.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.ApplicationDetailEntity;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.ApplicationDetailVO;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.vo.AdjustVO;

/**
 * 分包价格调整与增补
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("adjust")
public class AdjustController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ADJUST_CODE";//此处需要根据实际修改

    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AdjustVO> saveOrUpdate(@RequestBody AdjustVO saveOrUpdateVO) {
        AdjustVO vo = service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AdjustVO> queryDetail(Long id) {
        AdjustVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AdjustVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AdjustVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AdjustVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName","orgName","billCode","projectName","contractName","supplierName","changeItems","employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }


        IPage<AdjustEntity> page = service.queryPage(param,false);
        IPage<AdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AdjustVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询带子表的数据
     */
    @RequestMapping(value = "/queryAdjust", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> queryAdjust(@RequestBody QueryParam param) {
        // 模糊查询
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName","orgName","billCode","projectName","contractName","supplierName","changeItems","employeeName"));



        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        // 过滤生效的单据
        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billState));

        param.getOrderMap().put("create_time", QueryParam.DESC);
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        IPage<AdjustEntity> page = service.queryPage(param, false);
        List<AdjustEntity> dataList = page.getRecords();
        IPage<AdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AdjustVO> voList = BeanMapper.mapList(dataList, AdjustVO.class);
        if (CollectionUtils.isNotEmpty(voList)){
            List<Long> ids = voList.stream().map(AdjustVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<AdjustDetailEntity> qw = Wrappers.lambdaQuery();
            qw.in(AdjustDetailEntity::getPid,ids)
                    .eq(AdjustDetailEntity::getDr,0);
            List<AdjustDetailEntity> list = detailService.list(qw);
            Map<Long, List<AdjustDetailEntity>> detailListMap = list.stream().collect(Collectors.groupingBy(AdjustDetailEntity::getPid));
            for (AdjustVO adjustVO : voList) {
                adjustVO.setAdjustDetailList(BeanMapper.mapList(detailListMap.get(adjustVO.getId()),AdjustDetailVO.class));
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName","orgName","billCode","projectName","contractName","supplierName","changeItems","employeeName"));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AdjustEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Adjust-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refAdjustData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> refAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null != conditionMap.get("adjustId")) {
                param.getParams().put("adjustId", new Parameter(QueryParam.EQ, conditionMap.get("adjustId")));
            }
            if(null != conditionMap.get("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
            }
            if(null != conditionMap.get("useType")) {
                param.getParams().put("useType", new Parameter(QueryParam.EQ, conditionMap.get("useType")));
            }
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<AdjustEntity> page = service.queryPage(param,false);
        IPage<AdjustVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AdjustVO> voList = BeanMapper.mapList(page.getRecords(), AdjustVO.class);
        if (CollectionUtils.isNotEmpty(voList)){
            List<Long> ids = voList.stream().map(AdjustVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper<AdjustDetailEntity> qw = Wrappers.lambdaQuery();
            qw.in(AdjustDetailEntity::getPid,ids)
                    .eq(AdjustDetailEntity::getDr,0);
            List<AdjustDetailEntity> list = detailService.list(qw);
            Map<Long, List<AdjustDetailEntity>> detailListMap = list.stream().collect(Collectors.groupingBy(AdjustDetailEntity::getPid));
            for (AdjustVO adjustVO : voList) {
                adjustVO.setAdjustDetailList(BeanMapper.mapList(detailListMap.get(adjustVO.getId()),AdjustDetailVO.class));
            }
        }
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

}
