package com.ejianc.business.process.service.impl;

import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("adjust") 
public class AdjustBpmServiceImpl implements ICommonBusinessService {
	
	@Autowired
	private IAdjustService service;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AdjustEntity entity = service.selectById(billId);
		List<AdjustDetailEntity> detailList= entity.getAdjustDetailList();
		BigDecimal approveMny=BigDecimal.ZERO;
		for (AdjustDetailEntity detailEntity : detailList) {
			if (null!=detailEntity.getDetailBranchNum() || null!=detailEntity.getDetailBranchTaxPrice()){
				detailEntity.setDetailFinishNum(detailEntity.getDetailBranchNum());
				detailEntity.setDetailFinishTaxMny(detailEntity.getDetailBranchTaxMny());
				detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailBranchTaxPrice());
				detailEntity.setDetailFinishMny(detailEntity.getDetailBranchMny());
				detailEntity.setDetailFinishTax(detailEntity.getDetailBranchTax());
				detailEntity.setDetailFinishPrice(detailEntity.getDetailBranchPrice());
			}
			if (null!=detailEntity.getDetailMasterNum() || null!=detailEntity.getDetailMasterTaxPrice()){
				detailEntity.setDetailFinishNum(detailEntity.getDetailMasterNum());
				detailEntity.setDetailFinishTaxMny(detailEntity.getDetailMasterTaxMny());
				detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailMasterTaxPrice());
				detailEntity.setDetailFinishMny(detailEntity.getDetailMasterMny());
				detailEntity.setDetailFinishTax(detailEntity.getDetailMasterTax());
				detailEntity.setDetailFinishPrice(detailEntity.getDetailMasterPrice());
			}
			approveMny= ComputeUtil.safeAdd(approveMny,detailEntity.getDetailFinishTaxMny());
		}
		entity.setApproveMny(approveMny);
		service.saveOrUpdate(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		AdjustEntity entity = service.selectById(billId);
		List<AdjustDetailEntity> detailList= entity.getAdjustDetailList();
		BigDecimal approveMny=BigDecimal.ZERO;
		for (AdjustDetailEntity detailEntity : detailList) {
				detailEntity.setDetailFinishNum(null);
				detailEntity.setDetailFinishTaxMny(null);
				detailEntity.setDetailFinishTaxPrice(null);
				detailEntity.setDetailFinishMny(null);
				detailEntity.setDetailFinishTax(null);
				detailEntity.setDetailFinishPrice(null);

				detailEntity.setDetailBranchNum(null);
				detailEntity.setDetailBranchTaxMny(null);
				detailEntity.setDetailBranchTaxPrice(null);
				detailEntity.setDetailBranchMny(null);
			  	detailEntity.setDetailBranchTax(null);
				detailEntity.setDetailBranchPrice(null);

				detailEntity.setDetailMasterNum(null);
				detailEntity.setDetailMasterTaxMny(null);
				detailEntity.setDetailMasterTaxPrice(null);
				detailEntity.setDetailMasterMny(null);
				detailEntity.setDetailMasterTax(null);
				detailEntity.setDetailMasterPrice(null);
		}
		entity.setApproveMny(approveMny);
		service.saveOrUpdate(entity);
		return CommonResponse.success();
	}

}
