/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.service.IAdjustDetailService;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.business.process.vo.AdjustDetailVO;
import com.ejianc.business.process.vo.AdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"adjust"})
public class AdjustController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ADJUST_CODE";
    @Autowired
    private IAdjustService service;
    @Autowired
    private IAdjustDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AdjustVO> saveOrUpdate(@RequestBody AdjustVO saveOrUpdateVO) {
        AdjustVO vo = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AdjustVO> queryDetail(Long id) {
        AdjustVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AdjustVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AdjustVO adjustVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName", "orgName", "billCode", "projectName", "contractName", "supplierName", "changeItems", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAdjust"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> queryAdjust(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName", "orgName", "billCode", "projectName", "contractName", "supplierName", "changeItems", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billState));
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        List dataList = page.getRecords();
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)dataList, AdjustVO.class);
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper qw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)qw.in(AdjustDetailEntity::getPid, ids)).eq(BaseEntity::getDr, (Object)0);
            List list = this.detailService.list((Wrapper)qw);
            Map<Long, List<AdjustDetailEntity>> detailListMap = list.stream().collect(Collectors.groupingBy(AdjustDetailEntity::getPid));
            for (AdjustVO adjustVO : voList) {
                adjustVO.setAdjustDetailList(BeanMapper.mapList((Iterable)detailListMap.get(adjustVO.getId()), AdjustDetailVO.class));
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("parentOrgName", "orgName", "billCode", "projectName", "contractName", "supplierName", "changeItems", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Adjust-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAdjustData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AdjustVO>> refAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("adjustId")) {
                param.getParams().put("adjustId", new Parameter("eq", conditionMap.get("adjustId")));
            }
            if (null != conditionMap.get("contractId")) {
                param.getParams().put("contractId", new Parameter("eq", conditionMap.get("contractId")));
            }
            if (null != conditionMap.get("useType")) {
                param.getParams().put("useType", new Parameter("eq", conditionMap.get("useType")));
            }
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), AdjustVO.class);
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper qw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)qw.in(AdjustDetailEntity::getPid, ids)).eq(BaseEntity::getDr, (Object)0);
            List list = this.detailService.list((Wrapper)qw);
            Map<Long, List<AdjustDetailEntity>> detailListMap = list.stream().collect(Collectors.groupingBy(AdjustDetailEntity::getPid));
            for (AdjustVO adjustVO : voList) {
                adjustVO.setAdjustDetailList(BeanMapper.mapList((Iterable)detailListMap.get(adjustVO.getId()), AdjustDetailVO.class));
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

