/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.control.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.control.bean.ControlChangeEntity;
import com.ejianc.business.control.bean.ControlDetailChangeEntity;
import com.ejianc.business.control.bean.ControlDetailChangeFourEntity;
import com.ejianc.business.control.bean.ControlDetailChangeThreeEntity;
import com.ejianc.business.control.bean.ControlDetailChangeTwoEntity;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.mapper.ControlChangeMapper;
import com.ejianc.business.control.service.IControlChangeService;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="controlChangeService")
public class ControlChangeServiceImpl
extends BaseServiceImpl<ControlChangeMapper, ControlChangeEntity>
implements IControlChangeService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlService controlService;
    private static final String BILL_CODE = "SUB_CONTROL_CHANGE";
    @Autowired
    private ControlChangeMapper controlChangeMapper;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public ControlChangeVO saveOrUpdate(ControlChangeVO saveOrUpdateVO) {
        List<ControlDetailChangeFourEntity> list;
        List<ControlDetailChangeThreeEntity> list2;
        List<ControlDetailChangeTwoEntity> controlDetailTwoList;
        ControlChangeEntity controlChangeEntity = this.controlChangeService.getUnFinishedChange(saveOrUpdateVO.getSourceControlId());
        if (!(null == controlChangeEntity || null != saveOrUpdateVO.getId() && controlChangeEntity.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u5ba1\u6838\u8868\uff01");
        }
        ControlEntity masterPlan = (ControlEntity)((Object)this.controlService.getById(saveOrUpdateVO.getSourceControlId()));
        UserContext userContext = this.sessionManager.getUserContext();
        ControlChangeEntity saveEntity = null;
        if (null == saveOrUpdateVO.getId()) {
            saveEntity = (ControlChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlChangeEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            saveEntity.setId(IdWorker.getId());
        } else {
            saveEntity = (ControlChangeEntity)((Object)super.getById((Serializable)saveOrUpdateVO.getId()));
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setMemo(saveOrUpdateVO.getMemo());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setControlDetailList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailList(), ControlDetailChangeEntity.class));
            saveEntity.setControlDetailTwoList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailTwoList(), ControlDetailChangeTwoEntity.class));
            saveEntity.setControlDetailThreeList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailThreeList(), ControlDetailChangeThreeEntity.class));
            saveEntity.setControlDetailFourList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailThreeList(), ControlDetailChangeFourEntity.class));
        }
        List<ControlDetailChangeEntity> controlDetailList = saveEntity.getControlDetailList();
        if (CollectionUtils.isNotEmpty(controlDetailList) && null == saveEntity.getId()) {
            for (ControlDetailChangeEntity controlDetailChangeEntity : controlDetailList) {
                controlDetailChangeEntity.setId(null);
                controlDetailChangeEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(controlDetailTwoList = saveEntity.getControlDetailTwoList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeTwoEntity controlDetailChangeTwoEntity : controlDetailTwoList) {
                controlDetailChangeTwoEntity.setId(null);
                controlDetailChangeTwoEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = saveEntity.getControlDetailThreeList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeThreeEntity controlDetailChangeThreeEntity : list2) {
                controlDetailChangeThreeEntity.setId(null);
                controlDetailChangeThreeEntity.setParentId(null);
            }
        }
        if (CollectionUtils.isNotEmpty(list = saveEntity.getControlDetailFourList()) && null == saveEntity.getId()) {
            for (ControlDetailChangeFourEntity cdEntity : list) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        saveEntity = this.controlChangeService.saveOrUpdateControlChange(saveEntity);
        ControlChangeVO controlChangeVO = (ControlChangeVO)BeanMapper.map((Object)((Object)saveEntity), ControlChangeVO.class);
        return controlChangeVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ControlChangeEntity saveOrUpdateControlChange(ControlChangeEntity saveEntity) {
        super.saveOrUpdate((Object)saveEntity, false);
        ControlEntity controlEntity = (ControlEntity)((Object)this.controlService.selectById(saveEntity.getSourceControlId()));
        if (1 != controlEntity.getChangeState()) {
            controlEntity.setChangeState(1);
            controlEntity.setChangeId(saveEntity.getId());
            this.controlService.saveOrUpdate((Object)controlEntity, false);
        }
        return saveEntity;
    }

    @Override
    public ControlChangeEntity getUnFinishedChange(Long sourceControlId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_control_id", (Object)sourceControlId);
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (ControlChangeEntity)((Object)this.controlChangeMapper.selectOne((Wrapper)query));
    }
}

