/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.bean.ControlDetailEntity;
import com.ejianc.business.control.bean.ControlDetailFourEntity;
import com.ejianc.business.control.bean.ControlDetailThreeEntity;
import com.ejianc.business.control.bean.ControlDetailTwoEntity;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.mapper.ControlMapper;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlDetailVO;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="controlService")
public class ControlServiceImpl
extends BaseServiceImpl<ControlMapper, ControlEntity>
implements IControlService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SUB_CONTROL";
    @Autowired
    private SessionManager sessionManager;
    private static final String CONTROL_COST_CODE = "P-i3X5840010";
    private static final String CONTROL_COST_DETAIL_CODE = "P-u3wio90011";
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IControlService service;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBuildDutyApi buildDutyApi;

    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO) {
        List<ControlDetailFourEntity> list;
        List<ControlDetailThreeEntity> list2;
        List<ControlDetailTwoEntity> controlDetailTwoList;
        ControlEntity entity = (ControlEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        ControlEntity saveEntity = null;
        if (null == saveOrUpdateVO.getId()) {
            saveEntity = (ControlEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlEntity.class));
            saveEntity.setId(IdWorker.getId());
            saveEntity.setChangeState(0);
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(1);
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (ControlEntity)((Object)this.service.getById(saveOrUpdateVO.getId()));
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setMemo(saveOrUpdateVO.getMemo());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setEmployeeId(saveOrUpdateVO.getEmployeeId());
            saveEntity.setEmployeeName(saveOrUpdateVO.getEmployeeName());
            saveEntity.setControlDetailList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailList(), ControlDetailEntity.class));
            saveEntity.setControlDetailTwoList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailTwoList(), ControlDetailTwoEntity.class));
            saveEntity.setControlDetailThreeList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailThreeList(), ControlDetailThreeEntity.class));
            saveEntity.setControlDetailFourList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getControlDetailThreeList(), ControlDetailFourEntity.class));
        }
        List<ControlDetailEntity> controlDetailList = saveEntity.getControlDetailList();
        if (CollectionUtils.isNotEmpty(controlDetailList)) {
            for (ControlDetailEntity controlDetailEntity : controlDetailList) {
                controlDetailEntity.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(controlDetailTwoList = saveEntity.getControlDetailTwoList())) {
            for (ControlDetailTwoEntity controlDetailTwoEntity : controlDetailTwoList) {
                if ("del".equals(controlDetailTwoEntity.getRowState())) continue;
                controlDetailTwoEntity.setTwoChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list2 = saveEntity.getControlDetailThreeList())) {
            for (ControlDetailThreeEntity controlDetailThreeEntity : list2) {
                if ("del".equals(controlDetailThreeEntity.getRowState())) continue;
                controlDetailThreeEntity.setThreeChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(list = saveEntity.getControlDetailFourList())) {
            for (ControlDetailFourEntity detail : list) {
                if ("del".equals(detail.getRowState())) continue;
                detail.setFourChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode());
            }
        }
        super.saveOrUpdate((Object)saveEntity, false);
        ControlVO controlVO = (ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class);
        return controlVO;
    }

    @Override
    public ParamsCheckVO checkParams(ControlVO vo, Object o) {
        String status = this.responseIsCost(vo);
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (status.equals("0")) {
            return paramsCheckVO;
        }
        paramsCheckVOS.addAll(this.checkControlAllMny(vo));
        paramsCheckVOS.addAll(this.checkControlDetailMny(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private String responseIsCost(ControlVO controlVO) {
        List laborDetailList;
        List proSubDetailList;
        CommonResponse response = this.paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BaseVO::getId));
        }
        if (subType == 2 && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BaseVO::getId));
        }
        if ("0".equals(valueData)) {
            return "0";
        }
        if ("1".equals(valueData) && (buildDutyVO == null || buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)) {
            throw new BusinessException("\u9879\u76ee\u672a\u505a\u9879\u76ee\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        CommonResponse responseDetail = this.paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE);
        if (!responseDetail.isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueDataDetail = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueDataDetail)) {
            return "0";
        }
        if ("1".equals(valueDataDetail)) {
            List controlDetailFourList;
            List controlDetailThreeList;
            List controlDetailTwoList;
            List controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty((Collection)controlDetailList)) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailTwoList = controlVO.getControlDetailTwoList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailThreeList = controlVO.getControlDetailThreeList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)(controlDetailFourList = controlVO.getControlDetailFourList()))) {
                Map<Object, Object> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch) {
                    throw new BusinessException("\u6e05\u5355\u6ca1\u6709\u7b56\u5212\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
        }
        return "1";
    }

    private List<ParamsCheckVO> checkControlAllMny(ControlVO controlVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        HashMap numMasterPlanMap = new HashMap();
        CommonResponse buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info(" \u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7>\u7b56\u5212\u6210\u672c\u603b\u4ef7*X%\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal compareNum = ComputeUtil.safeMultiply((BigDecimal)controlVO.getControlTaxMny(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)planedTotalCostTaxMny, (BigDecimal)compareNum)) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u5927\u4e8e\u7b56\u5212\u6210\u672c\u603b\u4ef7");
                        paramsCheckDsVO.setWarnName("\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u5927\u4e8e\u7b56\u5212\u6210\u672c\u603b\u4ef7");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u603b\u4ef7\u4e3a:").append(ComputeUtil.nullToZero((BigDecimal)controlVO.getControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u603b\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)controlVO.getControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlVO controlVO) {
        CommonResponse billParamByCode;
        List laborDetailList;
        List proSubDetailList;
        CommonResponse buildDutyVOCommonResponse;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        List controlDetailList = controlVO.getControlDetailList();
        Map<Object, Object> mnyControlDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)controlDetailList)) {
            mnyControlDetailMap = controlDetailList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(ControlDetailVO::getDocId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getControlTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        if (!(buildDutyVOCommonResponse = this.buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId())).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7b56\u5212\u6210\u672c\u5931\u8d25");
        }
        BuildDutyVO buildDutyVO = (BuildDutyVO)buildDutyVOCommonResponse.getData();
        Integer subType = controlVO.getSubType();
        Map<Object, Object> costMap = new HashMap();
        if (subType == 1 && CollectionUtils.isNotEmpty((Collection)(proSubDetailList = buildDutyVO.getProSubDetailList()))) {
            costMap = proSubDetailList.stream().collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
        }
        if (subType == 2 && CollectionUtils.isNotEmpty((Collection)(laborDetailList = buildDutyVO.getLaborDetailList()))) {
            costMap = laborDetailList.stream().collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId())).isSuccess() && null != billParamByCode.getData()) {
            StringBuffer stringBuffer;
            ParamsCheckDsVO paramsCheckDsVO;
            BigDecimal compareNum;
            BigDecimal roleValue;
            ArrayList<ParamsCheckDsVO> checkDsVOS;
            ParamsCheckVO paramsCheckVO;
            BigDecimal costMny;
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (ControlDetailVO detailVO : controlVO.getControlDetailList()) {
                    costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        paramsCheckVO = new ParamsCheckVO();
                        checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getControlTaxMny(), (BigDecimal)compareNum)) {
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb51\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                for (ControlDetailVO detailVO : controlVO.getControlDetailTwoList()) {
                    costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        paramsCheckVO = new ParamsCheckVO();
                        checkDsVOS = new ArrayList();
                        roleValue = datum.getRoleValue();
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                        if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getTwoControlTaxMny(), (BigDecimal)compareNum)) {
                            paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                            stringBuffer = new StringBuffer();
                            stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb51\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getTwoControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getTwoControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
            for (ControlDetailVO detailVO : controlVO.getControlDetailThreeList()) {
                costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    paramsCheckVO = new ParamsCheckVO();
                    checkDsVOS = new ArrayList();
                    roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getThreeControlTaxMny(), (BigDecimal)compareNum)) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb51\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getThreeControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getThreeControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
            for (ControlDetailVO detailVO : controlVO.getControlDetailFourList()) {
                costMny = costMap.containsKey(detailVO.getDocId()) ? (BigDecimal)costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                for (BillParamVO datum : data) {
                    paramsCheckVO = new ParamsCheckVO();
                    checkDsVOS = new ArrayList();
                    roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    compareNum = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)));
                    if (ComputeUtil.isGreaterThan((BigDecimal)detailVO.getFourControlTaxMny(), (BigDecimal)compareNum)) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        paramsCheckDsVO.setWarnName("\u6e05\u5355\u7684\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u662f\u5426\u5141\u8bb8\u8d85\u8fc7\u7b56\u5212\u6210\u672c\u4ef7");
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("\u5f53\u524d\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7 \u6807\u6bb51\u6e05\u5355\u4e2d\u3010").append(detailVO.getDetailName()).append("\u3011\u7684\u63a7\u5236\u4ef7\u542b\u7a0e\u91d1\u989d\u3010").append(ComputeUtil.nullToZero((BigDecimal)detailVO.getFourControlTaxMny()).setScale(3, 4)).append("\uff0c\u7b56\u5212\u6210\u672c\u4ef7:").append(ComputeUtil.nullToZero((BigDecimal)compareNum).setScale(3, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)detailVO.getFourControlTaxMny(), (BigDecimal)compareNum).setScale(3, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }
}

