package com.ejianc.business.control.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlChangeVO;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanDetailChangeEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.promaterial.plan.vo.MasterPlanChangeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.control.mapper.ControlChangeMapper;
import com.ejianc.business.control.service.IControlChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包招标控制价审核表-变更
 * 
 * @author generator
 * 
 */
@Service("controlChangeService")
public class ControlChangeServiceImpl extends BaseServiceImpl<ControlChangeMapper, ControlChangeEntity> implements IControlChangeService{

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlChangeService controlChangeService;
    @Autowired
    private IControlService controlService;
    private static final String BILL_CODE = "SUB_CONTROL_CHANGE";//此处需要根据实际修改
    @Autowired
    private ControlChangeMapper controlChangeMapper;

    @Autowired
    private SessionManager sessionManager;


    @Override
    public ControlChangeVO saveOrUpdate(ControlChangeVO saveOrUpdateVO) {

        //校验项目是否存在未完成的变更计划单存在
        ControlChangeEntity controlChangeEntity = controlChangeService.getUnFinishedChange(saveOrUpdateVO.getSourceControlId());

        if(null !=controlChangeEntity && (null == saveOrUpdateVO.getId() || !controlChangeEntity.getId().equals(saveOrUpdateVO.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的变更分包招标控制价审核表！");
        }

        ControlEntity masterPlan = controlService.getById(saveOrUpdateVO.getSourceControlId());
        UserContext userContext = sessionManager.getUserContext();
        ControlChangeEntity saveEntity = null;
        if(null == saveOrUpdateVO.getId()) {
            saveEntity = BeanMapper.map(saveOrUpdateVO, ControlChangeEntity.class);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            //设置变更人
//            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
            //生成Id用于成本控制
            saveEntity.setId(IdWorker.getId());

        } else {
            saveEntity = super.getById(saveOrUpdateVO.getId());
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setMemo(saveOrUpdateVO.getMemo());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
            saveEntity.setModifyUserName(userContext.getUserName());

            saveEntity.setControlDetailList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailList(), ControlDetailChangeEntity.class));
            saveEntity.setControlDetailTwoList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailTwoList(), ControlDetailChangeTwoEntity.class));
            saveEntity.setControlDetailThreeList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailChangeThreeEntity.class));
            saveEntity.setControlDetailFourList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailChangeFourEntity.class));

        }

        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeEntity> controlDetailList = saveEntity.getControlDetailList();

        if (CollectionUtils.isNotEmpty(controlDetailList) && null == saveEntity.getId()) {
            for (ControlDetailChangeEntity cdEntity : controlDetailList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }

        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeTwoEntity> controlDetailTwoList = saveEntity.getControlDetailTwoList();
        if (CollectionUtils.isNotEmpty(controlDetailTwoList) && null == saveEntity.getId()) {
            for (ControlDetailChangeTwoEntity cdEntity : controlDetailTwoList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeThreeEntity> controlDetailThreeList = saveEntity.getControlDetailThreeList();
        if (CollectionUtils.isNotEmpty(controlDetailThreeList) && null == saveEntity.getId()) {
            for (ControlDetailChangeThreeEntity cdEntity : controlDetailThreeList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        //保存前清空主键和父主键，重新生成
        List<ControlDetailChangeFourEntity> controlDetailFourList = saveEntity.getControlDetailFourList();
        if (CollectionUtils.isNotEmpty(controlDetailFourList) && null == saveEntity.getId()) {
            for (ControlDetailChangeFourEntity cdEntity : controlDetailFourList) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }

        saveEntity = controlChangeService.saveOrUpdateControlChange(saveEntity);
        ControlChangeVO controlChangeVO = BeanMapper.map(saveEntity, ControlChangeVO.class);

        return controlChangeVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ControlChangeEntity saveOrUpdateControlChange(ControlChangeEntity saveEntity) {

        super.saveOrUpdate(saveEntity, false);

        ControlEntity controlEntity = controlService.selectById(saveEntity.getSourceControlId());
        if (1 != controlEntity.getChangeState()) {
            controlEntity.setChangeState(1);
            controlEntity.setChangeId(saveEntity.getId());
            controlService.saveOrUpdate(controlEntity, false);
        }
        return saveEntity;
    }


    @Override
    public ControlChangeEntity getUnFinishedChange(Long sourceControlId) {
        QueryWrapper<ControlChangeEntity> query = new QueryWrapper<>();
        query.eq("source_control_id", sourceControlId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return controlChangeMapper.selectOne(query);
    }
}
