package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.control.mapper.ControlMapper;
import com.ejianc.business.control.service.IControlService;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表
 * 
 * @author generator
 * 
 */
@Service("controlService")
public class ControlServiceImpl extends BaseServiceImpl<ControlMapper, ControlEntity> implements IControlService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUB_CONTROL";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    private static final String CONTROL_COST_CODE = "P-i3X5840010";//无项目策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_DETAIL_CODE = "P-u3wio90011";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";//清单的分包招标控制价是否允许超过策划成本价
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IControlService service;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBuildDutyApi buildDutyApi;




//    @Value("${common.env.base-host}")
//    private String BASE_HOST;
//
//    @Value("${refer.base-host:null}")
//    private String BASE_HOST_FRONTEND;

    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO) {
        ControlEntity entity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        UserContext userContext = sessionManager.getUserContext();
        ControlEntity saveEntity = null;
        if(null == saveOrUpdateVO.getId()) {
            saveEntity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为未变更
            saveEntity.setChangeState(0);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(1);
            //设置编制人
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = service.getById(saveOrUpdateVO.getId());
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setMemo(saveOrUpdateVO.getMemo());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setTaxRate(saveOrUpdateVO.getTaxRate());
            saveEntity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
            saveEntity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
            saveEntity.setCostMny(saveOrUpdateVO.getCostMny());
            saveEntity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
            saveEntity.setControlMny(saveOrUpdateVO.getControlMny());
            saveEntity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setEmployeeId(saveOrUpdateVO.getEmployeeId());
            saveEntity.setEmployeeName(saveOrUpdateVO.getEmployeeName());

            saveEntity.setControlDetailList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailList(), ControlDetailEntity.class));
            saveEntity.setControlDetailTwoList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailTwoList(), ControlDetailTwoEntity.class));
            saveEntity.setControlDetailThreeList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailThreeEntity.class));
            saveEntity.setControlDetailFourList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailFourEntity.class));
        }

        List<ControlDetailEntity> controlDetailList = saveEntity.getControlDetailList();
        if(CollectionUtils.isNotEmpty(controlDetailList)){
//            for(ControlDetailEntity detail : controlDetailList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailEntity detail : controlDetailList) {
                detail.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        List<ControlDetailTwoEntity> controlDetailTwoList = saveEntity.getControlDetailTwoList();
        if(CollectionUtils.isNotEmpty(controlDetailTwoList)){
//            for(ControlDetailTwoEntity detail : controlDetailTwoList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailTwoEntity detail : controlDetailTwoList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setTwoChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailThreeEntity> controlDetailThreeList = saveEntity.getControlDetailThreeList();
        if(CollectionUtils.isNotEmpty(controlDetailThreeList)){
//            for(ControlDetailThreeEntity detail : controlDetailThreeList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailThreeEntity detail : controlDetailThreeList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setThreeChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailFourEntity> controlDetailFourList = saveEntity.getControlDetailFourList();
        if(CollectionUtils.isNotEmpty(controlDetailFourList)){
//            for(ControlDetailFourEntity detail : controlDetailFourList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == saveEntity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(saveEntity.getId());
//                }
//            }
            for (ControlDetailFourEntity detail : controlDetailFourList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setFourChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        super.saveOrUpdate(saveEntity, false);

        ControlVO vo = BeanMapper.map(entity, ControlVO.class);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(ControlVO vo, Object o) {

        //无项目策划成本时是否可提交分包招标控制价审核表
        String status = responseIsCost(vo);
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (status.equals("0")){
            return paramsCheckVO;
        }
        paramsCheckVOS.addAll(checkControlAllMny(vo));
        paramsCheckVOS.addAll(checkControlDetailMny(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private String responseIsCost(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
            if(CollectionUtils.isNotEmpty(proSubDetailList)){
                costMap = proSubDetailList.stream().collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
            }
        }
        if (subType == 2){
            List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
            if(CollectionUtils.isNotEmpty(laborDetailList)){
                costMap = laborDetailList.stream().collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
            }
        }



        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            return "0";
        }
        if ("1".equals(valueData)) {
            if (buildDutyVO == null || (buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)){
                throw new BusinessException("项目未做项目策划成本，不允许保存!");
            }
        }

        // 清单无策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> responseDetail = paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE);
        if (!responseDetail.isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueDataDetail = response.getData().getValueData();
        Assert.hasText(valueData, "获取系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueDataDetail)) {
            return "0";
        }
        if ("1".equals(valueDataDetail)) {
            //标段1
            List<ControlDetailVO> controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty(controlDetailList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
            //标段2
            List<ControlDetailTwoVO> controlDetailTwoList = controlVO.getControlDetailTwoList();
            if (CollectionUtils.isNotEmpty(controlDetailTwoList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
            //标段3
            List<ControlDetailThreeVO> controlDetailThreeList = controlVO.getControlDetailThreeList();
            if (CollectionUtils.isNotEmpty(controlDetailThreeList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
            //标段4
            List<ControlDetailFourVO> controlDetailFourList = controlVO.getControlDetailFourList();
            if (CollectionUtils.isNotEmpty(controlDetailFourList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
        }

        return "1";
    }
//分包招标控制总价是否允许超过策划成本总价
    private List<ParamsCheckVO> checkControlAllMny(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
//        分包招标控制总价>策划成本总价*X%

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info(" 分包招标控制总价>策划成本总价*X%：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply(controlVO.getControlTaxMny(), ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(planedTotalCostTaxMny, compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("分包招标控制总价大于策划成本总价");
                            paramsCheckDsVO.setWarnName("分包招标控制总价大于策划成本总价");

                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制总价为:").append(ComputeUtil.nullToZero(controlVO.getControlTaxMny()).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("，策划成本总价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(controlVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<ControlDetailVO> controlDetailList = controlVO.getControlDetailList();
        Map<Long, BigDecimal> mnyControlDetailMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(controlDetailList)){
            mnyControlDetailMap = controlDetailList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(ControlDetailVO::getDocId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getControlTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, BigDecimal> costMap = new HashMap<>();
        if (subType == 1){
            List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
            if(CollectionUtils.isNotEmpty(proSubDetailList)){
                costMap = proSubDetailList.stream().collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
            }
        }
        if (subType == 2){
            List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
            if(CollectionUtils.isNotEmpty(laborDetailList)){
                costMap = laborDetailList.stream().collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("清单的分包招标控制价是否允许超过策划成本价：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (ControlDetailVO detailVO : controlVO.getControlDetailList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getControlTaxMny()).setScale(3,                                     BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段2
                for (ControlDetailTwoVO detailVO : controlVO.getControlDetailTwoList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getTwoControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getTwoControlTaxMny()).setScale(3,                                BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getTwoControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
                //标段3
                for (ControlDetailThreeVO detailVO : controlVO.getControlDetailThreeList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getThreeControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getThreeControlTaxMny()).setScale(3,                              BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getThreeControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段4
                for (ControlDetailFourVO detailVO : controlVO.getControlDetailFourList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getFourControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getFourControlTaxMny()).setScale(3,                               BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getFourControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }




}
