package com.ejianc.business.process.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.process.bean.ProgressDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包形象进度审核表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_progress")
public class ProgressEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // billCode
    @TableField(value="project_id")
    private Long projectId; // 项目名称id
    @TableField(value="project_code")
    private String projectCode; // 项目名称code
    @TableField(value="project_name")
    private String projectName; // 项目名称name
    @TableField(value="org_id")
    private Long orgId; // orgId
    @TableField(value="org_code")
    private String orgCode; // orgCode
    @TableField(value="org_name")
    private String orgName; // orgName
    @TableField(value="parent_org_id")
    private Long parentOrgId; // parentOrgId
    @TableField(value="parent_org_code")
    private String parentOrgCode; // parentOrgCode
    @TableField(value="parent_org_name")
    private String parentOrgName; // parentOrgName
    @TableField(value="bill_state")
    private Integer billState; // billState
    @TableField(value="employee_id")
    private Long employeeId; // 编制人id
    @TableField(value="employee_name")
    private String employeeName; // 编制人name
    @TableField(value="dept_id")
    private Long deptId; // deptId
    @TableField(value="dept_name")
    private String deptName; // deptName
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_id")
    private Long contractId; // 分包合同id
    @TableField(value="contract_name")
    private String contractName; // 分包合同name
    @TableField(value="sub_type")
    private String subType; // 分包类别, 
    @TableField(value="supplier_id")
    private Long supplierId; // 分包单位id
    @TableField(value="supplier_name")
    private String supplierName; // 分包单位name
    @TableField(value="start_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime; // 计量开始时间
    @TableField(value="end_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime; // 计量截止时间
    @TableField(value="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制时间
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="progressDetailService",pidName = "mid")
    private List<ProgressDetailEntity> progressDetailList = new ArrayList<>(); // 分包形象进度审核表-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    

    public List<ProgressDetailEntity> getProgressDetailList() {
        return progressDetailList;
    }

    public void setProgressDetailList(List<ProgressDetailEntity> progressDetailList) {
        this.progressDetailList = progressDetailList;
    }
}
