package com.ejianc.business.control.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.control.bean.*;
import com.ejianc.business.control.service.*;
import com.ejianc.business.control.vo.*;
import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MasterPlanVO;
import com.ejianc.business.prosub.enums.ChangeTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.zhht.api.IBuildDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyLaborCostDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyProSubDetailVO;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.control.mapper.ControlMapper;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包招标控制价审核表
 * 
 * @author generator
 * 
 */
@Service("controlService")
public class ControlServiceImpl extends BaseServiceImpl<ControlMapper, ControlEntity> implements IControlService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUB_CONTROL";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    private static final String CONTROL_COST_CODE = "P-i3X5840010";//无项目策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_DETAIL_CODE = "P-u3wio90011";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_CODE = "P-66A3UP0007";//清单无策划成本时是否可提交分包招标控制价审核表
    private static final String CONTROL_COST_ALL_DETAIL_CODE = "P-Zm22c30008";//清单的分包招标控制价是否允许超过策划成本价
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IControlService service;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBuildDutyApi buildDutyApi;
    @Autowired
    private IControlDetailService controlDetailService;
    @Autowired
    private IControlDetailTwoService controlDetailTwoService;
    @Autowired
    private IControlDetailThreeService controlDetailThreeService;
    @Autowired
    private IControlDetailFourService controlDetailFourService;
    @Autowired
    private IControlChangeHisService controlChangeHisService;
    @Autowired
    private IControlChangeService controlChangeService;




//    @Value("${common.env.base-host}")
//    private String BASE_HOST;
//
//    @Value("${refer.base-host:null}")
//    private String BASE_HOST_FRONTEND;

    @Override
    public ControlVO saveOrUpdate(ControlVO saveOrUpdateVO) {
        ControlEntity entity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        UserContext userContext = sessionManager.getUserContext();
//        ControlEntity entity = null;
        if(null == saveOrUpdateVO.getId()) {
//            entity = BeanMapper.map(saveOrUpdateVO, ControlEntity.class);
//            entity.setBillCode(entity.getBillCode());
            entity.setId(IdWorker.getId());
            //设置为未变更
            entity.setChangeState(0);
            //设置为自由态
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            entity.setChangeVersion(1);
            //设置编制人
//            entity.setCreateUserName(userContext.getUserName());
        }
//        else {
//            entity = service.getById(saveOrUpdateVO.getId());
//            entity.setProjectId(saveOrUpdateVO.getProjectId());
//            entity.setProjectName(saveOrUpdateVO.getProjectName());
//            entity.setMemo(saveOrUpdateVO.getMemo());
//            entity.setBillCode(saveOrUpdateVO.getBillCode());
//            entity.setTaxRate(saveOrUpdateVO.getTaxRate());
//            entity.setProvisionMny(saveOrUpdateVO.getProvisionMny());
//            entity.setProvisionTaxMny(saveOrUpdateVO.getProvisionTaxMny());
//            entity.setCostMny(saveOrUpdateVO.getCostMny());
//            entity.setCostTaxMny(saveOrUpdateVO.getCostTaxMny());
//            entity.setControlMny(saveOrUpdateVO.getControlMny());
//            entity.setControlTaxMny(saveOrUpdateVO.getControlTaxMny());
//            entity.setModifyUserName(userContext.getUserName());
//            entity.setEmployeeId(saveOrUpdateVO.getEmployeeId());
//            entity.setEmployeeName(saveOrUpdateVO.getEmployeeName());
//
//            entity.setControlDetailList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailList(), ControlDetailEntity.class));
//            entity.setControlDetailTwoList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailTwoList(), ControlDetailTwoEntity.class));
//            entity.setControlDetailThreeList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailThreeEntity.class));
//            entity.setControlDetailFourList(BeanMapper.mapList(saveOrUpdateVO.getControlDetailThreeList(), ControlDetailFourEntity.class));
//        }

        List<ControlDetailEntity> controlDetailList = entity.getControlDetailList();
        if(CollectionUtils.isNotEmpty(controlDetailList)){
//            for(ControlDetailEntity detail : controlDetailList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == entity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(entity.getId());
//                }
//            }
            for (ControlDetailEntity detail : controlDetailList) {
                detail.setChangeType(ChangeTypeEnum.未变更.getCode());
            }
        }

        List<ControlDetailTwoEntity> controlDetailTwoList = entity.getControlDetailTwoList();
        if(CollectionUtils.isNotEmpty(controlDetailTwoList)){
//            for(ControlDetailTwoEntity detail : controlDetailTwoList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == entity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(entity.getId());
//                }
//            }
            for (ControlDetailTwoEntity detail : controlDetailTwoList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setTwoChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailThreeEntity> controlDetailThreeList = entity.getControlDetailThreeList();
        if(CollectionUtils.isNotEmpty(controlDetailThreeList)){
//            for(ControlDetailThreeEntity detail : controlDetailThreeList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == entity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(entity.getId());
//                }
//            }
            for (ControlDetailThreeEntity detail : controlDetailThreeList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setThreeChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        List<ControlDetailFourEntity> controlDetailFourList = entity.getControlDetailFourList();
        if(CollectionUtils.isNotEmpty(controlDetailFourList)){
//            for(ControlDetailFourEntity detail : controlDetailFourList){
//                if (!("del").equals(detail.getRowState())){
//                    if(null == entity.getId() || null == detail.getId()) {
//                        detail.setId(IdWorker.getId());
//                    }
//                }
//                if(null == detail.getControlId()) {
//                    detail.setControlId(entity.getId());
//                }
//            }
            for (ControlDetailFourEntity detail : controlDetailFourList) {
                if (!("del").equals(detail.getRowState())){
                    detail.setFourChangeType(ChangeTypeEnum.未变更.getCode());
                }
            }
        }
        super.saveOrUpdate(entity, false);

        ControlVO vo = BeanMapper.map(entity, ControlVO.class);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(ControlVO vo, Object o) {

        //无项目策划成本时是否可提交分包招标控制价审核表
        String status = responseIsCost(vo);
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (status.equals("0")){
            return paramsCheckVO;
        }
        paramsCheckVOS.addAll(checkControlAllMny(vo));
        paramsCheckVOS.addAll(checkControlDetailMny(vo));

        /*预警参数添加域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"none", "warn", "alert"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                } else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                } else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public ControlVO queryDetail(Long id) {
        ControlEntity controlEntity = super.selectById(id);
        ControlVO controlVO =  BeanMapper.map(controlEntity, ControlVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailEntity> detailEntityListDb = controlDetailService.queryList(queryParam, false);
        List<ControlDetailEntity> detailEntityList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity ->{
                if(null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    detailEntityList.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList)) {
            for(ControlDetailEntity cdEntity : detailEntityList){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ControlDetailVO.class);
            controlVO.setControlDetailList(resultMapList);

        } else {
            controlVO.setControlDetailList(BeanMapper.mapList(detailEntityList, ControlDetailVO.class));
        }
        //标段2
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailTwoEntity> detailEntityListDb2 = controlDetailTwoService.queryList(queryParam, false);
        List<ControlDetailTwoEntity> detailEntityList2 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb2)) {
            detailEntityListDb2.forEach(entity ->{
                if(null == entity.getTwoChangeType() || ChangeTypeEnum.中止.getCode() != entity.getTwoChangeType()){
                    detailEntityList2.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList2)) {
            for(ControlDetailTwoEntity cdEntity : detailEntityList2){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailTwoVO> resultMapList = BeanMapper.mapList(detailEntityList2, ControlDetailTwoVO.class);
            controlVO.setControlDetailTwoList(resultMapList);

        } else {
            controlVO.setControlDetailTwoList(BeanMapper.mapList(detailEntityList2, ControlDetailTwoVO.class));

        }
            
        //标段3
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailThreeEntity> detailEntityListDb3 = controlDetailThreeService.queryList(queryParam, false);
        List<ControlDetailThreeEntity> detailEntityList3 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb3)) {
            detailEntityListDb3.forEach(entity ->{
                if(null == entity.getThreeChangeType() || ChangeTypeEnum.中止.getCode() != entity.getThreeChangeType()){
                    detailEntityList3.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList3)) {
            for(ControlDetailThreeEntity cdEntity : detailEntityList3){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailThreeVO> resultMapList = BeanMapper.mapList(detailEntityList3, ControlDetailThreeVO.class);
            controlVO.setControlDetailThreeList(resultMapList);

        } else {
            controlVO.setControlDetailThreeList(BeanMapper.mapList(detailEntityList3, ControlDetailThreeVO.class));
        }
        
        //标段4
        QueryParam queryParam4 = new QueryParam();
        queryParam4.getParams().put("controlId", new Parameter(QueryParam.EQ, id));
        List<ControlDetailFourEntity> detailEntityListDb4 = controlDetailFourService.queryList(queryParam, false);
        List<ControlDetailFourEntity> detailEntityList4 = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(detailEntityListDb4)) {
            detailEntityListDb4.forEach(entity ->{
                if(null == entity.getFourChangeType() || ChangeTypeEnum.中止.getCode() != entity.getFourChangeType()){
                    detailEntityList4.add(entity);
                }
            });
        }

        if(CollectionUtils.isNotEmpty(detailEntityList4)) {
            for(ControlDetailFourEntity cdEntity : detailEntityList4){
                cdEntity.setRowState("edit");
            }
            List<ControlDetailFourVO> resultMapList = BeanMapper.mapList(detailEntityList4, ControlDetailFourVO.class);
            controlVO.setControlDetailFourList(resultMapList);

        } else {
            controlVO.setControlDetailFourList(BeanMapper.mapList(detailEntityList4, ControlDetailFourVO.class));
        }
        
        

        if(null != controlEntity.getChangeVersion() && controlEntity.getChangeVersion() > 0){
            controlVO.setChangeHisVOList(controlChangeService.queryDetailRecord(controlEntity.getId()));
        }
        
        return controlVO;
    }


    private String responseIsCost(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)

        //无项目策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTROL_COST_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的系统参数不能为空!");
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, Long> costMap = new HashMap<>();
        if (subType == 1){
            if (buildDutyVO != null){
                List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
                if(CollectionUtils.isNotEmpty(proSubDetailList)){
                    costMap = proSubDetailList.stream().collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getId));
                }
            }

        }
        if (subType == 2){
            if (buildDutyVO != null){
                List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
                if(CollectionUtils.isNotEmpty(laborDetailList)){
                    costMap = laborDetailList.stream().collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getId));
                }
            }
        }



        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            return "0";
        }
        if ("1".equals(valueData)) {
            if (buildDutyVO == null || (buildDutyVO.getBillState() != 1 && buildDutyVO.getBillState() != 3)){
                throw new BusinessException("项目未做项目策划成本，不允许保存!");
            }
        }

        // 清单无策划成本时是否可提交分包招标控制价审核表
        CommonResponse<ParamRegisterSetVO> responseDetail = paramConfigApi.getByCode(CONTROL_COST_DETAIL_CODE);
        if (!responseDetail.isSuccess() || responseDetail.getData() == null) {
            throw new BusinessException("获取系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueDataDetail = response.getData().getValueData();
        Assert.hasText(valueData, "获取系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueDataDetail)) {
            return "0";
        }
        if ("1".equals(valueDataDetail)) {
            //标段1
            List<ControlDetailVO> controlDetailList = controlVO.getControlDetailList();
            if (CollectionUtils.isNotEmpty(controlDetailList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
            //标段2
            List<ControlDetailTwoVO> controlDetailTwoList = controlVO.getControlDetailTwoList();
            if (CollectionUtils.isNotEmpty(controlDetailTwoList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailTwoList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
            //标段3
            List<ControlDetailThreeVO> controlDetailThreeList = controlVO.getControlDetailThreeList();
            if (CollectionUtils.isNotEmpty(controlDetailThreeList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailThreeList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
            //标段4
            List<ControlDetailFourVO> controlDetailFourList = controlVO.getControlDetailFourList();
            if (CollectionUtils.isNotEmpty(controlDetailFourList)){
                Map<Long, Long> finalCostMap = costMap;
                boolean anyMatch = controlDetailFourList.stream().anyMatch(e -> !finalCostMap.containsKey(e.getDocId()));
                if (anyMatch){
                    throw new BusinessException("清单没有策划成本，不允许保存!");
                }
            }
        }

        return "1";
    }
//分包招标控制总价是否允许超过策划成本总价
    private List<ParamsCheckVO> checkControlAllMny(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        Map<Long, BigDecimal> numMasterPlanMap = new HashMap<>();
        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        BigDecimal planedTotalCostTaxMny = buildDutyVO.getPlanedTotalCostTaxMny();
//        分包招标控制总价>策划成本总价*X%

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info(" 分包招标控制总价>策划成本总价*X%：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        BigDecimal compareNum = ComputeUtil.safeMultiply(controlVO.getControlTaxMny(), ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(planedTotalCostTaxMny, compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("分包招标控制总价大于策划成本总价");
                            paramsCheckDsVO.setWarnName("分包招标控制总价大于策划成本总价");

                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制总价为:").append(ComputeUtil.nullToZero(controlVO.getControlTaxMny()).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("，策划成本总价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(controlVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    private List<ParamsCheckVO> checkControlDetailMny(ControlVO controlVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        List<ControlDetailVO> controlDetailList = controlVO.getControlDetailList();
        Map<Long, BigDecimal> mnyControlDetailMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(controlDetailList)){
            mnyControlDetailMap = controlDetailList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(ControlDetailVO::getDocId,
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getControlTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }

        CommonResponse<BuildDutyVO> buildDutyVOCommonResponse = buildDutyApi.queryBuildDutyByProjectId(controlVO.getProjectId());
        if (!buildDutyVOCommonResponse.isSuccess()){
            throw new BusinessException("获取策划成本失败");
        }
        BuildDutyVO buildDutyVO = buildDutyVOCommonResponse.getData();
        //分包类别, 1-专业分包,2-劳务分包
        Integer subType = controlVO.getSubType();
        Map<Long, BigDecimal> costMap = new HashMap<>();
        if (subType == 1){
            List<BuildDutyProSubDetailVO> proSubDetailList = buildDutyVO.getProSubDetailList();
            if(CollectionUtils.isNotEmpty(proSubDetailList)){
                costMap = proSubDetailList.stream().collect(Collectors.toMap(BuildDutyProSubDetailVO::getProSubDocId, BuildDutyProSubDetailVO::getProSubCostTaxMny));
            }
        }
        if (subType == 2){
            List<BuildDutyLaborCostDetailVO> laborDetailList = buildDutyVO.getLaborDetailList();
            if(CollectionUtils.isNotEmpty(laborDetailList)){
                costMap = laborDetailList.stream().collect(Collectors.toMap(BuildDutyLaborCostDetailVO::getLaborDocId, BuildDutyLaborCostDetailVO::getLaborCostTaxMny));
            }
        }

        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CONTROL_COST_ALL_DETAIL_CODE, controlVO.getParentOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {

            List<BillParamVO> data = billParamByCode.getData();
            logger.info("清单的分包招标控制价是否允许超过策划成本价：" + JSONObject.toJSONString(data));
            if (CollectionUtils.isNotEmpty(data)) {
                for (ControlDetailVO detailVO : controlVO.getControlDetailList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getControlTaxMny()).setScale(3,                                     BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段2
                for (ControlDetailTwoVO detailVO : controlVO.getControlDetailTwoList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getTwoControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getTwoControlTaxMny()).setScale(3,                                BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getTwoControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
            }
                //标段3
                for (ControlDetailThreeVO detailVO : controlVO.getControlDetailThreeList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getThreeControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getThreeControlTaxMny()).setScale(3,                              BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getThreeControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }
                //标段4
                for (ControlDetailFourVO detailVO : controlVO.getControlDetailFourList()) {

                    BigDecimal costMny = costMap.containsKey(detailVO.getDocId()) ? costMap.get(detailVO.getDocId()) : BigDecimal.ZERO;
                    for (BillParamVO datum : data) {
                        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                        BigDecimal roleValue = datum.getRoleValue();//参数值
                        paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                        //清单的分包招标控制价>清单的策划成本价*X%
                        BigDecimal compareNum = ComputeUtil.safeMultiply(costMny, ComputeUtil.safeDiv(roleValue, BigDecimal.valueOf(100)));
                        if (ComputeUtil.isGreaterThan(detailVO.getFourControlTaxMny(), compareNum)) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem("清单的分包招标控制价是否允许超过策划成本价");
                            paramsCheckDsVO.setWarnName("清单的分包招标控制价是否允许超过策划成本价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("当前分包招标控制价 标段1清单中【").append(detailVO.getDetailName()).append("】的控制价含税金额【").append(ComputeUtil.nullToZero(detailVO.getFourControlTaxMny()).setScale(3,                               BigDecimal.ROUND_HALF_UP)).append("，策划成本价:").append(ComputeUtil.nullToZero(compareNum).setScale(3, BigDecimal.ROUND_HALF_UP))
                                    .append("。超出量：").append(ComputeUtil.safeSub(detailVO.getFourControlTaxMny(), compareNum).setScale(3, BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                        paramsCheckVO.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheckVO);
                    }
                }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }




}
