package com.ejianc.business.process.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包价格调整与增补
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_price_adjust")
public class AdjustEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value="contract_flag")
    private Integer contractFlag; // 合同类型：0-主合同 1-补充协议
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 所属单位id
    @TableField(value="org_name")
    private String orgName; // 所属单位名称
    @TableField(value="org_code")
    private String orgCode; // 所属单位编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // parentOrgName
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="change_items")
    private String changeItems; // 申请内容和原因
    @TableField(value="sign_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 编制日期
    @TableField(value="declare_tax_mny")
    private BigDecimal declareTaxMny; // 分包申报金额
    @TableField(value="sum_adjust_mny")
    private BigDecimal sumAdjustMny; // 本分包合同期初累计已审批价格调整和增补金额
    @TableField(value="approve_mny")
    private BigDecimal approveMny; // 审批金额
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="memo")
    private String memo; // 其他需表述内容
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人
    @TableField(value="use_type")
    private Integer useType; // 使用类型0：补充协议1分包签证2其他
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="declare_mny")
    private BigDecimal declareMny; // 分包申报金额（无税）
    @TableField(value="contract_tax_rate")
    private BigDecimal contractTaxRate; // 税率
    
    @TableField(exist=false)
    @SubEntity(serviceName="adjustDetailService")
    private List<AdjustDetailEntity> adjustDetailList = new ArrayList<>(); // 分包价格调整与增补明细
    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getDeclareMny() {
        return declareMny;
    }

    public void setDeclareMny(BigDecimal declareMny) {
        this.declareMny = declareMny;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getDeclareTaxMny() {
        return declareTaxMny;
    }

    public void setDeclareTaxMny(BigDecimal declareTaxMny) {
        this.declareTaxMny = declareTaxMny;
    }
    public BigDecimal getSumAdjustMny() {
        return sumAdjustMny;
    }

    public void setSumAdjustMny(BigDecimal sumAdjustMny) {
        this.sumAdjustMny = sumAdjustMny;
    }
    public BigDecimal getApproveMny() {
        return approveMny;
    }

    public void setApproveMny(BigDecimal approveMny) {
        this.approveMny = approveMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }
    

    public List<AdjustDetailEntity> getAdjustDetailList() {
        return adjustDetailList;
    }

    public void setAdjustDetailList(List<AdjustDetailEntity> adjustDetailList) {
        this.adjustDetailList = adjustDetailList;
    }
}
