package com.ejianc.business.process.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 零工申请实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_oldjob_application")
public class ApplicationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 项目编码
     */
    @TableField(value="project_code")
    private String projectCode;
    /**
     *  项目名称
     */
    @TableField(value="project_name")
    private String projectName;
    /**
     * 项目id
     */
    @TableField(value="project_id")
    private Long projectId;
    /**
     * 合同编号
     */
    @TableField(value="contract_code")
    private String contractCode;
    /**
     * 合同名称
     */
    @TableField(value="contract_name")
    private String contractName;
    /**
     *  合同id
     */
    @TableField(value="contract_id")
    private Long contractId;
    /**
     * 合同类别：0-主合同 1-补充协议
     */
    @TableField(value="supplement_flag")
    private Integer supplementFlag;
    /**
     * 合同类型：0-劳务合同 1-专业合同
     */
    @TableField(value="contract_type")
    private Integer contractType;
    /**
     * 组织编码
     */
    @TableField(value="org_code")
    private String orgCode;
    /**
     * 组织id
     */
    @TableField(value="org_id")
    private Long orgId;
    /**
     *  组织名称
     */
    @TableField(value="org_name")
    private String orgName;
    /**
     * 上级组织名称
     */
    @TableField(value="parent_org_name")
    private String parentOrgName;
    /**
     * 上级组织id
     */
    @TableField(value="parent_org_id")
    private Long parentOrgId;
    /**
     * 上级组织编码
     */
    @TableField(value="parent_org_code")
    private String parentOrgCode;
    /**
     * 申请人 即经办人
     */
    @TableField(value="employee_id")
    private Long employeeId;
    /**
     * 申请人信息 即经办人
     */
    @TableField(value="employee_name")
    private String employeeName;
    @TableField(value = "first_party_id")
    private Long firstPartyId;// 甲方Id
    @TableField(value = "first_party_name")
    private String firstPartyName;// 甲方名称
    /**
     * 供应商id(乙方)
     */
    @TableField(value="supplier_id")
    private Long supplierId;
    /**
     * 供应商名称（乙方）
     */
    @TableField(value="supplier_name")
    private String supplierName;
    /**
     *  经办部门id
     */
    @TableField(value="department_id")
    private Long departmentId;
    /**
     *  经办部门
     */
    @TableField(value="department_name")
    private String departmentName;
    /**
     *  用工内容 手动输入 1-50个字，必填项  （施工内容）
     */
    @TableField(value="use_work_detail")
    private String useWorkDetail;
    /**
     *  用工类型 0-零星用工 1-临时机械 2-变更签证
     */
    @TableField(value="use_work_type_id")
    private Long useWorkTypeId;
    /**
     *  用工类型 0-零星用工 1-临时机械 2-变更签证
     */
    @TableField(value="use_work_type_name")
    private String useWorkTypeName;

    /**
     * 预计用工日期，暂时不做任何逻辑控制
     */
    @TableField(value = "pre_use_work_date")
    private Date preUseWorkDate;

    /**
     *  零工总金额：自动计算子表的无税总金额不支持修改(无税)
     */
    @TableField(value="mny")
    private BigDecimal mny;
    /**
     * 零工总金额：自动计算子表的含税总金额不支持修改（含税）
     */
    @TableField(value="tax_mny")
    private BigDecimal taxMny;
    /**
     * 零工是否登记  1被引用：显示标识 零工已登记 0 未被引用：零工未登记
     */
    @TableField(value="use_flag")
    private Integer useFlag;
    /**
     *  单据编号
     */
    @TableField(value="bill_code")
    private String billCode;
    /**
     * 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    @TableField(value="bill_state")
    private Integer billState;

    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期

    /**
     *   班组id
     */
    @TableField(value="team_id")
    private Long teamId;
    /**
     * 班组名称（带入）
     */
    @TableField(value="team_name")
    private String teamName;
    /**
     * 班组编码
     */
    @TableField(value="team_code")
    private String teamCode;
    /**
     * 用工明细表
     */
    @TableField(exist = false)
    @SubEntity(serviceName="applicationDetailService" ,pidName = "applicationId")
    private List<ApplicationDetailEntity> detailList = new ArrayList<>();

    /**
     * 指令原因 ：0发包原因，1项目部原因，2其他分包原因3其他原因
     */
    @TableField(value="command_cause")
    private Integer commandCause;
    /**
     * 签证类型 ：0零星用工，1临时机械，2临时设施,3业主原因变更签证
     */
    @TableField(value="visa_type")
    private Integer visaType;
    @TableField(value = "plan_begin_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBeginDate; // 预计施工开始时间
    @TableField(value = "plan_end_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 预计施工结束时间
    @TableField(value="part")
    private String part;//施工部位
    @TableField(value = "apply_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    @TableField(value="memo")
    private String memo;//施工要求、质量及安全注意事项
    /**
     * 指令状态0申请中，1施工中，2已完工
     */
    @TableField(value="command_state")
    private Integer commandState;
    /**
     * 签证状态 ：3：7天内未办理，4办理中5办理完成，6超时未办
     */
    @TableField(value="visa_state")
    private Integer visaState;
    @TableField(value = "actual_begin_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualBeginDate; // 实际施工开始时间
    @TableField(value = "actual_end_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualEndDate; // 实际施工结束时间
    @TableField(value="remark")
    private String remark;//完工信息备注
    @TableField(value = "sure_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sureDate; // 确认时间
    @TableField(value="sure_people")
    private Long surePeople;//确认人
    @TableField(value="sure_people_name")
    private String surePeopleName;//确认人

    public Integer getCommandState() {
        return commandState;
    }

    public void setCommandState(Integer commandState) {
        this.commandState = commandState;
    }

    public Integer getCommandCause() {
        return commandCause;
    }

    public void setCommandCause(Integer commandCause) {
        this.commandCause = commandCause;
    }

    public Integer getVisaType() {
        return visaType;
    }

    public void setVisaType(Integer visaType) {
        this.visaType = visaType;
    }

    public Date getPlanBeginDate() {
        return planBeginDate;
    }

    public void setPlanBeginDate(Date planBeginDate) {
        this.planBeginDate = planBeginDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public String getPart() {
        return part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getVisaState() {
        return visaState;
    }

    public void setVisaState(Integer visaState) {
        this.visaState = visaState;
    }

    public Date getActualBeginDate() {
        return actualBeginDate;
    }

    public void setActualBeginDate(Date actualBeginDate) {
        this.actualBeginDate = actualBeginDate;
    }

    public Date getActualEndDate() {
        return actualEndDate;
    }

    public void setActualEndDate(Date actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getSureDate() {
        return sureDate;
    }

    public void setSureDate(Date sureDate) {
        this.sureDate = sureDate;
    }

    public Long getSurePeople() {
        return surePeople;
    }

    public void setSurePeople(Long surePeople) {
        this.surePeople = surePeople;
    }

    public String getSurePeopleName() {
        return surePeopleName;
    }

    public void setSurePeopleName(String surePeopleName) {
        this.surePeopleName = surePeopleName;
    }

    public Long getTeamId() {
        return teamId;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamCode() {
        return teamCode;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }



    public Date getPreUseWorkDate() {
        return preUseWorkDate;
    }

    public void setPreUseWorkDate(Date preUseWorkDate) {
        this.preUseWorkDate = preUseWorkDate;
    }

    public List<ApplicationDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ApplicationDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getUseWorkDetail() {
        return useWorkDetail;
    }

    public void setUseWorkDetail(String useWorkDetail) {
        this.useWorkDetail = useWorkDetail;
    }
    public Long getUseWorkTypeId() {
        return useWorkTypeId;
    }

    @ReferDeserialTransfer
    public void setUseWorkTypeId(Long useWorkTypeId) {
        this.useWorkTypeId = useWorkTypeId;
    }

    public String getUseWorkTypeName() {
        return useWorkTypeName;
    }

    public void setUseWorkTypeName(String useWorkTypeName) {
        this.useWorkTypeName = useWorkTypeName;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
