package com.ejianc.business.control.service;

import com.ejianc.business.control.vo.ControlChangeHisVO;
import com.ejianc.business.control.vo.ControlChangeVO;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.control.bean.ControlChangeEntity;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 分包招标控制价审核表-变更
 * 
 * @author generator
 * 
 */
public interface IControlChangeService extends IBaseService<ControlChangeEntity> {

    ControlChangeVO saveOrUpdate(ControlChangeVO saveOrUpdateVO);

    @Transactional(rollbackFor = Exception.class)
    ControlChangeEntity saveOrUpdateControlChange(ControlChangeEntity saveEntity);

    ControlChangeEntity getUnFinishedChange(Long sourceControlId);

    List<ControlChangeHisVO> queryDetailRecord(Long id);

    ParamsCheckVO checkParams(ControlChangeVO vo, Object o);

    void deleteChangeControl(List<Long> collect);
}
