package com.ejianc.business.process.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.PicKingEntity;
import com.ejianc.business.process.bean.PicKingTotalEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.mapper.PickingMapper;
import com.ejianc.business.process.service.IPicKingStoreService;
import com.ejianc.business.process.service.IPicKingTotalService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.vo.PicKingStoreVO;
import com.ejianc.business.process.vo.PicKingTotalVO;
import com.ejianc.business.process.vo.PicKingVO;
import com.ejianc.business.settle.service.IFinishSettleService;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author ljl
 */
@Service("pickingService")
public class PickingServiceImpl extends BaseServiceImpl<PickingMapper, PicKingEntity> implements IPickingService {

    private final String OPERATE = "PICKING_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/picking/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/picking/billDel";
    /**
     * 领料结算单据类型编码
     */
    private final String billType = "BT220117000000002";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IPicKingTotalService totalService;

    @Autowired
    private IFinishSettleService finishSettleService;

    @Autowired
    private IStoreFlowApi storeFlowApi;

    @Autowired
    private IPicKingTotalService picKingTotalService;

    @Autowired
    private IPicKingStoreService picKingStoreService;


    @Autowired
    private IAccountSettleApi accountSettleApi;

    public void qqq() {


        StoreApiVO storeApiVO = new StoreApiVO();
        accountSettleApi.changeSettleFlag(storeApiVO);
    }


    @Override
    public BigDecimal queryTotalNum(Long pickingId, String classifyCondition) {
        //根据当前 主表id和材料类型查询
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pickingId", new Parameter(QueryParam.EQ, pickingId));
        queryParam.getParams().put("classifyCondition", new Parameter(QueryParam.EQ, classifyCondition));
        List<PicKingTotalEntity> entities = totalService.queryList(queryParam, false);
        BigDecimal totalNum = BigDecimal.ZERO;
        for (PicKingTotalEntity total : entities) {
            totalNum = totalNum.add(total.getActualOutNum());
        }
        return totalNum;

    }

    /**
     * 单据推送到供方协同服务
     *
     * @param picKingEntity
     * @param billTypeCode  待推送单据的单据类型编码
     * @param cooperate     待推送单据的协同配置信息
     * @return
     */
    @Override
    public boolean pushBillToSupCenter(PicKingEntity picKingEntity, String billTypeCode, CooperateVO cooperate) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + picKingEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(picKingEntity.getId(), false);
            logger.error("推送领料结算单据-{}失败，获取当前系统编码失败,{}", picKingEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        picKingEntity.setSourceSystemId(ejcCloudSystemCode.getData());
        // 清空租户ID
        picKingEntity.setTenantId(null);

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                this.executeUpdate(picKingEntity.getId(), false);
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(picKingEntity));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(picKingEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();

                //Map<fileName, fileSourceType>
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }

                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                logger.info("向供应商-{}推送领料结算单据参数-{}", picKingEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        picKingEntity.getSupplierId().toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        this.executeUpdate(picKingEntity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(picKingEntity.getId(), false);
                        logger.error("供方id-{}处理推送领料结算单据id-{}失败, {}", picKingEntity.getSupplierId(), picKingEntity.getId(), billPushResp.getMsg());
                    }
                } else {
                    this.executeUpdate(picKingEntity.getId(), false);
                    logger.error("发送请求推送领料结算单据id-{}给供方id-{}失败, {}", picKingEntity.getId(), picKingEntity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                this.executeUpdate(picKingEntity.getId(), false);
                logger.error("获取领料结算单据id-{}对应附件信息失败, {}", picKingEntity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            this.executeUpdate(picKingEntity.getId(), false);
            logger.error("推送领料结算单据id-{}给供方id-{} 异常，", picKingEntity.getId(), picKingEntity.getSupplierId(), e);
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }


    /**
     * 更新单据推送状态
     * @param id 单据id
     * @param flag 是否成功推送
     */
    private void executeUpdate(Long id,Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<PicKingEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }


    /**
     * 同步单据供供应商签字信息
     *
     * @param request
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        logger.info("接收到单据签章通知：id-{}, supOperatorName-{}, supOperatorPhone-{}, supOperatorUserCode-{}, supOperateTime-{}, nameSourceTypeMapping-{}",
                billId, supOperatorName, supOperatorPhone, supOperatorUserCode, supOperateTime, nameSourceTypeMapping);

        PicKingEntity picKingEntity = super.selectById(billId);
        //设置供方签字信息
        picKingEntity.setSupOperateTime(supOperateTime);
        picKingEntity.setSupOperatorName(supOperatorName);
        picKingEntity.setSupOperatorPhone(supOperatorPhone);
        picKingEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = billType + "::" + picKingEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字状态更新失败，单据锁获取失败！";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, billType, authority, picKingEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            picKingEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态
            picKingEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());

            //更新单据
            super.saveOrUpdate(picKingEntity, false);

            //向单据制单人和经办人推送该消息
            String msgSendResult = sendMsg(picKingEntity, "供方已签字提醒", "领料结算单据[" + picKingEntity.getBillCode() + "]供方已签字完成");
            if (null != msgSendResult) {
                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(picKingEntity.getCreateUserId(), picKingEntity.getEmployeeId()),
                        picKingEntity.getId(), msgSendResult);
            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", picKingEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }


    /**
     * 通知用户消息
     *
     * @param picKingEntity
     */
    private String sendMsg(PicKingEntity picKingEntity, String subject, String content) {

        String[] msgRecUserIds = new String[]{picKingEntity.getCreateUserId().toString(), picKingEntity.getEmployeeId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(picKingEntity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }


    /**
     * 将推送至供方的单据作废
     *
     * @param picKingEntity
     * @param billTypeCode
     * @return
     */
    @Override
    public boolean delPushBill(PicKingEntity picKingEntity, String billTypeCode) {
        boolean locked = false, delSuc = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + picKingEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("通知供方领料结算单据单据-{}作废失败，获取当前系统编码失败,{}", picKingEntity.getId(), ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        picKingEntity.setSourceSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("sourceId", picKingEntity.getId().toString());
            paramMap.put("sourceSystemId", picKingEntity.getSourceSystemId());
            logger.info("领料结算单据id-{}弃审，通知供方-{}单据作废!", picKingEntity.getSupplierId(), picKingEntity.getId());

            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DEL_SUP_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    picKingEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    delSuc = true;
                } else {
                    logger.error("供方-{}处理作废领料结算单据id-{}作废失败, {}", picKingEntity.getSupplierId(), picKingEntity.getId(), supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", picKingEntity.getSupplierId(), picKingEntity.getId(), syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", picKingEntity.getId(), e);
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return delSuc;
    }


    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }


    @Override
    public CommonResponse<PicKingVO> queryPicking(Long contractId, Long projectId) {
        PicKingVO picKingVO = new PicKingVO();
        BigDecimal subtract = BigDecimal.ZERO.subtract(BigDecimal.ONE);
        System.out.println("subtract"+subtract);
        //查询当前合同是否做过完工结算
        CommonResponse commonResponse = finishSettleService.queryFinishFlag(contractId);
        if (!commonResponse.isSuccess()) {
            //当前合同已做完工结算
            return CommonResponse.error(commonResponse.getMsg());
        }
        //查询出库退库
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pickContractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("effectiveState", new Parameter(QueryParam.EQ, 1));
        queryParam.getParams().put("settleFlag", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("inOutFlag", new Parameter(QueryParam.EQ, 2));

        CommonResponse<List<FlowVO>> response = storeFlowApi.getFlowList(queryParam);
        logger.info("返回信息" + JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        List<PicKingStoreVO> outList = new ArrayList<>();
        List<PicKingStoreVO> exitList = new ArrayList<>();

        //获取查询到的数据
        List<FlowVO> flowVOList = response.getData();
        logger.info("仓库返回数据" + JSONObject.toJSONString(flowVOList));
        for (FlowVO flowVO : flowVOList) {

            PicKingStoreVO picKingStoreVO = BeanMapper.map(flowVO, PicKingStoreVO.class);
            picKingStoreVO.setStoreId(flowVO.getId());
//            //计算税率 taxRate 税额 tax 金额mny 无税金额 taxMny
            picKingStoreVO.setNum(flowVO.getNum() != null ? flowVO.getNum().abs() : BigDecimal.ZERO);
            picKingStoreVO.setPrice(flowVO.getPrice()!=null?flowVO.getPrice().abs():BigDecimal.ZERO);
            picKingStoreVO.setTaxPrice(flowVO.getTaxPrice()!=null?flowVO.getTaxPrice().abs():BigDecimal.ZERO);
            picKingStoreVO.setMny(flowVO.getMny() != null ? flowVO.getMny().abs() : BigDecimal.ZERO);
            picKingStoreVO.setTaxMny(flowVO.getTaxMny()!=null?flowVO.getTaxMny().abs():BigDecimal.ZERO);
//
//            //单价-（单价 *税率） = 无税单价   （单价-无税单价）^单价 = 税率
//            BigDecimal price = BigDecimal.ZERO;
//            BigDecimal taxPrice = BigDecimal.ZERO;
//            BigDecimal taxRate = BigDecimal.ZERO;

//
//            BigDecimal tax = BigDecimal.ZERO;
//            BigDecimal mny = BigDecimal.ZERO;
//            BigDecimal taxMny = BigDecimal.ZERO;
//            //计算税率
//            if (picKingStoreVO.getPrice()!=null&&picKingStoreVO.getTaxPrice()!=null){
//                price =  picKingStoreVO.getPrice();
//                taxPrice = picKingStoreVO.getTaxPrice();
//                BigDecimal subtract = taxPrice.subtract(price);
//                taxRate = subtract.divide(taxPrice,8,RoundingMode.HALF_UP);
//                //计算金额
//                taxMny = taxPrice.multiply(picKingStoreVO.getNum());
//                mny = price.multiply(picKingStoreVO.getNum());
//                tax = taxMny.subtract(mny);
//
//            }
//            picKingStoreVO.setMny(mny != null ? mny: BigDecimal.ZERO);
//            picKingStoreVO.setTaxMny(taxMny!= null ? taxMny : BigDecimal.ZERO);
//            picKingStoreVO.setTax(tax !=null?tax:BigDecimal.ZERO);
            picKingStoreVO.setPaymentFlag(0);
            if (flowVO.getReturnStoreFlag() == 0) {
                outList.add(picKingStoreVO);
            } else {
                exitList.add(picKingStoreVO);
            }

        }
        List<PicKingTotalVO> picKingTotalVOS = totalService.totalSumList(contractId, projectId);
        picKingVO.setTotalList(picKingTotalVOS);
        picKingVO.setOutList(outList);
        picKingVO.setExitList(exitList);
        return CommonResponse.success("查询数据成功", picKingVO);
    }

    @Override
    public void deletePicking(Long id) {
        UpdateWrapper<PicKingEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        super.remove(updateWrapper);

        picKingTotalService.deleteByPickingId(id);
        picKingStoreService.deleteByPickingId(id);

    }


}
