package com.ejianc.business.prosub.dataModel.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.dataModel.service.IDataModelService;
import com.ejianc.business.prosub.dataModel.vo.ContractDataModelVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping("dataModelController")
public class DataModelController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IDataModelService dataModelService;


    /**
     * 查询合同分包清单执行情况
     * @param param
     * @param request
     * @return
     */
    @RequestMapping(value = "/queryListByContract", method = RequestMethod.POST)
    public CommonResponse<List<ContractDataModelVO>> queryListByContract(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success("合同情况入参：" + JSONObject.toJSONString(param), dataModelService.queryListByContract(param));
    }

    /**
     * 查询合同分包清单执行情况
     * @param param
     * @param request
     * @return
     */
    @RequestMapping(value = "/queryListByProject", method = RequestMethod.POST)
    public CommonResponse<List<ContractDataModelVO>> queryListByProject(@RequestBody JSONObject param, HttpServletRequest request) {
        return CommonResponse.success("合同情况入参：" + JSONObject.toJSONString(param), dataModelService.queryListByProject(param));
    }

    /**
     * 本地测试使用
     * @return
     */
    @RequestMapping(value = "/queryListByContractTest", method = RequestMethod.POST)
    public CommonResponse<List<ContractDataModelVO>> queryListByContractTest() {
        return CommonResponse.success("合同情况入参：", dataModelService.queryListByContract(null));
    }

    /**
     * 本地测试使用
     * @return
     */
    @RequestMapping(value = "/queryListByProjectTest", method = RequestMethod.POST)
    public CommonResponse<List<ContractDataModelVO>> queryListByProjectTest() {
        return CommonResponse.success("合同情况入参：", dataModelService.queryListByProject(null));
    }
}