package com.ejianc.business.prosub.util;

import com.ejianc.business.prosub.utils.ITreeNodeB;
import com.ejianc.business.prosub.vo.ChangeDetailVO;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

public class ParamCtrlUtil {

    /**
     * 将前端传过来的合同清单树形结构数据转换为合同清单list，适用于分包合同的ContractDetailVO
     *
     * @param voList 用于存储转换后的合同清单数据
     * @param treeList 前端传过来的合同清单树形结构数据
     */
    public static <T extends ITreeNodeB> void treeToConDetailVOList(List<ContractDetailVO> voList, List<T> treeList) {
        if (CollectionUtils.isEmpty(treeList)) {
            return;
        }
        for (ITreeNodeB treeNode : treeList) {
            ContractDetailVO vo = (ContractDetailVO) treeNode;
            List<ITreeNodeB> child = vo.getChildren();
            if (CollectionUtils.isNotEmpty(child)) {
                treeToConDetailVOList(voList, child);
            }
            voList.add(vo);
        }
    }

    /**
     * 将前端传过来的合同变更清单树形结构数据转换为合同变更清单list，适用于分包合同变更的ChangeDetailVO
     *
     * @param voList 用于存储转换后的合同变更清单数据
     * @param treeList 前端传过来的合同变更清单树形结构数据
     */
    public static <T extends ITreeNodeB> void treeToChanDetailVOList(List<ChangeDetailVO> voList, List<T> treeList) {
        if (CollectionUtils.isEmpty(treeList)) {
            return;
        }
        for (ITreeNodeB treeNode : treeList) {
            ChangeDetailVO vo = (ChangeDetailVO) treeNode;
            List<ITreeNodeB> child = vo.getChildren();
            if (CollectionUtils.isNotEmpty(child)) {
                treeToChanDetailVOList(voList, child);
            }
            voList.add(vo);
        }
    }

    /**
     * 主要用于更新参数校验后的预警级别和当前的参数校验得到的预警信息添加到预警信息的list中
     *
     * @param checkOld 之前的参数校验返回的ParamsCheckVO
     * @param checkNow 当前的参数校验返回的ParamsCheckVO
     */
    public static void setAlertData(ParamsCheckVO checkOld, ParamsCheckVO checkNow) {
        if (checkNow == null || checkOld == null) {
            return;
        }
        // 拿到之前的预警级别
        String warnTypeOld = checkOld.getWarnType();
        // 之前的预警级别转换数字
        int warnTypeOldInt = ParamCtrlUtil.getWarnTypeInt(warnTypeOld, 2);
        // 封装预警信息
        String warnTypeNow = checkNow.getWarnType();
        if (org.apache.commons.lang.StringUtils.isNotBlank(warnTypeNow) && !"none".equals(warnTypeNow)) {
            // 拿到现在的预警级别并转换数字
            int warnTypeNowInt = ParamCtrlUtil.getWarnTypeInt(warnTypeNow, 2);
            if (warnTypeNowInt > warnTypeOldInt) {
                checkOld.setWarnType(warnTypeNow);
            }
            List<ParamsCheckDsVO> dataSource = checkNow.getDataSource();
            if (CollectionUtils.isNotEmpty(dataSource)) {
                checkOld.getDataSource().addAll(dataSource);
            }
        }
    }

    // 转换提醒等级  string->int  用于比较提醒等级高低
    public static int getWarnTypeInt(String warnTypeStr, int defaultTypeInt) {
        if (StringUtils.isBlank(warnTypeStr)) {
            return 1;
        }
        switch (warnTypeStr) {
            case "none":
                defaultTypeInt = 1;
                break;
            case "warn":
                defaultTypeInt = 2;
                break;
            case "alert":
                defaultTypeInt = 3;
                break;
            default:
                break;
        }
        return defaultTypeInt;
    }

    // 转换提醒等级  int->string
    public static String getWarnTypeStr(int warnTypeInt, String defaultTypeStr) {
        switch (warnTypeInt) {
            case 1:
                defaultTypeStr = "none";
                break;
            case 2:
                defaultTypeStr = "warn";
                break;
            case 3:
                defaultTypeStr = "alert";
                break;
            default:
                break;
        }
        return defaultTypeStr;
    }
}
