package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.INodeSettleService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 结算主实体
 *
 * @author generator
 */
@RestController
@RequestMapping("nodeSettle")
public class NodeSettleController implements Serializable {
    private static final long serialVersionUID = 1L;
    //劳务分包节点结算编码规则
    private static final String BILL_CODE = "NODE_SETTLE";
    //专业分包节点结算编码规则
    private static final String PRO_BILL_CODE = "PRO_NODE_SETTLE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private INodeSettleService service;
    @Autowired
    private ISettleService settleService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(entity.getContractType() == 0 ? BILL_CODE : PRO_BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //设置乙方签字状态
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        List<SettleDetailEntity> detailList = entity.getSettleDetailList();
        if (!detailList.isEmpty()) {
            Map<String, Long> idMap = new HashMap<>();
            for (SettleDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (sd.getId() == null || entity.getId() == null) {
                        sd.setId(IdWorker.getId());
                    }
                    idMap.put(sd.getTid(), sd.getId());
                    sd.setParentId(null);
                }
            }
            for (SettleDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (StringUtils.isNotEmpty(sd.getTpid())) {
                        sd.setParentId(idMap.get(sd.getTpid()));
                    }
                }
            }
        }
        // 初始化签章状态
        entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());


        service.saveOrUpdate(entity, false);
        //推送目标成本
        settleService.pushSettle2TargetCost(entity);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        // 获取结算明细
        List<SettleDetailVO> voList = vo.getSettleDetailList();
        if (!voList.isEmpty()) {
            for (SettleDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree(voList));
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = service.selectById(id);
        if (entity == null) {
            CommonResponse.error("查询详情异常！");
        }
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        List<SettleDetailVO> detailList = vo.getSettleDetailList();
        if (!detailList.isEmpty()) {
            for (SettleDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        //检查非自由态或驳回太单据不可删除
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        String checkResult = settleService.delCheck(billIds);
        if(StringUtils.isNotBlank(checkResult)) {
            return CommonResponse.error(checkResult);
        }

        //删除目标成本推送数据
        settleService.delSettleTargetCostInfo(billIds);
        service.removeByIds(billIds, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core. response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 结算类型：0-过程，1-完工，2-节点
        param.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.节点.getCode()));

        //查询本下
        Long orgId = InvocationInfoProxy.getOrgId();
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 结算类型：0-过程，1-完工，2-节点
        param.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.节点.getCode()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettleEntity> list = service.queryList(param);
        List<SettleVO> voList = BeanMapper.mapList(list, SettleVO.class);
        // 字段翻译
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            // fixme 签字状态待定
            vo.setSignStatusName(Objects.equals(vo.getSupplierSignStatus(), SupplierSignStatusEnum.乙方未签字.getCode()) ? "乙方未签字" : "乙方已签字");
            vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
        });

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("nodeSettle-export.xlsx", beans, response);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettleData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @RequestMapping(value = "/mnyCtrl", method=RequestMethod.POST)
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody SettleVO settleVO) {
        ParamsCheckVO response = service.mnyCtrl(settleVO, false);
        if (response == null) {
            logger.error("节点结算金额控制失败");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = paramCheck(settleVO, response, false);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    @RequestMapping(value = "/mnyCtrlById", method=RequestMethod.GET)
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value = "id") Long id) {
        SettleEntity settle = service.selectById(id);
        if (settle == null) {
            return CommonResponse.error("结算单不存在！");
        }
        SettleVO settleVO = BeanMapper.map(settle, SettleVO.class);
        ParamsCheckVO response = service.mnyCtrl(settleVO, true);
        if (response == null) {
            logger.error("节点结算金额控制失败");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = paramCheck(settleVO, response, true);
        return CommonResponse.success("参数校验成功！", responseData);
    }

    /**
     * 劳务/专业分包合同—节点结算  【合同量】控【节点结算量】  合同节点结算量 > 合同数量*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
     * 1、末级清单控制
     * 2、合同数量：取最新版本合同数量；
     * 3、结算数量：含本期累计节点结算量；(根据合同清单维度)
     *
     * @param settleVO
     * @param responseData
     * @param flag
     * @return
     */
    private ParamsCheckVO paramCheck(@RequestBody SettleVO settleVO, ParamsCheckVO responseData, boolean flag) {
        String responseDataWarnType = responseData.getWarnType();
        int resWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(responseDataWarnType, 1);
        // 校验  劳务/专业分包合同—节点结算  【合同量】控【节点结算量】  合同节点结算量 > 合同数量*X%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
        ParamsCheckVO checkVO = service.numCtrl(settleVO, flag);
        String warnType = checkVO.getWarnType();

        if (StringUtils.isNotBlank(warnType) && !"none".equals(warnType)) {
            // 如果大于之前的提醒等级，则使用当前的提醒等级
            int changeWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(warnType, 1);
            if (changeWarnTypeInt > resWarnTypeInt) {
                return checkVO;
            } else if(changeWarnTypeInt == resWarnTypeInt) {
                List<ParamsCheckDsVO> list = checkVO.getDataSource();
                if (CollectionUtils.isNotEmpty(list)) {
                    responseData.getDataSource().addAll(list);
                }
            }
        }
        return responseData;
    }

    /**
     * @Author
     * @Description  校验当前结算是否能新增节点结算支付比例确认单
     * @param
     * @Return
     * @return
     */
    @RequestMapping(value = "/addSettlePaymentFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> addSettlePaymentFlag(Long id) {
        Boolean flag = service.addSettlePaymentFlag(id, null);
        return CommonResponse.success("校验该节点结算可以新增节点结算支付比例确认单！", flag);
    }

    /**
     * 查询当前结算单下节点结算支付比例确认单列表
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySettlePaymentRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> querySettlePaymentRecord(Long id) {
        SettleVO vo = service.querySettlePaymentRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
