package com.ejianc.business.settle.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-分包清单
 *
 * @author generator
 */
public interface ISettleDetailService extends IBaseService<SettleDetailEntity> {
    /**
     * 查询结算清单子表数据和累计过程量
     * @param contractId
     * @return
     */
    List<SettleDetailVO> selectDetailRecordAndTotalProcessNum(Long contractId);

    /**
     * 查询结算清单累计节点量
     *
     * @param contractId
     * @return
     */
    List<SettleDetailVO> selectDetailTotalNodeNum(Long contractId);

    List<SettleDetailEntity> queryDetailList(Integer settleType, Long contractId, Date settleDate);

    IPage<SettleDetailEntity> selectPageDetail(Page<SettleDetailEntity> page, Integer settleType, Long contractId, String searchText, List<String> oldDelIdList);

    List<SettleDetailVO> addDetail(Long contractId);

    /**
     * 用于完工结算查询合同清单内容
     * @param contractId
     * @return
     */
    List<SettleDetailEntity> queryContractDetail(Long contractId);


}
