/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.process.bean.AdjustDetailEntity;
import com.ejianc.business.process.bean.AdjustEntity;
import com.ejianc.business.process.service.IAdjustService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adjust")
public class AdjustBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAdjustService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AdjustEntity entity = (AdjustEntity)((Object)this.service.selectById(billId));
        List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
        BigDecimal approveMny = BigDecimal.ZERO;
        for (AdjustDetailEntity detailEntity : detailList) {
            if (null != detailEntity.getDetailProjectNum() || null != detailEntity.getDetailProjectTaxPrice()) {
                detailEntity.setDetailFinishNum(detailEntity.getDetailProjectNum());
                detailEntity.setDetailFinishTaxMny(detailEntity.getDetailProjectTaxMny());
                detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailProjectTaxPrice());
                detailEntity.setDetailFinishMny(detailEntity.getDetailProjectMny());
                detailEntity.setDetailFinishTax(detailEntity.getDetailProjectTax());
                detailEntity.setDetailFinishPrice(detailEntity.getDetailProjectPrice());
            }
            if (null != detailEntity.getDetailBranchNum() || null != detailEntity.getDetailBranchTaxPrice()) {
                detailEntity.setDetailFinishNum(detailEntity.getDetailBranchNum());
                detailEntity.setDetailFinishTaxMny(detailEntity.getDetailBranchTaxMny());
                detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailBranchTaxPrice());
                detailEntity.setDetailFinishMny(detailEntity.getDetailBranchMny());
                detailEntity.setDetailFinishTax(detailEntity.getDetailBranchTax());
                detailEntity.setDetailFinishPrice(detailEntity.getDetailBranchPrice());
            }
            if (null != detailEntity.getDetailMasterNum() || null != detailEntity.getDetailMasterTaxPrice()) {
                detailEntity.setDetailFinishNum(detailEntity.getDetailMasterNum());
                detailEntity.setDetailFinishTaxMny(detailEntity.getDetailMasterTaxMny());
                detailEntity.setDetailFinishTaxPrice(detailEntity.getDetailMasterTaxPrice());
                detailEntity.setDetailFinishMny(detailEntity.getDetailMasterMny());
                detailEntity.setDetailFinishTax(detailEntity.getDetailMasterTax());
                detailEntity.setDetailFinishPrice(detailEntity.getDetailMasterPrice());
            }
            approveMny = ComputeUtil.safeAdd((BigDecimal)approveMny, (BigDecimal)detailEntity.getDetailFinishTaxMny());
        }
        entity.setApproveTime(new Date());
        entity.setApproveMny(approveMny);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AdjustEntity entity = (AdjustEntity)((Object)this.service.selectById(billId));
        if (!this.validateApproveTime(entity)) {
            return CommonResponse.error((String)"\u8be5\u5408\u540c\u4e0b\u975e\u6700\u65b0\u4ef7\u683c\u8c03\u6574\u4e0e\u589e\u8865\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AdjustEntity entity = (AdjustEntity)((Object)this.service.selectById(billId));
        List<AdjustDetailEntity> detailList = entity.getAdjustDetailList();
        BigDecimal approveMny = BigDecimal.ZERO;
        for (AdjustDetailEntity detailEntity : detailList) {
            detailEntity.setDetailFinishNum(null);
            detailEntity.setDetailFinishTaxMny(null);
            detailEntity.setDetailFinishTaxPrice(null);
            detailEntity.setDetailFinishMny(null);
            detailEntity.setDetailFinishTax(null);
            detailEntity.setDetailFinishPrice(null);
            detailEntity.setDetailBranchNum(null);
            detailEntity.setDetailBranchTaxMny(null);
            detailEntity.setDetailBranchTaxPrice(null);
            detailEntity.setDetailBranchMny(null);
            detailEntity.setDetailBranchTax(null);
            detailEntity.setDetailBranchPrice(null);
            detailEntity.setDetailMasterNum(null);
            detailEntity.setDetailMasterTaxMny(null);
            detailEntity.setDetailMasterTaxPrice(null);
            detailEntity.setDetailMasterMny(null);
            detailEntity.setDetailMasterTax(null);
            detailEntity.setDetailMasterPrice(null);
        }
        entity.setApproveTime(null);
        entity.setApproveMny(approveMny);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    private boolean validateApproveTime(AdjustEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.gt((Object)"apply_time", (Object)entity.getApproveTime());
        List list = this.service.list((Wrapper)wrapper);
        return list.isEmpty();
    }
}

