package com.ejianc.business.plan.service;

import com.ejianc.business.plan.bean.PlanDetailEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 分包总计划明细实体
 * 
 * @author generator
 * 
 */
public interface IPlanDetailService extends IBaseService<PlanDetailEntity> {
    /**
     * 根据Id删除列表数据
     *
     * @param delDetailIds 总计划物料Id列表
     * @param planId 总计划Id
     */
    void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId);

    /**
     * 根据SourceId查询匹配的数据，并根据innerCode向下查询
     *
     * @param planId
     * @param detailSourceIds
     * @param innerCodes
     * @return
     */
    List<PlanDetailEntity> getListBySourceIdsAndInnerCode(Long planId, List<Long> detailSourceIds, List<String> innerCodes);
}
