package com.ejianc.business.settle.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.bean.*;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.*;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ContractFilingTypeEnum;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.*;
import com.ejianc.business.settle.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {
    private final String OPERATE = "SETTLE_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settle/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settle/billDel";

    /**
     * 过程结算单据类型编码
     */
    private final String processBillType = "BT220114000000002";

    /**
     * 完工结算单据类型编码
     */
    private final String finishBillType = "BT220114000000004";

    /**
     * 节点结算单据类型编码
     */
    private final String nodeBillType = "BT220114000000003";

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IMeasureService measureService;
    @Autowired
    ISettleDetailService settleDetailService;
    @Autowired
    ISettlePickingService settlePickingService;
    @Autowired
    ISettleOddjobService settleOddjobService;
    @Autowired
    ISettleDeductService settleDeductService;
    @Autowired
    ISettleOtherService settleOtherService;
    @Autowired
    ISettleSalaryService settleSalaryService;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IPickingService pickingService;
    @Autowired
    private IRegistrationService oddjobService;
    @Autowired
    private IDeductionService deductService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISalaryApi salaryApi;
    @Autowired
    private IProgressService progressService;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareLabsubApi labsubApi;
    @Autowired
    private IShareProsubApi prosubApi;

    // 分包合同累计结算金额计算方式--系统参数中配置此参数
    private static final String SUB_CONTRACT_TOTAL_SETTLE_MNY_COUNT_SYS_PARAM = "P-Vm30230110";

    // 工人工资单平台查询 0：云南建投 1：郑州一建
    private final String SALARY_PARAMETER_CODE = "P-3r5moF0111";

    //完工单差额取值方式：1-使用过程结算取差额，2-使用节点结算取差额
    private final String FINISH_SETTLE_DIFFERENCE_CONFIG = "P-2hiWQQ0131";


    /**
     * @param contractId
     * @Description queryUnusedContract 查询合同是否被当前结算类型使用
     * 是否有审批中的单据，如果有不允许进行结算
     */
    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType, Long changeId) {
        SettleVO settleVO = new SettleVO();

        //若当前合同有完工结算单子 或 当前合同有其他未生效的结算单子 则不能添加新的结算单
        LambdaQueryWrapper<SettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SettleEntity::getContractId, contractId);
        lambda.eq(SettleEntity::getSettleType, SettleTypeEnum.完工.getCode());
        lambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        int resultCount = super.count(lambda);
        if (resultCount > 0) {
            return CommonResponse.error("当前合同已进行分包结算，请选择其他合同。");
        }

        //当前使用的合同的变更合同不能处于变更审批中状态
        if (null != changeId && settleType.equals(SettleTypeEnum.完工.getCode())) {
            LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
            changeContractLambda.eq(ChangeEntity::getId, changeId);
            changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
            int changeResultCount = changeService.count(changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error("当前合同正在进行变更，请选择其他合同。");
            }
        }


        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, contractId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = super.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = (null != resultList.get(0).getSettleType()) ? SettleTypeEnum.getDescriptionByCode(resultList.get(0).getSettleType()).getDescription() : "";
            if (null != resultList.get(0).getSettleType() && resultList.get(0).getSettleType() == 0){
                settleTypeName = "分包中间计量";
            }
            if (null != resultList.get(0).getSettleType() && resultList.get(0).getSettleType() == 1){
                settleTypeName = "分包结算";
            }
            return CommonResponse.error("当前合同有未审批的" + settleTypeName + "，请选择其他合同。");
        }
        if (null != settleType && SettleTypeEnum.完工.getCode().equals(settleType)) {
            //判断各合同过程是否有正在审批中的单据
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            //分包计量
            List<MeasureEntity> measureEntityList = measureService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(measureEntityList)) {
                return CommonResponse.error("当前合同在分包中间计量还有正在审批中的单据，请选择其他合同。");
            }
            //领料结算
            List<PicKingEntity> picKingEntityList = pickingService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(picKingEntityList)) {
                return CommonResponse.error("当前合同在领料结算还有正在审批中的单据，请选择其他合同。");
            }
            //零工登记
            List<RegistrationEntity> registrationEntityList = oddjobService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(registrationEntityList)) {
                return CommonResponse.error("当前合同在合同外签证办理还有正在审批中的单据，请选择其他合同。");
            }
            //奖罚扣款单
            List<DeductionEntity> deductionEntityList = deductService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(deductionEntityList)) {
                return CommonResponse.error("当前合同在奖罚扣款单还有正在审批中的单据，请选择其他合同。");
            }

            QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
            contractQuery.eq("contract_id", contractId);
            ContractEntity contractEntity = contractService.selectById(contractId);
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
                changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
                changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
                int changeResultCount = changeService.count(changeContractLambda);
                if (changeResultCount > 0) {
                    return CommonResponse.error("当前合同正在进行变更，不可以进行完工结算！");
                }
            }
        }
        //设置最小可用结算日期
        Date resultDate = queryMaxSettleDate(contractId);
//        if (null == resultDate) {
//            resultDate = null != settleDate ? settleDate : new Date();
//            settleVO.setMinSettleDate(null);
//        } else {
//            //如果页面日期大于当前查询出最大日期，则返回页面日期，否则返回最大日期加1
//            resultDate = DateUtils.addDays(resultDate, 1);
//            settleVO.setMinSettleDate(resultDate);
//            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
//                resultDate = settleDate;
//            }
//        }
        //TODO 调用查询合同相关数据方法
        settleVO.setSettleDate(resultDate);

        //华泰改造 获取上期累计审批金额
        LambdaQueryWrapper<SettleEntity> settleLambda2 = new LambdaQueryWrapper<>();
        settleLambda2.eq(SettleEntity::getContractId, contractId);
        settleLambda2.and(c -> c.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));
        List<SettleEntity> settleEntityList = super.list(settleLambda2);
        if(CollectionUtils.isNotEmpty(settleEntityList)){
            BigDecimal totalApproveTaxMny = settleEntityList.stream().filter(item -> null != item.getTaxMny()).map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalApproveMny = settleEntityList.stream().filter(item -> null != item.getMny()).map(SettleEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settleVO.setTotalApproveTaxMny(totalApproveTaxMny);
            settleVO.setTotalApproveMny(totalApproveMny);
        }

        return CommonResponse.success("当前合同可用！", settleVO);
    }

    /**
     * 根据合同id查询当前合同最大结算日期
     *
     * @param contractId
     * @return
     */
    @Override
    public Date queryMaxSettleDate(Long contractId) {
        return settleMapper.selectMaxSettleDate(contractId);
    }

    /**
     * 判断当前系统是云南建投还是郑州一建
     * @return 0：云南建投 1：郑州一建
     */
    @Override
    public String salaryParameterFlag() {
        // 分包合同月度结算是否推送协同
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(SALARY_PARAMETER_CODE);
        if (!response.isSuccess() || response.getData() == null) {
            logger.error("根据系统参数编码-{}，查询系统参数（分包合同月度结算是否推送协同）配置信息，失败原因：{}", SALARY_PARAMETER_CODE, response.getMsg());
            //查询参数失败时按不控制处理。
            return "0";//默认云南建投
        }
        return response.getData().getValueData();
    }

    @Override
    public void fillOtherSettlePoolAttr(SettleEntity dbEntity, SettlePoolVO poolVO) {
        ContractEntity contract = contractService.selectById(dbEntity.getContractId());
        // 主合同
        poolVO.setMaiContractId(contract.getMainContractId());
        poolVO.setMaiContractName(contract.getMainContractName());
        poolVO.setMaiContractCode(contract.getMainContractCode());
        // 甲方
        poolVO.setPartyaId(contract.getFirstPartyId());
        poolVO.setPartyaName(contract.getFirstPartyName());
        // 签订日期
        poolVO.setSignDate(contract.getSignDate());
        // 创建时间和人员 使用 结算单的创建时间和人员
        poolVO.setCreateTime(dbEntity.getCreateTime());
        poolVO.setCreateUserCode(dbEntity.getCreateUserCode());
        // 更新时间和人员 使用 结算单的更新时间和人员
        poolVO.setUpdateTime(dbEntity.getUpdateTime());
        poolVO.setUpdateUserCode(dbEntity.getUpdateUserCode());
    }

    @Override
    public int queryContractSettleNumOfNode(Long contractId) {
        return baseMapper.queryContractSettleNumOfNode(contractId);
    }

    @Override
    public void pushSettle2TargetCost(Long settleId) {
        pushSettle2TargetCost(selectById(settleId));
    }

    @Override
    public ExecutionVO prepareExecutionVO(SettleEntity settle) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        totalVO.setSourceId(settle.getId());
        totalVO.setTenantId(settle.getTenantId());
        totalVO.setBillCode(settle.getBillCode());

        if(SettleTypeEnum.过程.getCode().equals(settle.getSettleType())) {
            //单据类型
            totalVO.setBillType(Integer.valueOf(0).equals(settle.getContractType()) ?
                    ProsubBillTypeEnum.劳务分包合同过程结算.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同过程结算.getBillTypeCode());
            //业务类型
            totalVO.setBussinessType(Integer.valueOf(0).equals(settle.getContractType()) ?
                    BussinessTypeEnum.劳务分包月度结算单.getCode() : BussinessTypeEnum.专业分包月度结算单.getCode());
        } else if(SettleTypeEnum.节点.getCode().equals(settle.getSettleType())) {
            //单据类型
            totalVO.setBillType(Integer.valueOf(0).equals(settle.getContractType()) ?
                    ProsubBillTypeEnum.劳务分包合同节点结算.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同节点结算.getBillTypeCode());
            //业务类型
            totalVO.setBussinessType(Integer.valueOf(0).equals(settle.getContractType()) ?
                    BussinessTypeEnum.劳务分包节点结算单.getCode() : BussinessTypeEnum.专业分包节点结算单.getCode());
        } else {
            //单据类型
            totalVO.setBillType(Integer.valueOf(0).equals(settle.getContractType()) ?
                    ProsubBillTypeEnum.劳务分包合同完工结算.getBillTypeCode() : ProsubBillTypeEnum.专业分包合同完工结算.getBillTypeCode());
            //单据业务类型
            totalVO.setBussinessType(Integer.valueOf(0).equals(settle.getContractType()) ?
                    BussinessTypeEnum.劳务分包完工结算单.getCode() : BussinessTypeEnum.专业分包完工结算单.getCode());
        }
        //业务分类
        totalVO.setBillCategory(BillCategoryEnum.结算.getCode());
        totalVO.setProjectId(settle.getProjectId());
        totalVO.setOrgId(settle.getOrgId());
        //合同Id
        totalVO.setContractId(settle.getContractId());

        totalVO.setBillDate(null != settle.getCreateTime() ? sdf.format(settle.getCreateTime()) : sdf.format(new Date()));
        totalVO.setMoney(settle.getMny());
        totalVO.setTaxMoney(settle.getTaxMny());
        totalVO.setLinkUrl(getLinkUrl(settle, totalVO.getBillType()));
        totalVO.setMemo(settle.getMemo());
        executionVO.setTotalVO(totalVO);

        List<SettleDetailEntity> settleDetailList = settle.getSettleDetailList().stream()
                .filter(item -> null != item.getSettleNum() && null != item.getDetailPrice())
                .collect(Collectors.toList());
        if(CollectionUtils.isEmpty(settleDetailList)) {
            throw new BusinessException("结算单目标成本推送失败，结算明细没有叶子结点！");
        }
        settleDetailList.stream().forEach(settleDetail -> {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(settleDetail.getId());
            // 来源主表id
            detailExecutionVO.setSourceBillId(settle.getId());
            detailExecutionVO.setCategoryId(settleDetail.getDocCategoryId()); // 档案分类ID
            // 根据档案id判断是否是分类
            detailExecutionVO.setCategoryFlag(settleDetail.getDocId() == null);
            detailExecutionVO.setCategoryContainFlag(false);

            // 根据档案分类id查询档案分类信息
            if (null == settleDetail.getDocCategoryId()){
                throw new BusinessException("档案分类id不能为空");
            }
            // 档案id
            if (settleDetail.getDocId() == null) {
                throw new BusinessException("档案id不能为空");
            }
            detailExecutionVO.setDocId(settleDetail.getDocId());
            if (Integer.valueOf(0).equals(settle.getContractType())){
                detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
            }else {
                detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
            }
//            detailExecutionVO.setCode(settleDetail.getSourceBillCode());
            detailExecutionVO.setName(settleDetail.getDetailName());
            detailExecutionVO.setUnitName(settleDetail.getDetailUnit());
            detailExecutionVO.setNum(settleDetail.getSettleNum());
            detailExecutionVO.setTaxPrice(settleDetail.getDetailTaxPrice());
            detailExecutionVO.setPrice(settleDetail.getDetailPrice());
            detailExecutionVO.setSpec(settleDetail.getDetailMeasurementRules());
            detailExecutionVO.setMemo(settleDetail.getMemo());
            detailExecutionVO.setMoney(settleDetail.getSettleMny());
            detailExecutionVO.setTaxMoney(settleDetail.getSettleTaxMny());
            detailExecutionVO.setContractId(settle.getContractId());
            detailExecutionVO.setLinkUrl(totalVO.getLinkUrl());
            detailExecutionVO.setBillDate(null != settleDetail.getCreateTime() ? sdf.format(settleDetail.getCreateTime()) : sdf.format(new Date()));
            detailExecutionVO.setContractDetailId(settleDetail.getContractDetailId());
            detailList.add(detailExecutionVO);
        });
        //设备分类编码信息赋值
        //根据分类ID查询物料分类信息
        if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> docIdList = detailList.stream().map(DetailExecutionVO::getDocId).collect(Collectors.toList());
            if (Integer.valueOf(0).equals(settle.getContractType())){
                CommonResponse<List<LabsubItemVO>> listCommonResponse = labsubApi.queryLabsubItemByIds(docIdList);
                logger.info("根据分类ID-{}，获取到档案信息：{}", JSONObject.toJSONString(docIdList), JSONObject.toJSONString(listCommonResponse));
                if (listCommonResponse.isSuccess()){
                    List<LabsubItemVO> labSubItemList = listCommonResponse.getData();
                    logger.info("根据分类ID获取到档案信息：{}", JSONObject.toJSONString(labSubItemList));
                    if (CollectionUtils.isNotEmpty(labSubItemList)){
                        Map<Long, LabsubItemVO> labSubItemVOMap = labSubItemList.stream().collect(Collectors.toMap(LabsubItemVO::getId, Function.identity(), (key1, key2) -> key2));
                        for (DetailExecutionVO detailExecutionVO : detailList) {
                            if (null != labSubItemVOMap.get(detailExecutionVO.getDocId())){
                                detailExecutionVO.setCode(labSubItemVOMap.get(detailExecutionVO.getDocId()).getTrawlingCode());
                            }
                        }
                    }
                }
            }else{
                CommonResponse<List<ProsubItemVO>> listCommonResponse = prosubApi.queryProsubItemByIds(docIdList);
                logger.info("根据分类ID-{}，获取到档案信息：{}", JSONObject.toJSONString(docIdList), JSONObject.toJSONString(listCommonResponse));
                if (listCommonResponse.isSuccess()){
                    List<ProsubItemVO> proSubItemList = listCommonResponse.getData();
                    logger.info("根据分类ID获取到档案信息：{}", JSONObject.toJSONString(proSubItemList));
                    if (CollectionUtils.isNotEmpty(proSubItemList)){
                        Map<Long, ProsubItemVO> proSubItemVOMap = proSubItemList.stream().collect(Collectors.toMap(ProsubItemVO::getId, Function.identity(), (key1, key2) -> key2));
                        for (DetailExecutionVO detailExecutionVO : detailList) {
                            if (null != proSubItemVOMap.get(detailExecutionVO.getDocId())){
                                detailExecutionVO.setCode(proSubItemVOMap.get(detailExecutionVO.getDocId()).getTrawlingCode());
                            }
                        }
                    }
                }
            }
        }

        executionVO.setDetailList(detailList);

        return executionVO;
    }

    @Override
    public CostCtrlVO sjCost(SettleVO settleVO) {
        List<SettleDetailVO> detailList = settleVO.getSettleDetailList();
        List<SettleOtherVO> otherList = settleVO.getSettleOtherList();
        List<SettleOddjobVO> oddjobList = settleVO.getSettleOddjobList();
        List<SettlePickingVO> pickingList = settleVO.getSettlePickingList();
        List<SettleDeductVO> deductList = settleVO.getSettleDeductList();

        Map<Long, CostCtrlDetailVO> detailVOMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(detailList)){
            for (SettleDetailVO detailVO : detailList){
                if (!"del".equals(detailVO.getRowState()) && null != detailVO.getSettleNum() && null != detailVO.getDetailSubjectId()){
                    if (detailVOMap.containsKey(detailVO.getDetailSubjectId())){
                        detailVOMap.get(detailVO.getDetailSubjectId()).setMny(ComputeUtil.safeAdd(detailVOMap.get(detailVO.getDetailSubjectId()).getMny(), SettleTypeEnum.完工.getCode().equals(detailVO.getSettleType()) ? detailVO.getProcessDifference() : detailVO.getSettleMny()));
                        detailVOMap.get(detailVO.getDetailSubjectId()).setTaxMny(ComputeUtil.safeAdd(detailVOMap.get(detailVO.getDetailSubjectId()).getTaxMny(), SettleTypeEnum.完工.getCode().equals(detailVO.getSettleType()) ? detailVO.getProcessTaxDifference() : detailVO.getSettleTaxMny()));
                    }else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(detailVO.getDetailSubjectId());
                        costCtrlDetailVO.setSubjectCode(detailVO.getDetailSubjectCode());
                        costCtrlDetailVO.setSubjectName(detailVO.getDetailSubjectName());
                        costCtrlDetailVO.setMny(SettleTypeEnum.完工.getCode().equals(detailVO.getSettleType()) ? detailVO.getProcessDifference() : detailVO.getSettleMny());
                        costCtrlDetailVO.setTaxMny(SettleTypeEnum.完工.getCode().equals(detailVO.getSettleType()) ? detailVO.getProcessTaxDifference() : detailVO.getSettleTaxMny());
                        detailVOMap.put(detailVO.getDetailSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)){
            for (SettleOtherVO settleOtherVO : otherList){
                if (!"del".equals(settleOtherVO.getRowState()) && null != settleOtherVO.getOtherSubjectId()){
                    if (detailVOMap.containsKey(settleOtherVO.getOtherSubjectId())){
                        detailVOMap.get(settleOtherVO.getOtherSubjectId()).setMny(ComputeUtil.safeAdd(detailVOMap.get(settleOtherVO.getOtherSubjectId()).getMny(), settleOtherVO.getMny()));
                        detailVOMap.get(settleOtherVO.getOtherSubjectId()).setTaxMny(ComputeUtil.safeAdd(detailVOMap.get(settleOtherVO.getOtherSubjectId()).getTaxMny(), settleOtherVO.getTaxMny()));
                    }else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(settleOtherVO.getOtherSubjectId());
                        costCtrlDetailVO.setSubjectCode(settleOtherVO.getOtherSubjectCode());
                        costCtrlDetailVO.setSubjectName(settleOtherVO.getOtherSubjectName());
                        costCtrlDetailVO.setMny(settleOtherVO.getMny());
                        costCtrlDetailVO.setTaxMny(settleOtherVO.getTaxMny());
                        detailVOMap.put(settleOtherVO.getOtherSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        //零工登记
        if (CollectionUtils.isNotEmpty(oddjobList)){
            for (SettleOddjobVO oddjobVO : oddjobList){
                if (!"del".equals(oddjobVO.getRowState()) && null != oddjobVO.getOddjobSubjectId()){
                    if (detailVOMap.containsKey(oddjobVO.getOddjobSubjectId())){
                        detailVOMap.get(oddjobVO.getOddjobSubjectId()).setMny(ComputeUtil.safeAdd(detailVOMap.get(oddjobVO.getOddjobSubjectId()).getMny(), oddjobVO.getOddjobMny()));
                        detailVOMap.get(oddjobVO.getOddjobSubjectId()).setTaxMny(ComputeUtil.safeAdd(detailVOMap.get(oddjobVO.getOddjobSubjectId()).getTaxMny(), oddjobVO.getOddjobTaxMny()));
                    }else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(oddjobVO.getOddjobSubjectId());
                        costCtrlDetailVO.setSubjectCode(oddjobVO.getOddjobSubjectCode());
                        costCtrlDetailVO.setSubjectName(oddjobVO.getOddjobSubjectName());
                        costCtrlDetailVO.setMny(oddjobVO.getOddjobMny());
                        costCtrlDetailVO.setTaxMny(oddjobVO.getOddjobTaxMny());
                        detailVOMap.put(oddjobVO.getOddjobSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        logger.info("组装成本科目控制子表数据----->detailVOMap：{}", JSONObject.toJSONString(detailVOMap));
        //领料结算
        if (CollectionUtils.isNotEmpty(pickingList)){
            for (SettlePickingVO pickingVO : pickingList){
                if (!"del".equals(pickingVO.getRowState()) && null != pickingVO.getPickingSubjectId()){
                    if (detailVOMap.containsKey(pickingVO.getPickingSubjectId())){
                        detailVOMap.get(pickingVO.getPickingSubjectId()).setMny(ComputeUtil.safeAdd(detailVOMap.get(pickingVO.getPickingSubjectId()).getMny(), pickingVO.getCostMny().negate()));
                        detailVOMap.get(pickingVO.getPickingSubjectId()).setTaxMny(ComputeUtil.safeAdd(detailVOMap.get(pickingVO.getPickingSubjectId()).getTaxMny(), pickingVO.getCostMny().negate()));
                    }else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(pickingVO.getPickingSubjectId());
                        costCtrlDetailVO.setSubjectCode(pickingVO.getPickingSubjectCode());
                        costCtrlDetailVO.setSubjectName(pickingVO.getPickingSubjectName());
                        costCtrlDetailVO.setMny(pickingVO.getCostMny().negate());
                        costCtrlDetailVO.setTaxMny(pickingVO.getCostTaxMny().negate());
                        detailVOMap.put(pickingVO.getPickingSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        logger.info("组装成本科目控制子表数据----->加领料结算后detailVOMap：{}", JSONObject.toJSONString(detailVOMap));
        //奖罚扣款单
        if (CollectionUtils.isNotEmpty(deductList)){
            for (SettleDeductVO deductVO : deductList){
                if (!"del".equals(deductVO.getRowState()) && null != deductVO.getDeductSubjectId()){
                    if (detailVOMap.containsKey(deductVO.getDeductSubjectId())){
                        detailVOMap.get(deductVO.getDeductSubjectId()).setMny(ComputeUtil.safeAdd(detailVOMap.get(deductVO.getDeductSubjectId()).getMny(), 0 == deductVO.getRewardDeductionType() ? deductVO.getDeductMny() : deductVO.getDeductMny().negate()));
                        detailVOMap.get(deductVO.getDeductSubjectId()).setTaxMny(ComputeUtil.safeAdd(detailVOMap.get(deductVO.getDeductSubjectId()).getTaxMny(), 0 == deductVO.getRewardDeductionType() ? deductVO.getDeductTaxMny() : deductVO.getDeductTaxMny().negate()));
                    }else {
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(deductVO.getDeductSubjectId());
                        costCtrlDetailVO.setSubjectCode(deductVO.getDeductSubjectCode());
                        costCtrlDetailVO.setSubjectName(deductVO.getDeductSubjectName());
                        costCtrlDetailVO.setMny(0 == deductVO.getRewardDeductionType() ? deductVO.getDeductMny() : deductVO.getDeductMny().negate());
                        costCtrlDetailVO.setTaxMny(0 == deductVO.getRewardDeductionType() ? deductVO.getDeductTaxMny() : deductVO.getDeductTaxMny().negate());
                        detailVOMap.put(deductVO.getDeductSubjectId(), costCtrlDetailVO);
                    }
                }
            }
        }
        if(null != detailVOMap && detailVOMap.size() > 0){
            CostCtrlVO ctrlVO = new CostCtrlVO();
            if(null != settleVO.getId()) {
                ctrlVO.setSourceId(settleVO.getId());
            }
            ctrlVO.setOrgId(settleVO.getOrgId());
            ctrlVO.setProjectId(settleVO.getProjectId());
            ctrlVO.setDetailList(new ArrayList<>(detailVOMap.values()));
             logger.info("组装成本科目控制子表数据：{}", JSONObject.toJSONString(ctrlVO.getDetailList()));
            return ctrlVO;
        }
        return null;
    }

    @Override
    public void pushSettle2TargetCost(SettleEntity settle) {
        logger.info("-------- 结算单推送目标成本 start -------- id:{}", settle.getId());
        ExecutionVO executionVO = prepareExecutionVO(settle);

        logger.info("结算单目标成本推送数据：{}", JSONObject.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()){
            throw new BusinessException("结算单目标成本推送失败,"+response.getMsg());
        }

        logger.info("-------- 结算单推送目标成本 end -------- id:{}", settle.getId());
    }

    @Override
    public void delSettleTargetCostInfo(List<Long> billIds) {
        logger.info("-------- 结算单删除推送目标成本数据 start -------- ids:{}", JSONObject.toJSONString(billIds));
        List<TotalExecutionVO> delList = new ArrayList<>();
        billIds.forEach(settleId -> {
            delList.add(prepareExecutionVO(selectById(settleId)).getTotalVO());
        });
        executionApi.aggDel(delList);
        logger.info("结算单目标成本删除数据" + JSON.toJSONString(delList));
        CommonResponse<String> response = executionApi.aggDel(delList);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本删除失败," + response.getMsg());
        }

        logger.info("-------- 结算单删除推送目标成本数据 end -------- ids:{}", JSONObject.toJSONString(billIds));
    }

    private String getLinkUrl(SettleEntity settle, String billType) {
        String settleType = null, contractType = null;
        switch (ProsubBillTypeEnum.getByCode(billType)) {
            case 劳务分包合同过程结算:
                settleType = "processSettle"; contractType = "laborsub";
                break;
            case 专业分包合同过程结算:
                settleType = "processSettle"; contractType = "prosub";
                break;
            case 劳务分包合同节点结算:
                settleType = "nodeSettle"; contractType = "laborsub";
                break;
            case 专业分包合同节点结算:
                settleType = "nodeSettle"; contractType = "prosub";
                break;
            case 劳务分包合同完工结算:
                settleType = "finishSettle"; contractType = "laborsub";
                break;
            case 专业分包合同完工结算:
                settleType = "finishSettle"; contractType = "prosub";
                break;
            default:
                throw new BusinessException("错误的结算单类型");
        }
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = BASE_HOST;
        }

        return frontendBaseHost + "ejc-prosub-frontend/#/" + settleType + "/" + contractType + "/card?id=" + settle.getId().toString();
    }

    /**
     * 查询子表数据
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return SettleEntity
     */
    @Override
    public SettleEntity querySubTableList(Integer settleType, Long contractId, Date settleDate) {
        SettleEntity e = new SettleEntity();
        if (!SettleTypeEnum.完工.getCode().equals(settleType)) {
            e.setSettleDetailList(settleDetailService.queryDetailList(settleType, contractId, settleDate));
        } else {
            e.setSettleDetailList(settleDetailService.queryContractDetail(contractId));
        }
//        e.setSettlePickingList(settlePickingService.queryPickingList(settleType, contractId, settleDate));

        //设置零工登记
        e.setSettleOddjobList(settleOddjobService.queryOddjobList(settleType, contractId, settleDate));
        //设置零工转扣
//        e.getSettleOddjobList().addAll(settleOddjobService.queryOddjobDeductList(settleType, contractId, settleDate));

        e.setSettleDeductList(settleDeductService.queryDeductList(settleType, contractId, settleDate));

        //华泰 增加形象进度子表

        LambdaQueryWrapper<ProgressEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(ProgressEntity::getContractId,contractId);
        lambdaQueryWrapper.eq(ProgressEntity::getSettleFlag,0);
        lambdaQueryWrapper.le(ProgressEntity::getEndTime,settleDate);
        lambdaQueryWrapper.in(ProgressEntity::getBillState,1,3);
        List<ProgressEntity> progressEntityList = progressService.list(lambdaQueryWrapper);
        List<SettleProgressEntity> settleProgressList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(progressEntityList)){
            progressEntityList.forEach(item->{
                SettleProgressEntity settleProgressEntity = new SettleProgressEntity();
                settleProgressEntity.setRowState("add");
                settleProgressEntity.setSourceId(item.getId());
                settleProgressEntity.setSourceBillCode(item.getBillCode());
                settleProgressEntity.setSourceBillDate(item.getCreateTime());
                settleProgressEntity.setProgressEmployeeId(item.getEmployeeId());
                settleProgressEntity.setProgressEmployeeName(item.getEmployeeName());
                settleProgressEntity.setProgressEndTime(item.getEndTime());
                settleProgressEntity.setProgressStartTime(item.getStartTime());
                settleProgressList.add(settleProgressEntity);
            });
            e.setSettleProgressList(settleProgressList);
        }

        //其他费用不需要自动带出
//        e.setSettleOtherList(settleOtherService.queryOtherList(settleType, contractId));
        //工人工资单
//        if (2 != settleType){//节点结算没有工人工资单
//            String salaryParameter = salaryParameterFlag();
//            if ("0".equals(salaryParameter)){
//                //云南建投
//                e.setSettleSalaryList(settleSalaryService.querySalaryList(settleType, contractId, settleDate));
//            }else {
//                //郑州一建
//                CommonResponse<List<SalaryVO>> salaryData = salaryApi.querySalaryList(contractId, settleType, DateUtil.formatDate(settleDate));
//                List<SettleSalaryEntity> settleSalaryList = new ArrayList<>();
//                if (salaryData.isSuccess()){
//                    List<SalaryVO> zzyjSalaryList = salaryData.getData();
//                    if (CollectionUtils.isNotEmpty(zzyjSalaryList)){
//                        for (SalaryVO salaryVO : zzyjSalaryList) {
//                            SettleSalaryEntity settleSalaryEntity = new SettleSalaryEntity();
//                            settleSalaryEntity.setContractId(salaryVO.getContractId());
//                            settleSalaryEntity.setBelongMonth(salaryVO.getBelongMonth());
//                            settleSalaryEntity.setSumSalaryMny(salaryVO.getTotalSalaryMny());
//                            settleSalaryEntity.setSalaryMny(salaryVO.getTotalSalaryMny());
//                            settleSalaryEntity.setSourceId(salaryVO.getId());
//                            settleSalaryEntity.setSourceBillCode(salaryVO.getBillCode());
//                            settleSalaryList.add(settleSalaryEntity);
//                        }
//                    }
//                }
//                e.setSettleSalaryList(settleSalaryList);
//            }
//        }

        //完工专用字段查询
        //设置领料结算累计过程结算金额
        SettleVO processPickingVO = selectPickingProcessTaxMny(contractId);
        //设置零工登记累计过程结算金额
        SettleVO processOddjobVO = selectOddjobProcessTaxMny(contractId);
        //设置奖罚扣款单累计过程结算金额
        List<SettleDeductVO> SettleDeductList = selectDeductList(contractId);
        //设置其他清单累计过程结算金额
        SettleVO processOtherVO = selectOtherProcessTaxMny(contractId);
        if (null != processPickingVO) {
            e.setPickingProcessTaxMny(null != processPickingVO.getPickingProcessTaxMny() ? processPickingVO.getPickingProcessTaxMny() : BigDecimal.ZERO);
            e.setPickingProcessMny(null != processPickingVO.getPickingProcessMny() ? processPickingVO.getPickingProcessMny() : BigDecimal.ZERO);
        } else {
            e.setPickingProcessTaxMny(BigDecimal.ZERO);
            e.setPickingProcessMny(BigDecimal.ZERO);
        }
        if (null != processOddjobVO) {
            e.setOddjobProcessTaxMny(null != processOddjobVO.getOddjobProcessTaxMny() ? processOddjobVO.getOddjobProcessTaxMny() : BigDecimal.ZERO);
            e.setOddjobProcessMny(null != processOddjobVO.getOddjobProcessMny() ? processOddjobVO.getOddjobProcessMny() : BigDecimal.ZERO);
        } else {
            e.setOddjobProcessTaxMny(BigDecimal.ZERO);
            e.setOddjobProcessMny(BigDecimal.ZERO);
        }
        if (CollectionUtils.isNotEmpty(SettleDeductList)) {
            BigDecimal processTaxMny = BigDecimal.ZERO;
            BigDecimal processMny = BigDecimal.ZERO;
            for (SettleDeductVO settleDeduct : SettleDeductList) {
                //如果是奖励，则叠加累计过程结算金额
                if (settleDeduct.getRewardDeductionType().equals(0)) {
                    processTaxMny = processTaxMny.add(settleDeduct.getDeductTaxMny());
                    processMny = processMny.add(settleDeduct.getDeductMny());
                } else {//如果非奖励，则减去结算金额
                    processTaxMny = processTaxMny.subtract(settleDeduct.getDeductTaxMny());
                    processMny = processMny.subtract(settleDeduct.getDeductMny());
                }
            }
            e.setDeductProcessTaxMny(processTaxMny);
            e.setDeductProcessMny(processMny);
        } else {
            e.setDeductProcessTaxMny(BigDecimal.ZERO);
            e.setDeductProcessMny(BigDecimal.ZERO);
        }
        if (null != processOtherVO) {
            e.setOtherProcessTaxMny(null != processOtherVO.getOtherProcessTaxMny() ? processOtherVO.getOtherProcessTaxMny() : BigDecimal.ZERO);
            e.setOtherProcessMny(null != processOtherVO.getOtherProcessMny() ? processOtherVO.getOtherProcessMny() : BigDecimal.ZERO);
        } else {
            e.setOtherProcessTaxMny(BigDecimal.ZERO);
            e.setOtherProcessMny(BigDecimal.ZERO);
        }
        return e;
    }


    @Override
    public SettleVO selectPickingProcessTaxMny(Long contractId) {
        return settleMapper.selectPickingProcessTaxMny(contractId);
    }

    @Override
    public SettleVO selectOddjobProcessTaxMny(Long contractId) {
        return settleMapper.selectOddjobProcessTaxMny(contractId);
    }

    @Override
    public List<SettleDeductVO> selectDeductList(Long contractId) {
        return settleMapper.selectDeductList(contractId);
    }

    @Override
    public SettleVO selectOtherProcessTaxMny(Long contractId) {
        return settleMapper.selectOtherProcessTaxMny(contractId);
    }


    /**
     * 单据推送到供方协同服务
     *
     * @param settleEntity 结算主实体
     * @param billTypeCode 待推送单据的单据类型编码
     * @param cooperate    待推送单据的协同配置信息
     * @return 推送结果
     */
    @Override
    public Boolean pushBillToSupCenter(SettleEntity settleEntity, String billTypeCode, CooperateVO cooperate) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + settleEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(settleEntity.getId(), false);
            logger.error("推送结算单据-{}失败，获取当前系统编码失败,{}", settleEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        settleEntity.setSourceSystemId(ejcCloudSystemCode.getData());
        // 清空租户ID
        settleEntity.setTenantId(null);

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                this.executeUpdate(settleEntity.getId(), false);
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(settleEntity));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(settleEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();

                //Map<fileName, fileSourceType>
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }

                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));

                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                logger.info("向供应商-{}推送结算单据参数-{}", settleEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        settleEntity.getSupplierId().toString(),
                        files);

                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        this.executeUpdate(settleEntity.getId(), true);
                        return true;
                    } else {
                        this.executeUpdate(settleEntity.getId(), false);
                        logger.error("供方id-{}处理推送结算单据id-{}失败, {}", settleEntity.getSupplierId(), settleEntity.getId(), billPushResp.getMsg());
                        return false;
                    }
                } else {
                    this.executeUpdate(settleEntity.getId(), false);
                    logger.error("发送请求推送结算单据id-{}给供方id-{}失败, {}", settleEntity.getId(), settleEntity.getSupplierId(), syncReqResp.getMsg());
                    return false;
                }
            } else {
                this.executeUpdate(settleEntity.getId(), false);
                logger.error("获取结算单据id-{}对应附件信息失败, {}", settleEntity.getId(), fileResp.getMsg());
                return false;
            }

        } catch (Exception e) {
            this.executeUpdate(settleEntity.getId(), false);
            logger.error("推送结算单据id-{}给供方id-{} 异常，", settleEntity.getId(), settleEntity.getSupplierId(), e);
            return false;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

    }

    /**
     * 更新单据推送状态
     *
     * @param id   单据id
     * @param flag 是否成功推送
     */
    private void executeUpdate(Long id, Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<SettleEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("bill_push_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }

    @Override
    public void executeUpdatePool(Long id, Boolean flag) {
        // 更新协同推送状态
        UpdateWrapper<SettleEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", id);
        // 修改推送状态
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set("push_pool_flag", BillPushStatusEnum.推送成功.getStatus());
        } else {
            updateWrapper.set("push_pool_flag", BillPushStatusEnum.未成功推送.getStatus());
        }
        super.update(updateWrapper);
    }

    /**
     * 同步单据供供应商签字信息
     *
     * @param request 请求对象
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        SettleEntity settleEntity = super.selectById(billId);
        //设置供方签字信息
        settleEntity.setSupOperateTime(supOperateTime);
        settleEntity.setSupOperatorName(supOperatorName);
        settleEntity.setSupOperatorPhone(supOperatorPhone);
        settleEntity.setSupOperatorUserCode(supOperatorUserCode);

        // 三种结算单据类型
        String billType = null;

        // 结算类型：0-过程，1-完工，2-节点
        if (settleEntity.getSettleType() == 0) {
            billType = processBillType;
        } else if (settleEntity.getSettleType() == 1) {
            billType = finishBillType;
        } else if (settleEntity.getSettleType() == 2) {
            billType = nodeBillType;
        }

        String key = billType + "::" + settleEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", settleEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, billType, authority, settleEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            settleEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字
            settleEntity.setSupplierSignStatus(SupplierSignStatusEnum.乙方已签字.getCode());

            //更新单据
            super.saveOrUpdate(settleEntity, false);

            //向单据制单人和经办人推送该消息
            String msgSendResult = sendMsg(settleEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
            if (null != msgSendResult) {
                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
                        settleEntity.getId(), msgSendResult);
            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", settleEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }


    /**
     * 通知用户消息
     *
     * @param settleEntity
     */
    private String sendMsg(SettleEntity settleEntity, String subject, String content) {

        String[] msgRecUserIds = new String[]{settleEntity.getCreateUserId().toString(), settleEntity.getEmployeeId().toString()};

        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(settleEntity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    /**
     * 将推送至供方的单据作废
     *
     * @param settleEntity 结算主实体
     * @param billTypeCode 待作废单据的单据类型编码
     * @return 推送结果
     */
    @Override
    public boolean delPushBill(SettleEntity settleEntity, String billTypeCode) {
        boolean locked = false, delSuc = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + settleEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (ejcCloudSystemCode.isSuccess()) {
            logger.error("推送结算单据-{}失败，获取当前系统编码失败,{}", settleEntity.getId(), ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        settleEntity.setSourceSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if (!locked) {
                logger.error("结算单据id-{}作废失败，单据锁获取失败！", settleEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("sourceId", settleEntity.getId().toString());
            paramMap.put("sourceSystemId", settleEntity.getSourceSystemId());

            logger.info("结算单据id-{}弃审，通知供方-{}单据作废!", settleEntity.getId(), settleEntity.getSupplierId());

            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DEL_SUP_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    settleEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    delSuc = true;
                } else {
                    logger.error("供方-{}处理作废结算单据id-{}作废失败, {}", settleEntity.getSupplierId(), settleEntity.getId(), supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", settleEntity.getSupplierId(), settleEntity.getId(), syncReqResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", settleEntity.getId(), e);
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return delSuc;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public String delCheck(List<Long> billIds) {
        //查看是否存在非自由态或驳回态单据
        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.in("id", billIds);
        query.in("bill_state", new Integer[]{
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(),
        });

        List<SettleEntity> list = super.list(query);
        if (CollectionUtils.isNotEmpty(list)) {
            return "非自由态或驳回态的单据不能删除！";
        }

        return null;
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleRecordVO settleRecordVO = new SettleRecordVO();

        ContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());

        QueryWrapper<SettleEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.eq("settle_type", settleType);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("create_time");

        List<SettleEntity> list = super.list(listQuery);
        settleRecordVO.setSettleList(BeanMapper.mapList(list, SettleVO.class));

        SettleEntity lastSettleRecord = CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
        switch (settleType) {
            case 0:
                //过程结算
                //累计结算金额取所有节点结算的结算金额的总值
                BigDecimal TotalProcessSettleMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(list)){
                    TotalProcessSettleMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                settleRecordVO.setTotalProcessSettleMny(TotalProcessSettleMny);
                if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
                    settleRecordVO.setSettleRatio(BigDecimal.ZERO);
                } else {
                    settleRecordVO.setSettleRatio((settleRecordVO.getTotalProcessSettleMny().multiply(BigDecimal.valueOf(100))).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
                }
                break;
            case 1:
                //完工结算
                settleRecordVO.setContractSettleMny(null != lastSettleRecord && null != lastSettleRecord.getTaxMny() ? lastSettleRecord.getTaxMny() : BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
                    settleRecordVO.setSettleRatio(BigDecimal.ZERO);
                } else {
                    settleRecordVO.setSettleRatio((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100))).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
                }
                break;
            default:
                //节点结算
                //先做过程结算再做节点结算累计过程结算金额会没有数据，所以需要再次查询过程结算的数据
                QueryWrapper<SettleEntity> processListQuery = new QueryWrapper<>();
                processListQuery.eq("contract_id", contractId);
                processListQuery.eq("settle_type", 0);
                processListQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
                processListQuery.orderByDesc("create_time");
                List<SettleEntity> processList = super.list(processListQuery);
                SettleEntity processLastSettleRecord = CollectionUtils.isNotEmpty(processList) ? processList.get(0) : null;

                settleRecordVO.setTotalProcessSettleMny(null != processLastSettleRecord && null != processLastSettleRecord.getTotalTaxMny() ? processLastSettleRecord.getTotalTaxMny() : BigDecimal.ZERO);
                //累计结算金额取所有节点结算的结算金额的总值
                BigDecimal TotalNodeSettleMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(list)){
                    TotalNodeSettleMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                settleRecordVO.setTotalNodeSettleMny(TotalNodeSettleMny);
                if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
                    settleRecordVO.setSettleRatio(BigDecimal.ZERO);
                } else {
                    settleRecordVO.setSettleRatio((settleRecordVO.getTotalNodeSettleMny().multiply(BigDecimal.valueOf(100))).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
                }
                settleRecordVO.setSettleBalanceMny(settleRecordVO.getTotalNodeSettleMny().subtract(settleRecordVO.getTotalProcessSettleMny()));
        }

        //检测是否可以创建新的结算单
        Boolean contractFilingFlag = contractService.checkFilingType(contractId, ContractFilingTypeEnum.分包合同月度结算.getTypeCode());
        if (StringUtils.isBlank(beforeNewSettleCheck(contractId, settleType)) && contractFilingFlag){
            settleRecordVO.setCanAddNewSettleFlag(true);
        }else {
            settleRecordVO.setCanAddNewSettleFlag(false);
        }
        return settleRecordVO;
    }

    /**
     * 校验逻辑
     * <p>
     * 节点结算：
     * 2）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的节点结算单据）
     * 3）判断是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行节点结算
     * <p>
     * 过程结算：
     * 1）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行过程结算（一个合同只可以有一个未生效的过程结算单据）
     * 2）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行过程结算
     * <p>
     * 完工结算：
     * 1）是否有出库单没有进行领料结算，如果有，不可以进行完工结算
     * 2）是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
     * 3）判断是否有未生效的过程结算、节点结算单子，如果有不可以进行完工结算（一个合同只可以有一个未生效的过程结算单据）
     * 4）是否有完工结算单据，不管有生效还是未生效的，只要产生，都不可以进行完工结算
     *
     * @param contractId
     * @param settleType
     * @return
     */
    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper<SettleEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractId);
        query.and(q -> q.in("settle_type", SettleTypeEnum.节点.getCode(), SettleTypeEnum.过程.getCode())
                .in("bill_state", BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
        ).or().and(q -> q.eq("settle_type", SettleTypeEnum.完工));

        List<SettleEntity> billList = super.list(query);
        if (CollectionUtils.isNotEmpty(billList)) {
            if (SettleTypeEnum.完工.getCode().equals(settleType)) {
                return "合同已经生成了完工结算，不可以进行 " + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            } else {
                return "有未生效的过" + SettleTypeEnum.getDescriptionByCode(SettleTypeEnum.节点.getCode()) + "算单据，不可以进行" + SettleTypeEnum.getDescriptionByCode(settleType) + "结算";
            }
        }

        if (SettleTypeEnum.完工.getCode().equals(settleType)) {
            //TODO 1、是否有出库单没有进行领料结算，如果有，不可以进行完工结算

            //2、是否有未生效的分包计量、领料结算、零工登记、奖罚单的单据，如果有，不可以进行完工结算
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
            queryParam.getParams().put("bill_state", new Parameter(QueryParam.EQ, BillStateEnum.APPROVING_HAS_STATE));
            //分包计量
            List<MeasureEntity> measureEntityList = measureService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(measureEntityList)) {
                sp.append("分包计量、");
            }
            //领料结算
            List<PicKingEntity> picKingEntityList = pickingService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(picKingEntityList)) {
                sp.append("领料结算、");
            }
            //零工登记
            List<RegistrationEntity> registrationEntityList = oddjobService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(registrationEntityList)) {
                sp.append("零工登记、");
            }
            //奖罚扣款单
            List<DeductionEntity> deductionEntityList = deductService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty(deductionEntityList)) {
                sp.append("奖罚扣款、");
            }
            if (sp.length() > 0) {
                return "合同下有未生效的" + sp.substring(0, sp.length() - 1) + "单据，不可以进行完工结算！";
            }

            QueryWrapper<ContractEntity> contractQuery = new QueryWrapper<>();
            contractQuery.eq("contract_id", contractId);
            ContractEntity contractEntity = contractService.selectById(contractId);
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper<ChangeEntity> changeContractLambda = new LambdaQueryWrapper<>();
                changeContractLambda.eq(ChangeEntity::getId, contractEntity.getChangeId());
                changeContractLambda.and(c -> c.in(ChangeEntity::getBillState, BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
                int changeResultCount = changeService.count(changeContractLambda);
                if (changeResultCount > 0) {
                    return "当前合同正在进行变更，不可以进行完工结算！";
                }
            }
        }

        return null;
    }

    @Override
    public SettleVO queryTotalNodeAndFin(Long contractId, Long projectId) {
//        查询 当前合同下的 节点结算的 结算金额 总和 完工结算的
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("project_id", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("settle_type", new Parameter(QueryParam.IN, ("0,2")));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, ("1,3")));
        List<SettleEntity> settleEntities = super.queryList(queryParam, false);
        BigDecimal totalMny = BigDecimal.ZERO;
        for (SettleEntity entity : settleEntities) {
            totalMny = totalMny.add(entity.getTaxMny());
        }
        SettleVO settleVO = new SettleVO();
        settleVO.setMny(totalMny);
        return settleVO;
    }

    //推送至结算池
    @Override
    public String pushSettleToPool(SettleVO s) {
        SettlePoolVO spv = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            // 对象自动转换
            BeanConvertorUtil.convert(s, spv);
            logger.info("结算单对象 s->{}", JSONObject.toJSONString(s));
            logger.info("结算池对象 spv->{}", JSONObject.toJSONString(spv));
            spv.setTotalSettlePaymentTaxMny(s.getTotalSettlePaymentTaxMny());
            spv.setTotalSettlePaymentMny(s.getTotalSettlePaymentMny());
            logger.info("结算池对象-累计结算支付金额{}", spv.getTotalSettlePaymentMny());
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(s, spv);
            //设置 结算单详情地址
            //判断是劳务 还是 分包合同
            String settleType = "";
            String contractType = "";
            if (SettleTypeEnum.过程.getCode().equals(s.getSettleType())) {
                settleType = "processSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.非最终结算.getCode());
            } else if (SettleTypeEnum.完工.getCode().equals(s.getSettleType())) {
                settleType = "finishSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.最终结算.getCode());
                spv.setFinishCurTaxMny(s.getTaxMny());
                spv.setFinishCurMny(s.getMny());
                spv.setCurTax(s.getTax());

                // 差额取值方式参数
                CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(FINISH_SETTLE_DIFFERENCE_CONFIG);
                if (!response.isSuccess() || response.getData() == null) {
                    throw new BusinessException("获取完工单差额取值方式系统参数请求失败，失败原因：" + response.getMsg());
                }
                String valueData = response.getData().getValueData();
                if("1".equals(valueData)) {
                    //使用过程结算取差额
                    spv.setCurTaxMny(s.getTotalProcessTaxDifference());
                    spv.setCurMny(s.getTotalProcessDifference());
                    spv.setCurTax(s.getTotalProcessTaxDifference().subtract(s.getTotalProcessDifference()));
                    spv.setResidueApplyMny(s.getTotalProcessTaxDifference());

                } else {
                    //使用节点结算取差额
                    spv.setCurTaxMny(s.getTotalNodeTaxDifference());
                    spv.setCurMny(s.getTotalNodeDifference());
                    spv.setCurTax(s.getTotalNodeTaxDifference().subtract(s.getTotalNodeDifference()));
                    spv.setResidueApplyMny(s.getTotalNodeTaxDifference());
                }

            } else if (SettleTypeEnum.节点.getCode().equals(s.getSettleType())) {
                settleType = "nodeSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.非最终结算.getCode());
            }
            if (s.getContractType() == 0) {
                //劳务
                contractType = "laborsub";
                if(StringUtils.isBlank(spv.getContractType())) {
                    spv.setContractType(ContractTypeEnum.劳务分包合同.getTypeCode());
                    spv.setContractTypeName(ContractTypeEnum.劳务分包合同.getTypeName());
                }
            } else if (s.getContractType() == 1) {
                //专业
                contractType = "prosub";
                if(StringUtils.isBlank(spv.getContractType())) {
                    spv.setContractType(ContractTypeEnum.专业分包合同.getTypeCode());
                    spv.setContractTypeName(ContractTypeEnum.专业分包合同.getTypeName());
                }
            } else {
                logger.info("结算单合同类型未知结算单id-{}", s.getId());
            }
            spv.setBillCodeUrl("/ejc-prosub-frontend/#/" + settleType + "/" + contractType + "/card?id=" + s.getId());
            spv.setContractFlag(ContractFlagEnum.有合同结算.getContractFlagCode());
            spv.setContractFlagName(ContractFlagEnum.有合同结算.getContractFlagCodeName());
            spv.setHandleType(0); //业务系统推送结算池
            fillOtherSettlePoolAttr(BeanMapper.map(s, SettleEntity.class), spv);

            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                this.executeUpdatePool(s.getId(), true);
                logger.info("结算单推送至结算池成功！结算单id-{}", s.getId());
                logger.info("结算单推送至结算池成功！结算池对象-{}", JSONObject.toJSONString(spv));
                return null;
            } else {
                this.executeUpdatePool(s.getId(), false);
                logger.error("结算单推送结算池失败！结算单id-{}，{}", s.getId(), JSONObject.toJSONString(res));
                return StringUtils.isNotBlank(res.getMsg()) ? res.getMsg() : "网络问题，结算池失败！";
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", s.getId(), e);
            return "结算单推送结算池失败";
        }
    }

    // 从结算池中删除数据
    @Override
    public String delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);

        CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            logger.info("将结算单从结算池中删除成功！结算单id-{}", id);
            return null;
        }

        logger.error("将结算单从结算池中删除失败！结算单id-{}，{}", id, res.getMsg());
        return StringUtils.isNotBlank(res.getMsg()) ? res.getMsg() : "网络问题，单据处理失败！";
    }

    // 将settleVO转换成settlePoolVO
    @Override
    public void convertSettleVOToSettlePoolVO(SettleVO s, SettlePoolVO spv) {
        if (null == s || null == spv) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");

        // 合同类型：0劳务合同，1专业合同
        Integer contractType = s.getContractType();
        // 结算类型：0-过程（月度），1-完工，2-节点
        Integer settleType = s.getSettleType();
        BigDecimal lastTaxMny = BigDecimal.ZERO;
        BigDecimal lastMny = BigDecimal.ZERO;
        switch (settleType) {
            // 结算类型：0-过程（月度）    区分是否含本期
            case 0:
                lastTaxMny = s.getLastTaxMny();// 不含本期累计过程结算金额
                lastMny = s.getLastMny();// 不含本期累计过程结算金额(无税)
                spv.setSourceType(contractType == 0 ? SettleSourceTypeEnum.劳务分包月度结算.getCode() : SettleSourceTypeEnum.专业分包月度结算.getCode());
                spv.setSettleProperty(0);// 属性类型：支出
                spv.setUltimateFlag(0);// 是否最终结算：否
                break;

            // 结算类型：1-完工（最终）    对于最终结算来说不区分是否含本期
            case 1:
                lastTaxMny = s.getTotalProcessTaxMny();// 完工用累计过程结算金额
                lastMny = s.getTotalProcessMny();// 完工用累计过程结算金额（无税）
                spv.setSourceType(contractType == 0 ? SettleSourceTypeEnum.劳务分包最终结算.getCode() : SettleSourceTypeEnum.专业分包最终结算.getCode());
                spv.setSettleProperty(0);// 属性类型：支出
                spv.setUltimateFlag(1);// 是否最终结算：是
                break;

            // 结算类型：2-节点    区分是否含本期
            case 2:
                lastTaxMny = s.getLastNodeTaxMny();// 不含本期累计节点结算金额
                lastMny = s.getLastNodeMny();// 不含本期累计节点结算金额(无税)
                spv.setSourceType(contractType == 0 ? SettleSourceTypeEnum.劳务分包节点结算.getCode() : SettleSourceTypeEnum.专业分包节点结算.getCode());
                spv.setSettleProperty(0);// 属性类型：支出
                spv.setUltimateFlag(0);// 是否最终结算：否
                break;
            default:
                break;
        }
        spv.setLastTaxMny(lastTaxMny);// 累计结算金额（含税）
        spv.setLastMny(lastMny);// 累计结算金额（无税）
        spv.setLastTax(getSubStractAbs(lastTaxMny, lastMny));// 累计结算税额
        spv.setContractType(contractType == 0 ? "laborSub" : "proSub");

        // 主合同ID/名称/编码  甲方ID/名称   签订日期需要到合同中去查询
        ContractEntity ce = contractService.selectById(s.getContractId());
        logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}", s.getContractId());
        if (ce == null) {
            logger.info("结算单推送至结算池过程中，根据合同id查询合同，合同id-{}，未查询到合同信息，故结算单的 主合同/甲方/乙方/签订日期/创建时间和人员/更新时间和人员 等信息无法推送至结算池", s.getContractId());
            return;
        }
        // 主合同
        spv.setMaiContractId(ce.getMainContractId());
        spv.setMaiContractName(ce.getMainContractName());
        spv.setMaiContractCode(ce.getMainContractCode());
        // 甲方
        spv.setPartyaId(ce.getFirstPartyId());
        spv.setPartyaName(ce.getFirstPartyName());
        // 签订日期
        spv.setSignDate(ce.getSignDate());

        // 创建时间和人员 使用 结算单的创建时间和人员
        spv.setCreateTime(s.getCreateTime());
        spv.setCreateUserCode(s.getCreateUserCode());
        // 更新时间和人员 使用 结算单的更新时间和人员
        spv.setUpdateTime(s.getUpdateTime());
        spv.setUpdateUserCode(s.getUpdateUserCode());
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }

    /**
     * 计算差值
     *
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }


    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        if (contractType == 0) {
            totalVO.setBillType("BT220114000000004");
            totalVO.setBussinessType(BussinessTypeEnum.劳务分包合同.getCode());
        } else {
            totalVO.setBillType("BT220307000000009");
            totalVO.setBussinessType(BussinessTypeEnum.专业分包合同.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        if (contractVO.getProjectId() == null) {
            throw new BusinessException("目标成本推送失败,请更换项目");
        } else {
            totalVO.setProjectId(contractVO.getProjectId());
        }
        if (contractVO.getOrgId() == null) {
            throw new BusinessException("目标成本推送失败,请更换项目");
        } else {
            totalVO.setOrgId(contractVO.getOrgId());
        }

        totalVO.setMoney(contractVO.getContractMny()); //总计划金额无税
        totalVO.setTaxMoney(contractVO.getContractTaxMny()); //总计划金额
        totalVO.setLinkUrl(linkUrl);
        if (contractVO.getDetailList() != null) {
            for (ContractDetailVO contractDetailVO : contractVO.getDetailList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(contractDetailVO.getId());
                detailExecutionVO.setSourceBillId(contractDetailVO.getContractId());
                detailExecutionVO.setCategoryId(contractDetailVO.getSourceId()); // 档案ID
                //判断是否是分类
                if (contractDetailVO.getDocCategoryId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                } else {
                    detailExecutionVO.setCategoryFlag(false);
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                TemplateCategoryVO categoryVO = templateCategoryApi.queryTmplCategoryById(contractDetailVO.getDocCategoryId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocId(contractDetailVO.getSourceId() == null ? 1439116437228298666L : contractDetailVO.getSourceId());
                if (contractType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.劳务分包档案.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.专业分包档案.getCode());
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setName(contractDetailVO.getDetailName());
                detailExecutionVO.setUnitName(contractDetailVO.getDetailUnit());
                detailExecutionVO.setNum(contractDetailVO.getDetailNum());
                detailExecutionVO.setMoney(contractDetailVO.getDetailMny());
                detailExecutionVO.setTaxMoney(contractDetailVO.getDetailTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;

    }

    /**
     * 获取含本期累计结算金额
     *
     * @param contractId 合同id
     * @param settleType 结算类型
     * @param taxMny     本期结算金额
     * @param flag       查看预警标识
     * @return 含本期累计结算金额
     */
    @Override
    public BigDecimal getLastTaxMny(Long contractId, Integer settleType, BigDecimal taxMny, Boolean flag) {
        Assert.notNull(contractId, "合同id不能为空");
        Assert.notNull(settleType, "结算类型不能为空");
        Assert.notNull(taxMny, "本期结算金额不能为空");

        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());

        QueryWrapper<SettleEntity> qw = new QueryWrapper<>();
        qw.eq("contract_id", contractId);
        qw.eq("settle_type", settleType);
        qw.in("bill_state", billState);
        List<SettleEntity> settles = super.list(qw);

        if (CollectionUtils.isEmpty(settles)) {
            return taxMny;
        }

        // 查看预警标识
        if (Boolean.TRUE.equals(flag)) {
            taxMny = BigDecimal.ZERO;
        }
        return settles.stream().map(SettleEntity::getTaxMny).reduce(taxMny, BigDecimal::add);
    }

    /**
     * 获取超结金额
     *
     * @param totalTaxMny    含本期累计结算金额
     * @param contractTaxMny 合同金额
     * @return 超结金额
     */
    @Override
    public BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny) {
        // 判空断言
        Assert.notNull(totalTaxMny, "含本期累计结算金额不能为空");
        Assert.notNull(contractTaxMny, "合同金额不能为空");

        return totalTaxMny.subtract(contractTaxMny);
    }

    /**
     * 计算合同金额
     *
     * @param contractTaxMny 合同金额
     * @param roleValue      控制规则值
     * @return 合同金额
     */
    @Override
    public BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue) {
        // 判空断言
        Assert.notNull(contractTaxMny, "合同金额不能为空");
        Assert.notNull(roleValue, "控制规则值不能为空");

        return contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100), 2, RoundingMode.HALF_UP));
    }

    /**
     * 是否可以关联实际成本
     * @param settleEntity 结算实体
     * @return
     */
    private String associatedFlag(SettleEntity settleEntity){
        List<SettleDetailEntity> detailList = settleEntity.getSettleDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getSettleOtherList();
        List<SettleOddjobEntity> oddjobList = settleEntity.getSettleOddjobList();
        List<SettlePickingEntity> pickingList = settleEntity.getSettlePickingList();
        List<SettleDeductEntity> deductList = settleEntity.getSettleDeductList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(detailList)){
            for (SettleDetailEntity detailEntity:detailList){
                if (detailEntity.getSettleNum()!=null){
                    if (null==detailEntity.getDetailWbsId()||null==detailEntity.getDetailSubjectId()){
                        newRelationFlag = "0";
                        break;
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)){
            for (SettleOtherEntity otherEntity:otherList){
                if (null==otherEntity.getOtherWbsId()||null==otherEntity.getOtherSubjectId()){
                        newRelationFlag = "0";
                        break;
                    }

            }
        }
        if (CollectionUtils.isNotEmpty(oddjobList)){
            for (SettleOddjobEntity oddjobEntity:oddjobList){
                if (null==oddjobEntity.getOddjobWbsId()||null==oddjobEntity.getOddjobSubjectId()){
                    newRelationFlag ="0";
                    break;
                }

            }
        }
        if (CollectionUtils.isNotEmpty(pickingList)){
            for (SettlePickingEntity pickingEntity:pickingList){
                if (null==pickingEntity.getPickingWbsId()||null==pickingEntity.getPickingSubjectId()){
                    newRelationFlag = "0";
                    break;
                }

            }
        }
        if (CollectionUtils.isNotEmpty(deductList)){
            for (SettleDeductEntity deductEntity:deductList){
                if (deductEntity.getInputCostFlag()==0){
                    if (null==deductEntity.getDeductWbsId()||null==deductEntity.getDeductSubjectId()){
                        newRelationFlag = "0";
                        break;
                    }
                }
            }
        }
//        if (CollectionUtils.isEmpty(deductList)
//                &&CollectionUtils.isEmpty(pickingList)
//                &&CollectionUtils.isEmpty(oddjobList)
//                &&CollectionUtils.isEmpty(otherList)
//                &&CollectionUtils.isEmpty(detailList)
//        ){
//            newRelationFlag = "0";
//        }
        return newRelationFlag;
    }
    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity settleEntity = baseMapper.selectById(settleVO.getId());
        if (CollectionUtils.isNotEmpty(settleVO.getSettleDetailList())) {
            List<SettleDetailEntity> detailEntityList = BeanMapper.mapList(settleVO.getSettleDetailList(), SettleDetailEntity.class);
            settleEntity.setSettleDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getSettleDeductList())) {
            List<SettleDeductEntity> deductEntities = BeanMapper.mapList(settleVO.getSettleDeductList(), SettleDeductEntity.class);
            settleEntity.setSettleDeductList(deductEntities);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getSettleOddjobList())) {
            List<SettleOddjobEntity> oddjobEntities = BeanMapper.mapList(settleVO.getSettleOddjobList(), SettleOddjobEntity.class);
            settleEntity.setSettleOddjobList(oddjobEntities);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getSettleOtherList())) {
            List<SettleOtherEntity> otherEntities = BeanMapper.mapList(settleVO.getSettleOtherList(), SettleOtherEntity.class);
            settleEntity.setSettleOtherList(otherEntities);
        }
        if (CollectionUtils.isNotEmpty(settleVO.getSettlePickingList())) {
            List<SettlePickingEntity> pickingEntities = BeanMapper.mapList(settleVO.getSettlePickingList(), SettlePickingEntity.class);
            settleEntity.setSettlePickingList(pickingEntities);
        }
        super.saveOrUpdate(settleEntity, false);
        //推送数据
        costPush(settleEntity);
        return CommonResponse.success(BeanMapper.map(settleEntity, SettleVO.class));
    }

    //查询 未关联的成本
    public List<Long> autoPushCost(List<Long> ids){
//        List<Long> ids = settleMapper.queryCanCostPush();
        for (Long id:ids){
            SettleEntity settleEntity = baseMapper.selectById(id);
            if (settleEntity!=null){
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("settle_id",new Parameter(QueryParam.EQ,settleEntity.getId()));
                BigDecimal detailTaxMny = BigDecimal.ZERO;
                BigDecimal   detailMny = BigDecimal.ZERO;
                List<SettleDetailEntity> detailList = settleDetailService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(detailList)){
//                    settleEntity.setSettleDetailList(detailList);
                    for (SettleDetailEntity detail:detailList){
                        if (detail.getSettleNum()!=null){
                            if(Integer.valueOf("1").equals(settleEntity.getSettleType())) {
                                //完工结算
                                detailTaxMny = detailTaxMny.add(detail.getProcessTaxDifference()==null ? BigDecimal.ZERO : detail.getProcessTaxDifference());
                                detailMny = detailMny.add(detail.getProcessDifference()==null ? BigDecimal.ZERO : detail.getProcessDifference());
                            } else {
                                detailTaxMny = detailTaxMny.add(detail.getSettleTaxMny()==null ? BigDecimal.ZERO : detail.getSettleTaxMny());
                                detailMny = detailMny.add(detail.getSettleMny()==null ? BigDecimal.ZERO : detail.getSettleMny());
                            }

                        }
                    }
//
                }
                List<SettleOddjobEntity> settleOddjobEntities = settleOddjobService.queryList(queryParam);
                BigDecimal  oddjobTaxMny = BigDecimal.ZERO;
                BigDecimal oddjobMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(settleOddjobEntities)){
//                    settleEntity.setSettleOddjobList(settleOddjobEntities);
                    for (SettleOddjobEntity detail:settleOddjobEntities){
                        if (detail.getOddjobType()==0){
                            oddjobTaxMny = oddjobTaxMny.add(detail.getOddjobTaxMny()==null?BigDecimal.ZERO:detail.getOddjobTaxMny());
                            oddjobMny = oddjobMny.add(detail.getOddjobMny()==null?BigDecimal.ZERO:detail.getOddjobMny());
                        }else {
                            oddjobTaxMny = oddjobTaxMny.subtract(detail.getOddjobTaxMny()==null?BigDecimal.ZERO:detail.getOddjobTaxMny());
                            oddjobMny = oddjobMny.subtract(detail.getOddjobMny()==null?BigDecimal.ZERO:detail.getOddjobMny());
                        }
                    }
                }
                List<SettleOtherEntity> settleOtherEntities = settleOtherService.queryList(queryParam);
                BigDecimal otherTaxMny = BigDecimal.ZERO;
                BigDecimal otherMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(settleOtherEntities)){
                    for (SettleOtherEntity other:settleOtherEntities){
                        otherTaxMny = otherTaxMny.add(other.getTaxMny()==null?BigDecimal.ZERO:other.getTaxMny());
                        otherMny = otherMny.add(other.getMny()==null?BigDecimal.ZERO:other.getMny());

                    }
                }
                List<SettlePickingEntity> settlePickingEntities = settlePickingService.queryList(queryParam);
                BigDecimal  pickingTaxMny = BigDecimal.ZERO;
                BigDecimal pickingMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(settlePickingEntities)){
                    for (SettlePickingEntity pick:settlePickingEntities){
                        pickingTaxMny = pickingTaxMny.add(pick.getCostTaxMny()==null?BigDecimal.ZERO:pick.getCostTaxMny());
                        pickingMny = pickingMny.add(pick.getCostMny()==null?BigDecimal.ZERO:pick.getCostMny());
                    }
                }

                List<SettleDeductEntity> settleDeductEntities = settleDeductService.queryList(queryParam);
                BigDecimal deductTaxMny = BigDecimal.ZERO;
                BigDecimal  deductMny = BigDecimal.ZERO;

                if (CollectionUtils.isNotEmpty(settleDeductEntities)){
                    for (SettleDeductEntity deduct:settleDeductEntities){
                        if (deduct.getInputCostFlag()==0) {
                            deductTaxMny = deductTaxMny.add(deduct.getDeductTaxMny()==null?BigDecimal.ZERO:deduct.getDeductTaxMny());
                            deductMny = deductMny.add(deduct.getDeductMny()==null?BigDecimal.ZERO:deduct.getDeductMny());
                        }
                    }
                }
                BigDecimal costTaxMny = BigDecimal.ZERO;
                BigDecimal  costMny = BigDecimal.ZERO;
                BigDecimal  costTax = BigDecimal.ZERO;

                costTaxMny = costTaxMny.add(detailTaxMny);
                costTaxMny = costTaxMny.add(otherTaxMny);
                costTaxMny = costTaxMny.add(oddjobTaxMny);
                costTaxMny = costTaxMny.add(pickingTaxMny);
                costTaxMny = costTaxMny.add(deductTaxMny);
                costMny = costMny.add(detailMny);
                costMny = costMny.add(otherMny);
                costMny = costMny.add(oddjobMny);
                costMny = costMny.add(pickingMny);
                costMny = costMny.add(deductMny);
                costTax = costTaxMny.subtract(costMny);
                settleEntity.setPushCostMny(costMny);
                settleEntity.setPushCostTaxMny(costTaxMny);
                settleEntity.setPushCostTax(costTax);

                //实际成本 推送
                saveCost(settleEntity, 1);

                super.saveOrUpdate(settleEntity);
            }

        }
        return  ids;
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        logger.info("开始costPush");
        String newRelationFlag = associatedFlag(settleEntity);
        logger.info("newRelationFlag---{}",newRelationFlag);
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        saveCost(settleEntity, 1);

        //判断之前的单据是否关联
//        String oldRelationFlag = settleEntity.getRelationFlag();
//        if ("1".equals(oldRelationFlag)) {
//            if ("1".equals(newRelationFlag)) {
//                saveCost(settleEntity);
//            }
//            if (!"1".equals(newRelationFlag)) {
//                //删除成本中心之前的数据
//                logger.info("删除成本中心之前的数据-领料出库Id---{}",settleEntity.getId());
//                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(settleEntity.getId());
//                logger.info("结果"+JSONObject.toJSONString(commonResponse));
//                if(!commonResponse.isSuccess()){
//                    throw new BusinessException(commonResponse.getMsg());
//                }
//            }
//        }
//        //之前未关联
//        if ("0".equals(oldRelationFlag)) {
//            if ("1".equals(newRelationFlag)) {
//                //税率
//               boolean b = saveCost(settleEntity);
//                if (!b){
//                    throw new BusinessException("网络错误 推送实际成本失败");
//                }
//            }
//        }
    }

    @Override
    public void costDeletePush(SettleEntity settleEntity) {
        logger.info("弃审推送成本---");
        logger.info("删除成本中心之前的数据-结算单Id---{}",settleEntity.getId());
        CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(settleEntity.getId(), 0);
        logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
        if(!stringCommonResponse.isSuccess()){
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        //更新是否关联
        LambdaUpdateWrapper<SettleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(SettleEntity::getId, settleEntity.getId());
        updateWrapper.set(SettleEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public boolean saveCost(SettleEntity settleEntity, int effectiveStatus) {
        logger.info("推送结算实体："+JSONObject.toJSONString(settleEntity));
        String sourceType = "";
        String sourceTypeName = "";
        String linkUrl = "";
        if (settleEntity.getContractType()==1){
            //专业合同
            sourceType = "PRO_SETTLE";
            if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                sourceTypeName = SourceTypeEnum.专业分包完工结算.getTypeName();
            }else if(SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                sourceTypeName = SourceTypeEnum.专业分包过程结算.getTypeName();
            }
        }else {
            //劳务合同
            sourceType = "LAP_SETTLE";
            if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                sourceTypeName = SourceTypeEnum.劳务分包完工结算.getTypeName();
            }else if(SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                sourceTypeName = SourceTypeEnum.劳务分包过程结算.getTypeName();
            }
        }

        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<SettleDetailEntity> detailList = settleEntity.getSettleDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getSettleOtherList();
        List<SettleOddjobEntity> oddjobList = settleEntity.getSettleOddjobList();
        List<SettlePickingEntity> pickingList = settleEntity.getSettlePickingList();
        List<SettleDeductEntity> deductList = settleEntity.getSettleDeductList();
        if (CollectionUtils.isNotEmpty(detailList)){
            for (SettleDetailEntity detailEntity:detailList){
                if (detailEntity.getSettleNum()!=null){
                    CostDetailVO costDetailVO = new CostDetailVO();
                    costDetailVO.setSubjectId(detailEntity.getDetailSubjectId());
                    costDetailVO.setSubjectCode(detailEntity.getDetailSubjectCode());
                    costDetailVO.setSubjectName(detailEntity.getDetailSubjectName());
                    costDetailVO.setWbsId(detailEntity.getDetailWbsId());
                    costDetailVO.setWbsCode(detailEntity.getDetailWbsCode());
                    costDetailVO.setWbsName(detailEntity.getDetailWbsName());
                    costDetailVO.setSourceId(detailEntity.getSettleId());
                    costDetailVO.setSourceDetailId(detailEntity.getId());
                    if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                        costDetailVO.setHappenTaxMny(detailEntity.getProcessTaxDifference());
                        costDetailVO.setHappenMny(detailEntity.getProcessDifference());
                        costDetailVO.setSourceTabType("SET_FIN_DETAIL");
                        costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    }
                    if (SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                        costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                        costDetailVO.setHappenMny(detailEntity.getSettleMny());
                        costDetailVO.setSourceTabType("SET_PRO_DETAIL");
                        costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    }
                    costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号
                    costDetailVO.setSourceBillName(sourceTypeName);//填充枚举里  自己的单据名称
                    costDetailVO.setSourceType(sourceType);
                    costDetailVO.setHappenDate(detailEntity.getSettleDate());
                    costDetailVO.setCreateUserName(detailEntity.getCreateUserCode());
                    costDetailVO.setProjectId(settleEntity.getProjectId());
                    costDetailVO.setEffectiveStatus(effectiveStatus);
                    costDetailVOList.add(costDetailVO);
                }

            }
        }
        if (CollectionUtils.isNotEmpty(otherList)){
            for (SettleOtherEntity otherEntity:otherList){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getOtherSubjectId());
                costDetailVO.setSubjectCode(otherEntity.getOtherSubjectCode());
                costDetailVO.setSubjectName(otherEntity.getOtherSubjectName());
                costDetailVO.setWbsId(otherEntity.getOtherWbsId());
                costDetailVO.setWbsCode(otherEntity.getOtherWbsCode());
                costDetailVO.setWbsName(otherEntity.getOtherWbsName());
                costDetailVO.setSourceId(otherEntity.getSettleId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMny());
                costDetailVO.setHappenMny(otherEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getSettleDate());
                costDetailVO.setCreateUserName(otherEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                    costDetailVO.setSourceTabType("SET_PRO_OTHER");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                }
                if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    costDetailVO.setSourceTabType("SET_FIN_OTHER");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号

                costDetailVO.setSourceBillName(sourceTypeName);//填充枚举里  自己的单据名称
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(oddjobList)){
            for (SettleOddjobEntity oddjobEntity:oddjobList){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(oddjobEntity.getOddjobSubjectId());
                costDetailVO.setSubjectCode(oddjobEntity.getOddjobSubjectCode());
                costDetailVO.setSubjectName(oddjobEntity.getOddjobSubjectName());
                costDetailVO.setWbsId(oddjobEntity.getOddjobWbsId());
                costDetailVO.setWbsCode(oddjobEntity.getOddjobWbsCode());
                costDetailVO.setWbsName(oddjobEntity.getOddjobWbsName());
                costDetailVO.setSourceId(oddjobEntity.getSettleId());
                costDetailVO.setSourceDetailId(oddjobEntity.getId());
                if(Integer.valueOf(1).equals(oddjobEntity.getOddjobType())) {
                    //零工转扣按负值处理
                    costDetailVO.setHappenTaxMny(oddjobEntity.getOddjobTaxMny().negate());
                    costDetailVO.setHappenMny(oddjobEntity.getOddjobMny().negate());
                } else {
                    costDetailVO.setHappenTaxMny(oddjobEntity.getOddjobTaxMny());
                    costDetailVO.setHappenMny(oddjobEntity.getOddjobMny());
                }
                costDetailVO.setHappenDate(oddjobEntity.getSettleDate());
                costDetailVO.setCreateUserName(oddjobEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                    costDetailVO.setSourceTabType("SET_PRO_ODDJOB");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                }
                if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    costDetailVO.setSourceTabType("SET_FIN_ODDJOB");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号
                costDetailVO.setSourceBillName(sourceTypeName);//填充枚举里  自己的单据名称
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(pickingList)){
            for (SettlePickingEntity pickingEntity:pickingList){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(pickingEntity.getPickingSubjectId());
                costDetailVO.setSubjectCode(pickingEntity.getPickingSubjectCode());
                costDetailVO.setSubjectName(pickingEntity.getPickingSubjectName());
                costDetailVO.setWbsId(pickingEntity.getPickingWbsId());
                costDetailVO.setWbsCode(pickingEntity.getPickingWbsCode());
                costDetailVO.setWbsName(pickingEntity.getPickingWbsName());
                costDetailVO.setSourceId(pickingEntity.getSettleId());
                costDetailVO.setSourceDetailId(pickingEntity.getId());
                costDetailVO.setHappenTaxMny(pickingEntity.getCostTaxMny().negate());
                costDetailVO.setHappenMny(pickingEntity.getCostMny().negate());
                costDetailVO.setHappenDate(pickingEntity.getSettleDate());
                costDetailVO.setCreateUserName(pickingEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                    costDetailVO.setSourceTabType("SET_PRO_PICKING");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                }
                if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    costDetailVO.setSourceTabType("SET_FIN_PICKING");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号
                costDetailVO.setSourceBillName(sourceTypeName);//填充枚举里  自己的单据名称
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(deductList)){
            for (SettleDeductEntity deductEntity:deductList){
                if (deductEntity.getInputCostFlag()==0){
                    CostDetailVO costDetailVO = new CostDetailVO();
                    costDetailVO.setSubjectId(deductEntity.getDeductSubjectId());
                    costDetailVO.setSubjectCode(deductEntity.getDeductSubjectCode());
                    costDetailVO.setSubjectName(deductEntity.getDeductSubjectName());
                    costDetailVO.setWbsId(deductEntity.getDeductWbsId());
                    costDetailVO.setWbsCode(deductEntity.getDeductWbsCode());
                    costDetailVO.setWbsName(deductEntity.getDeductWbsName());
                    costDetailVO.setSourceId(deductEntity.getSettleId());
                    costDetailVO.setSourceDetailId(deductEntity.getId());

                    costDetailVO.setHappenDate(deductEntity.getHappenDate());
                    costDetailVO.setCreateUserName(deductEntity.getCreateUserCode());
                    costDetailVO.setSourceType(sourceType);
                    if (SettleTypeEnum.过程.getCode().equals(settleEntity.getSettleType())){
                        costDetailVO.setSourceTabType("SET_PRO_DEDUCT");
                        costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                    }
                    if (SettleTypeEnum.完工.getCode().equals(settleEntity.getSettleType())){
                        costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id="+settleEntity.getId());//需要跳转路径与参数组成的全路径
                        costDetailVO.setSourceTabType("SET_FIN_DEDUCT");
                    }
                    costDetailVO.setSourceBillCode(settleEntity.getBillCode()); //填充自己的单据编号
                    BigDecimal happenMny = BigDecimal.ZERO;
                    BigDecimal happenTaxMny= BigDecimal.ZERO;
//                    奖励-0、扣款-1、罚款-2 奖励：正  ； 扣款、罚款：负
                    if (deductEntity.getRewardDeductionType()==0){
                        happenMny = deductEntity.getDeductMny();
                        happenTaxMny = deductEntity.getDeductTaxMny();
                    }else {
                        happenMny = deductEntity.getDeductMny().negate() ;
                        happenTaxMny = deductEntity.getDeductTaxMny().negate();
                    }
                    costDetailVO.setHappenTaxMny(happenTaxMny);
                    costDetailVO.setHappenMny(happenMny);
                    costDetailVO.setSourceBillName(sourceTypeName);//填充枚举里  自己的单据名称
                    costDetailVO.setProjectId(settleEntity.getProjectId());
                    costDetailVO.setEffectiveStatus(effectiveStatus);
                    costDetailVOList.add(costDetailVO);
                }
            }
        }
        //成本中心
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            if (null != settleEntity.getPushCostTaxMny()){
                logger.info("costDetailVOList--->{}", JSONObject.toJSONString(costDetailVOList));
                BigDecimal collectHappenTaxMny = costDetailVOList.stream().map(CostDetailVO::getHappenTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                logger.info("collectHappenTaxMny--->{}", collectHappenTaxMny);
                if (!(settleEntity.getPushCostTaxMny().compareTo(collectHappenTaxMny.subtract(new BigDecimal("0.5"))) >= 0 && settleEntity.getPushCostTaxMny().compareTo(collectHappenTaxMny.add(new BigDecimal("0.5"))) <= 0)){
                    throw new BusinessException("推送实际成本池异常，请联系系统管理员！");
                }
            }

            logger.info("推送数据--------：{}",JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------：{}",JSONObject.toJSONString(stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                logger.error("网络错误 推送实际成本失败 失败信息：{}",JSONObject.toJSONString(stringCommonResponse));
                throw new BusinessException(JSONObject.toJSONString(stringCommonResponse));
            }
        }
        return true;
    }

    @Override
    public void delSettleCostInfo(List<Long> billIds) {
        logger.info("-------- 结算单删除实际成本池数据 start -------- ids:{}", JSONObject.toJSONString(billIds));
        billIds.forEach(settleId -> {
            //删除 实际成本池数据
            CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(settleId);
            logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
            if(!stringCommonResponse.isSuccess()){
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        });
    }

    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"approve"审批通过后，"back"撤回后
    @Override
    public boolean updateContractPoolTotalSettleMnyAfterSettle(SettleEntity se, String type) {
        CommonResponse<ParamRegisterSetVO> subConTotalSettleMnyParamRes = paramConfigApi.getByCode(SUB_CONTRACT_TOTAL_SETTLE_MNY_COUNT_SYS_PARAM);
        logger.info("查询系统参数，获取分包合同累计结算金额计算方式，查询结果：{}", JSONObject.toJSONString(subConTotalSettleMnyParamRes));
        if (!subConTotalSettleMnyParamRes.isSuccess() || subConTotalSettleMnyParamRes.getData() == null) {
            logger.error("查询系统参数，获取分包合同累计结算金额计算方式失败");
            return false;
        }
        ParamRegisterSetVO paramRegisterSetVO = subConTotalSettleMnyParamRes.getData();
        String defaultVal = paramRegisterSetVO.getValueData();
        if (StringUtils.isBlank(defaultVal)) {
            logger.error("查询系统参数，获取分包合同累计结算金额计算方式失败");
            return false;
        }
        Long tenantid = InvocationInfoProxy.getTenantid();// 租户id
        Long seId = se.getId();// 当前结算单id
        Long contractId = se.getContractId();// 合同id
        Integer settleType = se.getSettleType();// 结算单类型
        String settleTypeName = SettleTypeEnum.getDescriptionByCode(settleType).getDescription();// 结算单类型名称
        logger.info("ID为【" + contractId + "】的合同 " + settleTypeName + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, settleType={}, type={}", se, settleTypeName, type);
        // 查询当前合同下的已提交/审批通过后的结算单的本期结算金额（含税、无税、税额）的累加值作为累计结算金额（含税、无税、税额），当当前流程是撤回操作时，查询时排除当前结算单
        QueryWrapper<SettleEntity> seWra = new QueryWrapper<>();
        seWra.eq("dr", 0).eq("tenant_id", tenantid)
                .eq("contract_id", contractId)
                .in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        if ("back".equals(type)) {
            // 当前是撤回操作，查询时排除当前结算单
            seWra.ne("id", seId);
        }
        switch (defaultVal) {
            case "1":
                // 郑州一建使用，取当前合同下所有节点结算单的本期结算金额的汇总 + 完工结算单的节点结算差额
                seWra.select("sum(if(settle_type = 2, ifnull(tax_mny, 0), 0)) as totalSettleTaxMny");           // 本期节点含税
                seWra.select("sum(if(settle_type = 2, ifnull(mny, 0), 0)) as totalSettleMny");                  // 本期节点无税
                seWra.select("sum(if(settle_type = 2, ifnull(tax, 0), 0)) as totalSettleTax");                  // 本期节点无税
                seWra.select("if(settle_type = 1, ifnull(total_node_tax_difference, 0), 0) totalTaxMnyDif");    // 完工节点差额含税
                seWra.select("if(settle_type = 1, ifnull(total_node_difference, 0), 0) totalMnyDif");           // 完工结算差额无税
                break;
            case "2":
                // 云南建投使用，取当前合同下所有月度结算单的本期结算金额的汇总 + 完工结算单的月度结算差额
                seWra.select("sum(if(settle_type = 0, ifnull(tax_mny, 0), 0)) as totalSettleTaxMny");           // 本期月度含税
                seWra.select("sum(if(settle_type = 0, ifnull(mny, 0), 0)) as totalSettleMny");                  // 本期月度无税
                seWra.select("sum(if(settle_type = 0, ifnull(tax, 0), 0)) as totalSettleTax");                  // 本期月度税额
                seWra.select("if(settle_type = 1, ifnull(total_process_tax_difference, 0), 0) totalTaxMnyDif"); // 完工月度差额含税
                seWra.select("if(settle_type = 1, ifnull(total_process_difference, 0), 0) totalMnyDif");        // 完工月度差额无税
                break;
            default:
                // 取当前合同下所有结算单的本期结算金额的汇总
                seWra.select("sum(ifnull(tax_mny, 0)) as totalSettleTaxMny, " +                                 /*本期含税*/
                        "sum(ifnull(mny, 0)) as totalSettleMny, " +                                             /*本期无税*/
                        "sum(ifnull(tax, 0)) as totalSettleTax, " +                                             /*本期税额*/
                        "0 as totalTaxMnyDif, " +                                                               /*假的差额含税*/
                        "0 as totalMnyDif");                                                                    /*假的差额无税*/
                break;
        }
        Map<String, Object> totalSettleMnyMap = super.getMap(seWra);
        logger.info("查询当前合同下的累计结算金额（含税、无税、税额），查询结果：{}", JSONObject.toJSONString(totalSettleMnyMap));
        BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
        BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
        BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
        BigDecimal totalTaxMnyDif = BigDecimal.ZERO;            // 完工差额含税初始化
        BigDecimal totalMnyDif = BigDecimal.ZERO;               // 完工差额无税初始化
        BigDecimal totalTaxDif = BigDecimal.ZERO;               // 完工差额税额初始化
        if (MapUtils.isNotEmpty(totalSettleMnyMap)) {
            // 累计结算金额含税
            totalSettleTaxMny = totalSettleMnyMap.get("totalSettleTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalSettleTaxMny").toString());
            // 累计结算金额无税
            totalSettleMny = totalSettleMnyMap.get("totalSettleMny") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalSettleMny").toString());
            // 累计结算税额
            totalSettleTax = totalSettleMnyMap.get("totalSettleTax") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalSettleTax").toString());

            // 完工差额含税
            totalTaxMnyDif = totalSettleMnyMap.get("totalTaxMnyDif") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalTaxMnyDif").toString());
            // 完工差额无税
            totalMnyDif = totalSettleMnyMap.get("totalMnyDif") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalMnyDif").toString());
            // 完工差额税额
            totalTaxDif = ComputeUtil.safeSub(totalTaxMnyDif, totalMnyDif);
        }

        // 封装
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setSourceId(contractId);
        contractPoolVO.setTotalSettleTaxMny(ComputeUtil.safeAdd(totalSettleTaxMny, totalTaxMnyDif));        // 含税
        contractPoolVO.setTotalSettleMny(ComputeUtil.safeAdd(totalSettleMny, totalMnyDif));                 // 无税
        contractPoolVO.setTotalSettleTax(ComputeUtil.safeAdd(totalSettleTax, totalTaxDif));                 // 税额
        logger.info("ID为【" + contractId + "】的合同 " + settleTypeName + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
        CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
        logger.info("ID为【" + contractId + "】的合同 " + settleTypeName + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        return true;
    }

}





























