package com.ejianc.business.prosub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 分包合同付款阶段实体
 */
@TableName("ejc_prosub_contract_payment")
public class ContractPaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 付款阶段名称
     */
    @TableField("payment_name")
    private String paymentName;

    /**
     * 付款阶段比例(%)
     */
    @TableField("payment_scale")
    private BigDecimal paymentScale;

    /**
     * 备注
     */
    @TableField("mark")
    private String mark;

    /**
     * 所属合同Id
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;


    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    public BigDecimal getPaymentScale() {
        return paymentScale;
    }

    public void setPaymentScale(BigDecimal paymentScale) {
        this.paymentScale = paymentScale;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
}
