package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.prosub.service.IContractDetailService;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.settle.bean.*;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleDetailMapper;
import com.ejianc.business.settle.service.*;
import com.ejianc.business.settle.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springside.modules.nosql.redis.JedisTemplate;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算公用controller
 */
@RestController
@RequestMapping("settle")
public class SettleController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISettleService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleSalaryService salaryService;
    @Autowired
    private ISettleOddjobService oddjobService;
    @Autowired
    private ISettlePickingService pickingService;
    @Autowired
    private ISettleOtherService otherService;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private IShareLabsubApi shareLabsubApi;

    /**
     * 过程结算单据类型编码
     */
    private final String processBillType = "BT220114000000002";
    /**
     * 完工结算单据类型编码
     */
    private final String finishBillType = "BT220114000000004";

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    /**
     * 节点结算单据类型编码
     */
    private final String nodeBillType = "BT220114000000003";
    /**
     * 单据分享移动端前端路由地址
     */
    private final String nodeMobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subNode/card";
    private final String finishMobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subCompletion/card";
    private final String procMobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/subProcess/card";
    @Value("${common.env.base-host}")
    private String BASE_HOST;


    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISettlePriceService settlePriceService;


    @Autowired
    private ISettleDetailService settleDetailService;

    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private SettleDetailMapper settleDetailMapper;

    private final String PUSH_POOL_PREFIX = "pushContractSettle::";

    @Autowired
    private IParamConfigApi paramConfigApi;

    private final String FINISH_SETTLE_DIFFERENCE_CONFIG = "P-2hiWQQ0131";

    /**
     * @param contractId
     * @Description queryUnusedContract 查询合同是否被当前结算类型所使用
     * 完工结算时 判断上游业务：分包计量，领料结算，零工登记，奖罚扣款单；
     * 是否有审批中的单据，如果有不允许进行完工结算
     */
    @RequestMapping(value = "/queryUnusedContract", method = RequestMethod.GET)
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType, Long changeId) {
        return service.queryUnusedContract(contractId, settleDate, settleType, changeId);
    }

    /**
     * @param list
     * @Description queryDetail 查询结算清单累计结算金额
     */
    @RequestMapping(value = "/queryDetailSumMny", method = RequestMethod.POST)
    public CommonResponse<List<SettleDetailVO>> queryDetailSumMny(@RequestBody List<SettleDetailVO> list) {
        List<Long> ids = list.stream().map(SettleDetailVO::getId).collect(Collectors.toList());
        return CommonResponse.success("查询详情数据成功！",  settleDetailMapper.queryDetailSumMny(ids));
    }




    /**
     * @param list
     * @Description queryDetail 查询结算价格调整清单累计结算金额
     */
    @RequestMapping(value = "/queryPriceSumMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SettlePriceVO>> queryPriceSumMny(@RequestBody List<SettlePriceVO> list) {
        List<Long> ids = list.stream().map(SettlePriceVO::getId).collect(Collectors.toList());
        return CommonResponse.success("查询详情数据成功！",  settleDetailMapper.queryPriceSumMny(ids));
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> pushCost(@RequestBody SettleVO saveOrUpdateVO) {
        logger.info(" 手动关联保存接口---{}",JSONObject.toJSONString(saveOrUpdateVO));
        return service.pushCost(saveOrUpdateVO);
    }
    @RequestMapping(value = "/autoPushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Long>> autoPushCost(@RequestBody List<SettleVO> vos) {
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        List<Long> longs = service.autoPushCost(billIds);
        return CommonResponse.success("查询成功",longs);
    }
//    void autoPushCost();
    /**
     * @param settleVO
     * @return
     */
    @RequestMapping(value = "/querySubTableList", method = RequestMethod.POST)
    public CommonResponse<SettleVO> querySubTableList(@RequestBody SettleVO settleVO) {
        if (settleVO.getSettleType() == null || settleVO.getContractId() == null || settleVO.getSettleDate() == null) {
            throw new BusinessException("请检查合同id或结算日期是否为空！");
        }
        SettleEntity entity = service.querySubTableList(settleVO.getSettleType(), settleVO.getContractId(), settleVO.getSettleDate());
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);

        if (SettleTypeEnum.完工.getCode().equals(settleVO.getSettleType())) {
            vo.setSettleDetailList(TreeNodeBUtil.buildTree(vo.getSettleDetailList()));
        } else {
            // 如果不是完工结算，则处理计量单的数据
            // 计量单来源的分包清单生成树形结构
            //查询合同所有明细数据
            List<ContractDetailVO> details = contractDetailService.listByContractId(settleVO.getContractId());
            List<SettleDetailVO> detailList = vo.getSettleDetailList();
            List<SettleDetailVO> mList = null;
            List<SettleDetailVO> detailNumList = new ArrayList<>();
            if (!detailList.isEmpty()) {
                mList = changeToMeasureDetail(details, detailList, "分包计量");
                vo.setSettleDetailList(TreeNodeBUtil.buildTree(mList));
                detailNumList.addAll(detailList);
            }

            //过程结算独有功能
            if (SettleTypeEnum.过程.getCode().equals(settleVO.getSettleType())) {
                List<SettleDetailVO> numList = settleDetailService.addDetail(settleVO.getContractId());
//            logger.info("判断是否有结算单来源的数据长度：" + numList.size());
//            logger.info("判断是否有结算单来源的数据：{}", JSONObject.toJSONString(numList, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
                if (CollectionUtils.isNotEmpty(numList)) {
                    detailNumList.addAll(numList);
                    List<SettleDetailVO> list = changeToMeasureDetail(details, numList, "结算单");
                    vo.getSettleDetailList().addAll(TreeNodeBUtil.buildTree(list));
                }

                //取出所有查出来的清单，任取其中一条数据的上次最大过程结算量 + 多条该清单（contractDetailId一致）的结算量
                //得到的结果再赋值到多条清单中
                if (CollectionUtils.isNotEmpty(detailNumList)) {
                    Map<Long, BigDecimal> countMapByNum = detailNumList.stream().collect(Collectors.groupingBy(SettleDetailVO::getContractDetailId, Collectors.reducing(BigDecimal.ZERO, SettleDetailVO::getSettleNum, BigDecimal::add)));
                    Map<Long, BigDecimal> countMapByProcess = new HashMap<>();
                    for (SettleDetailVO detailVO : detailNumList) {
                        if (!countMapByProcess.containsKey(detailVO.getContractDetailId())) {
                            countMapByProcess.put(detailVO.getContractDetailId(), detailVO.getLastProcessNum());
                        }
                    }
                    detailNumList.stream().forEach(item -> {
                        BigDecimal totalNum = countMapByNum.get(item.getContractDetailId());
                        item.setTotalProcessNum(totalNum.add(countMapByProcess.get(item.getContractDetailId())));
                    });
                }
            }
        }


        // 查询该合同下已生效的结算金额、合同已付金额、合同收票金额
        // 过程结算
        if (Objects.equals(settleVO.getSettleType(), SettleTypeEnum.过程.getCode())) {
            QueryParam param = new QueryParam();
            param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleVO.getContractId()));
            param.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.过程.getCode()));
            List<SettleEntity> settleEntities = service.queryList(param);
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal contractPayMny = BigDecimal.ZERO;
            BigDecimal contractBillTaxMny = BigDecimal.ZERO;
            for (SettleEntity s : settleEntities) {
                lastTaxMny = lastTaxMny.add(s.getTaxMny());
                lastMny = lastMny.add(s.getMny());
                contractPayMny = contractPayMny.add(s.getContractPayMny());
                contractBillTaxMny = contractBillTaxMny.add(s.getContractBillTaxMny());
            }
            vo.setLastTaxMny(lastTaxMny);
            vo.setLastMny(lastMny);
            vo.setContractPayMny(contractPayMny);
            vo.setContractBillTaxMny(contractBillTaxMny);
        }
        // 节点结算或者完工结算（根据合同查询该合同下已生效的节点结算金额、过程结算金额）
        if (Objects.equals(settleVO.getSettleType(), SettleTypeEnum.节点.getCode()) || Objects.equals(settleVO.getSettleType(), SettleTypeEnum.完工.getCode())) {
            BigDecimal lastTaxMny = BigDecimal.ZERO;
            BigDecimal lastMny = BigDecimal.ZERO;
            BigDecimal lastNodeTaxMny = BigDecimal.ZERO;
            BigDecimal lastNodeMny = BigDecimal.ZERO;
            BigDecimal contractPayMny = BigDecimal.ZERO;
            BigDecimal contractBillTaxMny = BigDecimal.ZERO;

            QueryParam param = new QueryParam();
            param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleVO.getContractId()));
            param.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.节点.getCode()));
            List<SettleEntity> settleEntities = service.queryList(param);
            for (SettleEntity s : settleEntities) {
                lastNodeTaxMny = lastNodeTaxMny.add(s.getTaxMny());
                lastNodeMny = lastNodeMny.add(s.getMny());
                contractPayMny = contractPayMny.add(s.getContractPayMny());
                contractBillTaxMny = contractBillTaxMny.add(s.getContractBillTaxMny());
            }

            QueryParam param1 = new QueryParam();
            param1.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleVO.getContractId()));
            param1.getParams().put("settle_type", new Parameter(QueryParam.EQ, SettleTypeEnum.过程.getCode()));
            List<SettleEntity> processSettleEntities = service.queryList(param1);
            for (SettleEntity s : processSettleEntities) {
                lastTaxMny = lastTaxMny.add(s.getTaxMny());
                lastMny = lastMny.add(s.getMny());
            }

            vo.setLastTaxMny(lastTaxMny);
            vo.setLastMny(lastMny);
            vo.setLastNodeTaxMny(lastNodeTaxMny);
            vo.setLastNodeMny(lastNodeMny);
            vo.setContractPayMny(contractPayMny);
            vo.setContractBillTaxMny(contractBillTaxMny);
        }

        if (SettleTypeEnum.节点.getCode().equals(settleVO.getSettleType())){
            int settleTimes = service.queryContractSettleNumOfNode(settleVO.getContractId());
            vo.setSettleTimes(settleTimes + 1);
        }else {
            //设置结算次数
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, settleVO.getContractId()));
            queryParam.getParams().put("settle_type", new Parameter(QueryParam.EQ, settleVO.getSettleType()));
            List<SettleEntity> settleEntityList = service.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(settleEntityList)) {
                vo.setSettleTimes(settleEntityList.size());
            } else {
                vo.setSettleTimes(0);
            }
        }

//        查询中间计量价格调整和增补数据
        LambdaQueryWrapper<SettleEntity> lambda = Wrappers.<SettleEntity>lambdaQuery();
        lambda.in(SettleEntity::getBillState, 1,3);
        lambda.eq(SettleEntity::getContractId, settleVO.getContractId());
        List<SettleEntity> entities = service.list(lambda);
        if (CollectionUtils.isNotEmpty(entities)){
            List<Long> settleIds = entities.stream().map(SettleEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<SettlePriceEntity> lambdaPrice = Wrappers.<SettlePriceEntity>lambdaQuery();
            lambdaPrice.in(SettlePriceEntity::getSettleId, settleIds);
            lambdaPrice.in(SettlePriceEntity::getSettleType, 0);
            List<SettlePriceEntity> settlePriceEntityList = settlePriceService.list(lambdaPrice);
            List<SettlePriceVO> settlePriceVOS = BeanMapper.mapList(settlePriceEntityList, SettlePriceVO.class);
            vo.setSettlePriceList(settlePriceVOS);
        }

        return CommonResponse.success("查询子表数据成功！", vo);
    }

    private List<SettleDetailVO> changeToMeasureDetail(List<ContractDetailVO> details, List<SettleDetailVO> vos, String sourceType) {
        SettleDetailVO measureDetailVO = vos.get(0);
        Map<Long, List<SettleDetailVO>> vosMap = vos.stream().collect(Collectors.groupingBy(SettleDetailVO::getContractDetailId));
        Map<Long, SettleDetailVO> treeVOMap = new HashMap<>();
        Map<Long, SettleDetailVO> resultMap = new HashMap<>();
        Map<Long, Long> idMap = new HashMap<>();
        SettleDetailVO tmp = null;
        for (ContractDetailVO contractDetail : details) {
            if (null != vosMap.get(contractDetail.getId())) {
                for (SettleDetailVO s : vosMap.get(contractDetail.getId())) {
                    tmp = BeanMapper.map(s, SettleDetailVO.class);
                    tmp.setParentId(contractDetail.getParentId());
                    s.setParentId(contractDetail.getParentId());
                    if (sourceType.equals("分包计量")) {
                        s.setDetailArtificialTaxPrice(contractDetail.getDetailArtificialTaxPrice());
                        if (contractDetail.getDetailArtificialTaxPrice() != null && s.getSettleNum() != null) {
                            s.setDetailArtificialTaxMny(contractDetail.getDetailArtificialTaxPrice().multiply(s.getSettleNum()));
                        }
                    }

                    treeVOMap.put(tmp.getId(), tmp);
                }
            } else {//如果当前清单没在分包明细里，给它赋初值
                tmp = new SettleDetailVO();
                tmp.setContractId(measureDetailVO.getContractId());

                tmp.setDetailName(contractDetail.getDetailName());
                tmp.setDetailWorkContent(contractDetail.getDetailWorkContent());
                tmp.setDetailMeasurementRules(contractDetail.getDetailMeasurementRules());
                tmp.setDetailUnit(contractDetail.getDetailUnit());
                tmp.setSourceType(sourceType);
                tmp.setDetailArtificialTaxPrice(contractDetail.getDetailArtificialTaxPrice());
                tmp.setId(IdWorker.getId());
                tmp.setContractDetailId(tmp.getId());
                tmp.setRowState("add");
                tmp.setParentId(contractDetail.getParentId());

                idMap.put(contractDetail.getId(), tmp.getId());

                treeVOMap.put(tmp.getContractDetailId(), tmp);
            }
        }

        for (List<SettleDetailVO> voList : vosMap.values()) {
            for (SettleDetailVO vo : voList) {
                tmp = vo;
                tmp.setParentId(idMap.get(tmp.getParentId()));
                resultMap.put(vo.getId(), tmp);
                tmp.setRowState("add");
            }

            if (null != tmp.getParentId() && !resultMap.containsKey(tmp.getParentId())) {
                findParent(tmp.getParentId(), treeVOMap, resultMap, idMap);
            }
        }
        return new ArrayList<>(resultMap.values());
    }

    private void findParent(Long parentId, Map<Long, SettleDetailVO> treeVOMap, Map<Long, SettleDetailVO> resultMap, Map<Long, Long> idMap) {
        SettleDetailVO parent = treeVOMap.get(parentId);
        parent.setRowState("add");
        parent.setParentId(idMap.get(parent.getParentId()));
        resultMap.put(parentId, parent);
        if (null != parent.getParentId() && !resultMap.containsKey(parent.getParentId())) {
            findParent(parent.getParentId(), treeVOMap, resultMap, idMap);
        }
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 工人工资单参照
     */
    @RequestMapping(value = "/refSettleSalaryData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleSalaryVO>> refSalaryData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                               @RequestParam(defaultValue = "10") Integer pageSize,
                                                               @RequestParam(value = "condition", required = false) String condition,
                                                               @RequestParam(value = "searchObject", required = false) String searchObject,
                                                               @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Integer settleType = null;
        Long contractId = null;
        String settleDate = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
            settleDate = _con.getString("settleDate");
        }
        Page<SettleSalaryEntity> pg = new Page<>(pageNumber, pageSize);
        IPage<SettleSalaryEntity> page = salaryService.selectPageSalary(pg, settleType, contractId, settleDate);
        IPage<SettleSalaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleSalaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @GetMapping(value = "/getBillShareLink")
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        SettleEntity entity = service.selectById(id);
        Integer settType = entity.getSettleType();

        String mobileH5url = null, mobileWxUrl = null, billtype = null;
        if (SettleTypeEnum.节点.getCode().equals(settType)) {
            billtype = nodeBillType;
            mobileH5url = nodeMobileBillShareFrontUrl;
            mobileWxUrl = nodeMobileBillShareFrontUrl;
        } else if (SettleTypeEnum.过程.getCode().equals(settType)) {
            billtype = processBillType;
            mobileH5url = procMobileBillShareFrontUrl;
            mobileWxUrl = procMobileBillShareFrontUrl;
        } else {
            billtype = finishBillType;
            mobileH5url = finishMobileBillShareFrontUrl;
            mobileWxUrl = finishMobileBillShareFrontUrl;
        }

        if (SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billtype);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billtype, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(BeanMapper.map(entity, SettleEntity.class), billtype, cooperateResp.getData());
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
            }
        }
        return shareCooperateApi.getShareLink(id, billtype, entity.getSupplierId().toString(), mobileH5url, mobileWxUrl);
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 零工参照
     */
    @RequestMapping(value = "/refSettleOddjobData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleOddjobVO>> refSettleOddjobData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                     @RequestParam(defaultValue = "10") Integer pageSize,
                                                                     @RequestParam(value = "condition", required = false) String condition,
                                                                     @RequestParam(value = "searchObject", required = false) String searchObject,
                                                                     @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Integer settleType = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page<SettleOddjobEntity> pg = new Page<>(pageNumber, pageSize);
        IPage<SettleOddjobEntity> page = oddjobService.selectPageSalary(pg, settleType, contractId);
        IPage<SettleOddjobVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleOddjobVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 领料参照
     */
    @RequestMapping(value = "/refSettlePickingData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettlePickingVO>> refSettlePickingData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                       @RequestParam(defaultValue = "10") Integer pageSize,
                                                                       @RequestParam(value = "condition", required = false) String condition,
                                                                       @RequestParam(value = "searchObject", required = false) String searchObject,
                                                                       @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Integer settleType = null;
        Long contractId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page<SettlePickingEntity> pg = new Page<>(pageNumber, pageSize);
        IPage<SettlePickingEntity> page = pickingService.selectPageSalary(pg, settleType, contractId);
        IPage<SettlePickingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlePickingVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 其他费用参照
     */
    @RequestMapping(value = "/refSettleOtherData", method = RequestMethod.GET)
    public CommonResponse<IPage<SettleOtherVO>> refOtherData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                             @RequestParam(defaultValue = "10") Integer pageSize,
                                                             @RequestParam(value = "condition", required = false) String condition,
                                                             @RequestParam(value = "searchObject", required = false) String searchObject,
                                                             @RequestParam(value = "searchText", required = false) String searchText) {
        Long contractId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            contractId = Long.valueOf(_con.getString("contractId"));
        }
        Page<SettleOtherEntity> pg = new Page<>(pageNumber, pageSize);
        IPage<SettleOtherEntity> page = otherService.selectPageOther(pg, contractId, searchText);
        IPage<SettleOtherVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleOtherVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return IPage<SalaryVO>
     * @Description 分包清单（合同）参照
     */
    @RequestMapping(value = "/refSettleDetailData", method = RequestMethod.GET)
    public CommonResponse<List<SettleDetailVO>> refDetailData(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                              @RequestParam(defaultValue = "10") Integer pageSize,
                                                              @RequestParam(value = "condition", required = false) String condition,
                                                              @RequestParam(value = "searchObject", required = false) String searchObject,
                                                              @RequestParam(value = "searchText", required = false) String searchText) {
        Integer settleType = null;
        Long contractId = null;
        List<String> oldDelIdList = new ArrayList<>();
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            logger.info("condition：{}", _con);
            settleType = Integer.valueOf(_con.getString("settleType"));
            contractId = Long.valueOf(_con.getString("contractId"));
            if (StringUtils.isNotBlank(_con.getString("oldDelDataId"))) {
                oldDelIdList = Arrays.asList(_con.getString("oldDelDataId").split(","));
            }
        }
        Page<SettleDetailEntity> pg = new Page<>(pageNumber, pageSize);
        pg.setSize(-1);
        IPage<SettleDetailEntity> page = detailService.selectPageDetail(pg, settleType, contractId, searchText, CollectionUtils.isNotEmpty(oldDelIdList) ? oldDelIdList : null);

        List<SettleDetailVO> resList = new ArrayList<>();
        List<SettleDetailVO> settleDetailList = BeanMapper.mapList(page.getRecords(), SettleDetailVO.class);
        if (CollectionUtils.isNotEmpty(settleDetailList)) {
            for (SettleDetailVO detail : settleDetailList) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            resList = TreeNodeBUtil.buildTree(settleDetailList);
        }

        return CommonResponse.success("查询参照数据成功！", resList);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @PostMapping(value = "/testPushBill")
    public CommonResponse<String> testPushBill(@RequestBody Long id) {
        SettleEntity entity = service.selectById(id);
        logger.info("推送结算单BASE_HOST：{}", BASE_HOST);
        CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(SettleTypeEnum.节点.getCode().equals(entity.getSettleType()) ? nodeBillType :
                SettleTypeEnum.过程.getCode().equals(entity.getSettleType()) ? processBillType : finishBillType);
        service.pushBillToSupCenter(entity, SettleTypeEnum.节点.getCode().equals(entity.getSettleType()) ? nodeBillType :
                SettleTypeEnum.过程.getCode().equals(entity.getSettleType()) ? processBillType : finishBillType, cooperateResp.getData());

        return CommonResponse.success("推送成功！~");
    }

/*     @GetMapping(value = "/getBillShareLink")
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam(value = "id") Long id,
                                                       @RequestParam(value = "billType") String billType) {
        SettleEntity entity = service.selectById(id);

        if (SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus()) && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billType);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billType, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity, billType, cooperateResp.getData());
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }

        return shareCooperateApi.getShareLink(id, billType, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    } */

    /**
     * 查询合同结算记录
     *
     * @param id         合同Id
     * @param settleType 结算类型
     * @return
     */
    @GetMapping(value = "/queryDetailRecord")
    public CommonResponse<SettleRecordVO> queryDetailRecord(@RequestParam(value = "id") Long id,
                                                            @RequestParam(value = "settleType") Integer settleType) {
        SettleRecordVO vo = service.queryDetailRecord(id, settleType);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @GetMapping(value = "/newSettleCheck")
    public CommonResponse<String> beforeNewSettleCheck(@RequestParam(value = "id") Long contractId,
                                                       @RequestParam(value = "settleType") Integer settleType) {
        String msg = service.beforeNewSettleCheck(contractId, settleType);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        } else {
            return CommonResponse.success("改合同可以新增结算");
        }
    }


//    /**
//     * 结算参照查询
//     *
//     * @param pageNumber
//     * @param pageSize
//     * @param condition
//     * @param searchText
//     * @return
//     */
//    @ResponseBody
//    @RequestMapping(value = "/settleRef", method = RequestMethod.GET)
//    public CommonResponse<JSONObject> settleRef(
//            @RequestParam(defaultValue = "1") Integer pageNumber,
//            @RequestParam(defaultValue = "10") Integer pageSize,
//            @RequestParam(value = "condition", required = false) String condition,
//            @RequestParam(value = "searchText", required = false) String searchText) {
//        QueryParam queryParam = new QueryParam();
//        queryParam.setPageIndex(pageNumber);
//        queryParam.setPageSize(pageSize);
//        queryParam.setSearchText(searchText);
//        //设置模糊查询
//        List<String> fuzzyFields = queryParam.getFuzzyFields();
//        fuzzyFields.add("billCode");
//        fuzzyFields.add("contractName");
//        fuzzyFields.add("projectName");
//        fuzzyFields.add("supplierName");
//        if (null == condition || org.apache.commons.lang.StringUtils.isBlank(condition)) {
//            return CommonResponse.error("查询失败，当前传入condition为空！");
//        }
//
//
//        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
//        if (null != conditionMap.get("contractId")) {
//            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, conditionMap.get("contractId")));
//        }
//
//        if (null != conditionMap.get("projectId")) {
//            Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
//            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
//        } else {
//            //查询本下范围内日的合同
//            Long orgId = Long.parseLong(conditionMap.get("orgId").toString());
//            //若当前上下文为项目部，则根据项目部Id来进行查询
//            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
//                queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
//            } else {
//                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
//                if (!orgResp.isSuccess()) {
//                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
//                    return CommonResponse.error("查询失败，获取组织信息失败！");
//                }
//                queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
//                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//            }
//        }
//        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, ("1,3")));
//
//        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
//        orderMap.put("create_time", QueryParam.DESC);
//        queryParam.setOrderMap(orderMap);
//        IPage<SettleEntity> pageData = service.queryPage(queryParam, false);
//        JSONObject page = new JSONObject();
//        page.put("records", BeanMapper.mapList(pageData.getRecords(), SettleVO.class));
//        page.put("total", pageData.getTotal());
//        page.put("current", pageData.getCurrent());
//        page.put("size", pageData.getSize());
//        page.put("pages", pageData.getPages());
//        return CommonResponse.success("查询结算数据成功！", page);
//    }

    /**
     * 返回当前合同的累计结算金额
     *
     * @param settleVO
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/queryTotalNodeAndFin", method = RequestMethod.POST)
    public CommonResponse<SettleVO> queryTotalNodeAndFin(@RequestBody SettleVO settleVO) {
        return CommonResponse.success("查询数据成功", service.queryTotalNodeAndFin(settleVO.getContractId(), settleVO.getProjectId()));
    }

    @PostMapping(value = "/pushSettleToPool")
    @ResponseBody
    public CommonResponse<SettleVO> pushSettleToPool(@RequestBody Long settleId) {
        JedisTemplate jedisTemplate = cacheManager.getJedisTemplate();
        //校验当前合同是否正在进行同步操作
        String contractIdStr = jedisTemplate.get(PUSH_POOL_PREFIX + settleId.toString());
        if (StringUtils.isNotBlank(contractIdStr)) {
            return CommonResponse.error("当前单据数据已处于同步操作中，请勿重复操作！");
        }
        //校验通过，执行合同同步操作
        jedisTemplate.set(PUSH_POOL_PREFIX + settleId.toString(), settleId.toString());

        SettleEntity dbEntity = service.selectById(settleId);

        if (null == dbEntity) {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + settleId.toString());
            return CommonResponse.error("结算单推送结算池失败，未找到Id-" + settleId + "匹配的结算单！");
        }
        SettleVO s = BeanMapper.map(dbEntity, SettleVO.class);

        SettlePoolVO spv = new SettlePoolVO();
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始");
            // 对象自动转换
            BeanConvertorUtil.convert(s, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            service.convertSettleVOToSettlePoolVO(s, spv);
            //设置 结算单详情地址
            //判断是劳务 还是 分包合同
            String settleType = "";
            String contractType = "";
            if (SettleTypeEnum.过程.getCode().equals(s.getSettleType())) {
                settleType = "processSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.非最终结算.getCode());
            } else if (SettleTypeEnum.完工.getCode().equals(s.getSettleType())) {
                settleType = "finishSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.最终结算.getCode());
                spv.setFinishCurTaxMny(s.getTaxMny());
                spv.setFinishCurMny(s.getMny());
                spv.setCurTax(s.getTax());

                // 差额取值方式参数
                CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(FINISH_SETTLE_DIFFERENCE_CONFIG);
                if (!response.isSuccess() || response.getData() == null) {
                    throw new BusinessException("获取完工单差额取值方式系统参数请求失败，失败原因：" + response.getMsg());
                }
                String valueData = response.getData().getValueData();
                if("1".equals(valueData)) {
                    //使用过程结算取差额
                    spv.setCurTaxMny(s.getTotalProcessTaxDifference());
                    if (null != s.getTotalProcessDifference()){
                        spv.setCurMny(s.getTotalProcessDifference());
                        spv.setCurTax(s.getTotalProcessTaxDifference().subtract(s.getTotalProcessDifference()));
                    }
                    spv.setResidueApplyMny(s.getTotalProcessTaxDifference());

                } else {
                    //使用节点结算取差额
                    spv.setCurTaxMny(s.getTotalNodeTaxDifference());
                    if (null != s.getTotalNodeDifference()){
                        spv.setCurMny(s.getTotalNodeDifference());
                        spv.setCurTax(s.getTotalNodeTaxDifference().subtract(s.getTotalNodeDifference()));
                    }
                    spv.setResidueApplyMny(s.getTotalNodeTaxDifference());
                }

            } else if (SettleTypeEnum.节点.getCode().equals(s.getSettleType())) {
                settleType = "nodeSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.非最终结算.getCode());
            }
            if (s.getContractType() == 0) {
                //劳务
                contractType = "laborsub";
                if(StringUtils.isBlank(spv.getContractType())) {
                    spv.setContractType(ContractTypeEnum.劳务分包合同.getTypeCode());
                    spv.setContractTypeName(ContractTypeEnum.劳务分包合同.getTypeName());
                }
            } else if (s.getContractType() == 1) {
                //专业
                contractType = "prosub";
                if(StringUtils.isBlank(spv.getContractType())) {
                    spv.setContractType(ContractTypeEnum.专业分包合同.getTypeCode());
                    spv.setContractTypeName(ContractTypeEnum.专业分包合同.getTypeName());
                }
            } else {
                logger.info("结算单合同类型未知结算单id-{}", s.getId());
            }
            spv.setBillCodeUrl("/ejc-prosub-frontend/#/" + settleType + "/" + contractType + "/card?id=" + s.getId());
            spv.setContractFlag(ContractFlagEnum.有合同结算.getContractFlagCode());
            spv.setContractFlagName(ContractFlagEnum.有合同结算.getContractFlagCodeName());
            spv.setHandleType(0); //业务系统推送结算池
            service.fillOtherSettlePoolAttr(dbEntity, spv);

            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                logger.info("结算单推送至结算池成功！结算单id-{}", s.getId());
                if (BillPushStatusEnum.未成功推送.getStatus().equals(dbEntity.getPushPoolFlag())) {
                    dbEntity.setPushPoolFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(dbEntity);
                }
                return CommonResponse.success("结算单推送结算池成功！");
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", s.getId(), e);
        } finally {
            //删除合同同步控制标签
            jedisTemplate.del(PUSH_POOL_PREFIX + settleId.toString());
        }
        return CommonResponse.error("结算单推送失败", s);
    }

    /**
     * 分包结算单参照查询
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/settleRef", method = RequestMethod.GET)
    public CommonResponse<JSONObject> settleRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        //设置模糊查询
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        if (null == condition || org.apache.commons.lang.StringUtils.isBlank(condition)) {
            return CommonResponse.error("查询失败，当前传入condition为空！");
        }
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        if (!(null != conditionMap.get("orgId"))) {
            return CommonResponse.error("当前传入组织id为空！");
        }
        if (null != conditionMap.get("orgId") && null == conditionMap.get("orgType")) {
            return CommonResponse.error("当前传入组织类型为空！");
        }
        if (null != conditionMap.get("contractType")) {
            queryParam.getParams().put("contractType", new Parameter(QueryParam.EQ, conditionMap.get("contractType")));
        }
        if (null != conditionMap.get("settleType")) {
            queryParam.getParams().put("settleType", new Parameter(QueryParam.EQ, conditionMap.get("settleType")));
        }

        //查询本下范围内日的合同
        Long orgId = Long.parseLong(conditionMap.get("orgId").toString());



        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(conditionMap.get("orgType").toString()))) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }

        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        queryParam.getParams().put("filing_status", new Parameter(QueryParam.EQ, 0));
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SettleEntity> pageData = service.queryPage(queryParam, false);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), SettleVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询分包结算数据成功！", page);
    }


    /**
     * 结算单推送目标成本
     *
     * @param settleId
     * @return
     */
    @PostMapping(value = "/pushSettle2TargetCost")
    public CommonResponse<String> pushSettle2TargetCost(@RequestBody Long settleId) {
        service.pushSettle2TargetCost(settleId);
        return CommonResponse.success("结算单推送目标成本成功！");
    }
}
