/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.PicKingEntity;
import com.ejianc.business.process.bean.PicKingTotalEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.mapper.PickingMapper;
import com.ejianc.business.process.service.IPicKingStoreService;
import com.ejianc.business.process.service.IPicKingTotalService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.vo.PicKingStoreVO;
import com.ejianc.business.process.vo.PicKingTotalVO;
import com.ejianc.business.process.vo.PicKingVO;
import com.ejianc.business.settle.service.IFinishSettleService;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="pickingService")
public class PickingServiceImpl
extends BaseServiceImpl<PickingMapper, PicKingEntity>
implements IPickingService {
    private final String OPERATE = "PICKING_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/picking/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/picking/billDel";
    private final String billType = "BT220117000000002";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IPicKingTotalService totalService;
    @Autowired
    private IFinishSettleService finishSettleService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IPicKingTotalService picKingTotalService;
    @Autowired
    private IPicKingStoreService picKingStoreService;
    @Autowired
    private IAccountSettleApi accountSettleApi;

    public void qqq() {
        StoreApiVO storeApiVO = new StoreApiVO();
        this.accountSettleApi.changeSettleFlag(storeApiVO);
    }

    @Override
    public BigDecimal queryTotalNum(Long pickingId, String classifyCondition) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pickingId", new Parameter("eq", (Object)pickingId));
        queryParam.getParams().put("classifyCondition", new Parameter("eq", (Object)classifyCondition));
        List entities = this.totalService.queryList(queryParam, false);
        BigDecimal totalNum = BigDecimal.ZERO;
        for (PicKingTotalEntity total : entities) {
            totalNum = totalNum.add(total.getActualOutNum());
        }
        return totalNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(PicKingEntity picKingEntity, String billTypeCode, CooperateVO cooperate) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + picKingEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(picKingEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u9886\u6599\u7ed3\u7b97\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)picKingEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        picKingEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        picKingEntity.setTenantId(null);
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PICKING_BILL_SYNC", (int)600);
            if (!locked) {
                this.executeUpdate(picKingEntity.getId(), false);
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "PICKING_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)picKingEntity)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(picKingEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9886\u6599\u7ed3\u7b97\u5355\u636e\u53c2\u6570-{}", (Object)picKingEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/picking/billSync", paramMap, picKingEntity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        this.executeUpdate(picKingEntity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(picKingEntity.getId(), false);
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9886\u6599\u7ed3\u7b97\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{picKingEntity.getSupplierId(), picKingEntity.getId(), billPushResp.getMsg()});
                    }
                } else {
                    this.executeUpdate(picKingEntity.getId(), false);
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9886\u6599\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{picKingEntity.getId(), picKingEntity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.executeUpdate(picKingEntity.getId(), false);
                this.logger.error("\u83b7\u53d6\u9886\u6599\u7ed3\u7b97\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)picKingEntity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.executeUpdate(picKingEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u9886\u6599\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{picKingEntity.getId(), picKingEntity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "PICKING_BILL_SYNC");
        }
        return syncFlag;
    }

    private void executeUpdate(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u5355\u636e\u7b7e\u7ae0\u901a\u77e5\uff1aid-{}, supOperatorName-{}, supOperatorPhone-{}, supOperatorUserCode-{}, supOperateTime-{}, nameSourceTypeMapping-{}", new Object[]{billId, supOperatorName, supOperatorPhone, supOperatorUserCode, supOperateTime, nameSourceTypeMapping});
        PicKingEntity picKingEntity = (PicKingEntity)((Object)super.selectById((Serializable)((Object)billId)));
        picKingEntity.setSupOperateTime(supOperateTime);
        picKingEntity.setSupOperatorName(supOperatorName);
        picKingEntity.setSupOperatorPhone(supOperatorPhone);
        picKingEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220117000000002::" + picKingEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PICKING_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "PICKING_BILL_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, "BT220117000000002", authority, picKingEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            picKingEntity.setAttachIds(attchIdsList);
            picKingEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
            super.saveOrUpdate((Object)picKingEntity, false);
            String msgSendResult = this.sendMsg(picKingEntity, "\u4f9b\u65b9\u5df2\u7b7e\u5b57\u63d0\u9192", "\u9886\u6599\u7ed3\u7b97\u5355\u636e[" + picKingEntity.getBillCode() + "]\u4f9b\u65b9\u5df2\u7b7e\u5b57\u5b8c\u6210");
            if (null != msgSendResult) {
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u5355\u636eid-{}\u7b7e\u5b57\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])new Long[]{picKingEntity.getCreateUserId(), picKingEntity.getEmployeeId()}), picKingEntity.getId(), msgSendResult});
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)picKingEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "PICKING_BILL_SYNC");
        }
        return msg;
    }

    private String sendMsg(PicKingEntity picKingEntity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{picKingEntity.getCreateUserId().toString(), picKingEntity.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(picKingEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delPushBill(PicKingEntity picKingEntity, String billTypeCode) {
        boolean locked = false;
        boolean delSuc = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + picKingEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u9886\u6599\u7ed3\u7b97\u5355\u636e\u5355\u636e-{}\u4f5c\u5e9f\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)picKingEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
        }
        picKingEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"PICKING_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "PICKING_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", picKingEntity.getId().toString());
            paramMap.put("sourceSystemId", picKingEntity.getSourceSystemId());
            this.logger.info("\u9886\u6599\u7ed3\u7b97\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)picKingEntity.getSupplierId(), (Object)picKingEntity.getId());
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/picking/billDel", RequestMethod.POST, JSONObject.toJSONString(paramMap), picKingEntity.getSupplierId().toString());
            if (syncReqResp.isSuccess()) {
                CommonResponse supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    delSuc = true;
                } else {
                    this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u9886\u6599\u7ed3\u7b97\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{picKingEntity.getSupplierId(), picKingEntity.getId(), supHandleResp.getMsg()});
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{picKingEntity.getSupplierId(), picKingEntity.getId(), syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)picKingEntity.getId(), (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "PICKING_BILL_SYNC");
        }
        return delSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public CommonResponse<PicKingVO> queryPicking(Long contractId, Long projectId) {
        PicKingVO picKingVO = new PicKingVO();
        BigDecimal subtract = BigDecimal.ZERO.subtract(BigDecimal.ONE);
        System.out.println("subtract" + subtract);
        CommonResponse commonResponse = this.finishSettleService.queryFinishFlag(contractId);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)commonResponse.getMsg());
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pickContractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("effectiveState", new Parameter("eq", (Object)1));
        queryParam.getParams().put("settleFlag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("inOutFlag", new Parameter("eq", (Object)2));
        CommonResponse response = this.storeFlowApi.getFlowList(queryParam);
        this.logger.info("\u8fd4\u56de\u4fe1\u606f" + JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        ArrayList<PicKingStoreVO> outList = new ArrayList<PicKingStoreVO>();
        ArrayList<PicKingStoreVO> exitList = new ArrayList<PicKingStoreVO>();
        List flowVOList = (List)response.getData();
        this.logger.info("\u4ed3\u5e93\u8fd4\u56de\u6570\u636e" + JSONObject.toJSONString((Object)flowVOList));
        for (FlowVO flowVO : flowVOList) {
            PicKingStoreVO picKingStoreVO = (PicKingStoreVO)BeanMapper.map((Object)flowVO, PicKingStoreVO.class);
            picKingStoreVO.setStoreId(flowVO.getId());
            picKingStoreVO.setNum(flowVO.getNum() != null ? flowVO.getNum().abs() : BigDecimal.ZERO);
            picKingStoreVO.setPrice(flowVO.getPrice() != null ? flowVO.getPrice().abs() : BigDecimal.ZERO);
            picKingStoreVO.setTaxPrice(flowVO.getTaxPrice() != null ? flowVO.getTaxPrice().abs() : BigDecimal.ZERO);
            picKingStoreVO.setMny(flowVO.getMny() != null ? flowVO.getMny().abs() : BigDecimal.ZERO);
            picKingStoreVO.setTaxMny(flowVO.getTaxMny() != null ? flowVO.getTaxMny().abs() : BigDecimal.ZERO);
            picKingStoreVO.setPaymentFlag(Integer.valueOf(0));
            if (flowVO.getReturnStoreFlag() == 0) {
                outList.add(picKingStoreVO);
                continue;
            }
            exitList.add(picKingStoreVO);
        }
        List<PicKingTotalVO> picKingTotalVOS = this.totalService.totalSumList(contractId, projectId);
        picKingVO.setTotalList(picKingTotalVOS);
        picKingVO.setOutList(outList);
        picKingVO.setExitList(exitList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)picKingVO);
    }

    @Override
    public void deletePicking(Long id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        super.remove((Wrapper)updateWrapper);
        this.picKingTotalService.deleteByPickingId(id);
        this.picKingStoreService.deleteByPickingId(id);
    }
}

