/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.enums.UseFlagEnum;
import com.ejianc.business.process.mapper.RegistrationMapper;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.process.vo.RegistrationVO;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="registrationService")
public class RegistrationServiceImpl
extends BaseServiceImpl<RegistrationMapper, RegistrationEntity>
implements IRegistrationService {
    private static final String LAB_CHECK_PARAM_CODE = "P-34v45349";
    @Autowired
    private JedisPool jedisPool;
    private final String OPERATE = "REGISTRATION_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/registration/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/registration/billDel";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    private final String billType = "BT211230000000003";
    private static final String PRO_CHECK_PARAM_NAME = "P-0lV6mY50";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IApplicationService applicationService;

    @Override
    public CommonResponse<RegistrationVO> getCommonById(Long id) {
        RegistrationEntity entity = (RegistrationEntity)((Object)this.selectById(id));
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), RegistrationVO.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(RegistrationEntity entity, String billTypeCode, CooperateVO cooperateVO) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(entity.getId(), false);
            this.logger.error("\u63a8\u9001\u96f6\u5de5\u767b\u8bb0\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        entity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        entity.setTenantId(null);
        if (CollectionUtils.isNotEmpty(entity.getDeductList())) {
            entity.getDeductList().forEach(item -> item.setTenantId(null));
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            entity.getDetailList().forEach(item -> item.setTenantId(null));
        }
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"REGISTRATION_BILL_SYNC", (int)600);
            if (!locked) {
                this.executeUpdate(entity.getId(), false);
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "REGISTRATION_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)entity)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u96f6\u5de5\u767b\u8bb0\u5355\u636e\u53c2\u6570-{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/registration/billSync", paramMap, entity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse supResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (supResp.isSuccess()) {
                        this.executeUpdate(entity.getId(), true);
                        syncFlag = true;
                    } else {
                        this.executeUpdate(entity.getId(), false);
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReqResp.getMsg()});
                    }
                } else {
                    this.executeUpdate(entity.getId(), false);
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5931\u8d25, {}", new Object[]{entity.getId(), entity.getSupplierId(), syncReqResp.getMsg()});
                }
            } else {
                this.executeUpdate(entity.getId(), false);
                this.logger.error("\u83b7\u53d6\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)entity.getId(), (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.executeUpdate(entity.getId(), false);
            this.logger.error("\u63a8\u9001\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{entity.getId(), entity.getSupplierId(), e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "REGISTRATION_BILL_SYNC");
        }
        return syncFlag;
    }

    private <T extends BaseEntity> void clearTenantId(List<T> entityList) {
        entityList.forEach(item -> item.setTenantId(null));
    }

    private void executeUpdate(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delPushBill(RegistrationEntity entity, String billTypeCode) {
        boolean locked = false;
        boolean delSuc = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u96f6\u5de5\u767b\u8bb0\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)entity.getId(), (Object)ejcCloudSystemCode.getMsg());
        }
        entity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"REGISTRATION_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "REGISTRATION_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", entity.getId().toString());
            paramMap.put("sourceSystemId", entity.getSourceSystemId());
            this.logger.info("\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)entity.getSupplierId(), (Object)entity.getId());
            CommonResponse syncReResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/registration/billDel", RequestMethod.POST, JSONObject.toJSONString(paramMap), entity.getSupplierId().toString());
            if (syncReResp.isSuccess()) {
                CommonResponse supResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReResp.getData()), CommonResponse.class);
                if (supResp.isSuccess()) {
                    delSuc = true;
                } else {
                    this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), supResp.getMsg()});
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{}\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{entity.getSupplierId(), entity.getId(), syncReResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "REGISTRATION_BILL_SYNC");
        }
        return delSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        RegistrationEntity entity = (RegistrationEntity)((Object)super.selectById((Serializable)((Object)billId)));
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT211230000000003::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"REGISTRATION_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)entity.getId());
                this.releaseLock(jedis, false, key, "REGISTRATION_BILL_SYNC");
                String string = "\u96f6\u5de5\u767b\u8bb0\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, "BT211230000000003", authority, entity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.setAttachIds(attchIdsList);
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
            super.saveOrUpdate((Object)entity, false);
            String msgSendResult = this.sendMsg(entity, "\u4f9b\u65b9\u5df2\u7b7e\u5b57\u63d0\u9192", "\u96f6\u5de5\u767b\u8bb0\u5355\u636e[" + entity.getBillCode() + "]\u4f9b\u65b9\u5df2\u7b7e\u5b57\u5b8c\u6210");
            if (null != msgSendResult) {
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u7b7e\u5b57\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])new Long[]{entity.getCreateUserId(), entity.getEmployeeId()}), entity.getId(), msgSendResult});
            }
        }
        catch (Exception e) {
            this.logger.error("\u96f6\u5de5\u767b\u8bb0\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u96f6\u5de5\u767b\u8bb0\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "REGISTRATION_BILL_SYNC");
        }
        return msg;
    }

    private String sendMsg(RegistrationEntity entity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{entity.getCreateUserId().toString(), entity.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public ParamsCheckVO mnyCtrl(RegistrationVO registrationVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        CommonResponse billParamByCode = new CommonResponse();
        if (0 == registrationVO.getContractType()) {
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(registrationVO.getContractId()));
            if (!"laborSub-2".equals(contract.getContractCategoryProperty())) {
                billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(LAB_CHECK_PARAM_CODE, registrationVO.getOrgId());
            } else {
                this.logger.info("\u96f6\u5de5\u767b\u8bb0-\u3010{}\u3011\u6240\u5c5e\u5408\u540c-\u3010{}\u3011\u4e3a\u96f6\u5de5\u5408\u540c\uff0c\u4e0d\u8fdb\u884c\u53c2\u6570\u63a7\u5236\uff01", (Object)JSONObject.toJSONString((Object)registrationVO), (Object)JSONObject.toJSONString((Object)((Object)contract)));
                paramsCheckVO.setWarnType(paramsArray[0]);
                return paramsCheckVO;
            }
        }
        if (1 == registrationVO.getContractType()) {
            billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PRO_CHECK_PARAM_NAME, registrationVO.getOrgId());
        }
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            this.logger.info("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        List data = (List)billParamByCode.getData();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        for (BillParamVO billParamVO : data) {
            List res;
            ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
            ParamsCheckVO paramsCheck = new ParamsCheckVO();
            BigDecimal roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheck.setWarnType(paramsArray[1]);
            } else {
                paramsCheck.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if ("none".equals(paramsCheck.getWarnType())) continue;
            ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(registrationVO.getContractId()));
            if (null == contract) {
                this.logger.info("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
                throw new BusinessException("\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
            }
            BigDecimal contractTaxMny = contract.getContractTaxMny().multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
            BigDecimal taxMny = registrationVO.getTotalTaxMny();
            BigDecimal totalTaxMny = BigDecimal.ZERO;
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"contract_id", (Object)registrationVO.getContractId());
            if (null != registrationVO.getId()) {
                qw.ne((Object)"id", (Object)registrationVO.getId());
            }
            totalTaxMny = CollectionUtils.isNotEmpty((Collection)(res = super.list((Wrapper)qw))) ? res.stream().map(RegistrationEntity::getTotalTaxMny).reduce(taxMny, BigDecimal::add) : taxMny;
            QueryWrapper ae = new QueryWrapper();
            ae.eq((Object)"contract_id", (Object)registrationVO.getContractId());
            ae.eq((Object)"use_flag", (Object)UseFlagEnum.\u96f6\u5de5\u672a\u767b\u8bb0.getCode());
            List aes = this.applicationService.list((Wrapper)ae);
            if (CollectionUtils.isNotEmpty((Collection)aes)) {
                totalTaxMny = aes.stream().map(ApplicationEntity::getTaxMny).reduce(totalTaxMny, BigDecimal::add);
            }
            if (totalTaxMny.compareTo(contractTaxMny) > 0) {
                BigDecimal overTaxMny = totalTaxMny.subtract(contractTaxMny);
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u96f6\u5de5\u8d85\u5408\u540c");
                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u96f6\u5de5\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u96f6\u5de5\u91d1\u989d\uff1a").append(taxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u96f6\u5de5\u91d1\u989d\uff1a").append(totalTaxMny.setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%\uff1a").append(contractTaxMny.setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u7ed3\u91d1\u989d\uff1a").append(overTaxMny.setScale(2, RoundingMode.DOWN));
                paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                checkDsVOS.add(paramsCheckDsVO);
                paramsCheck.setDataSource(checkDsVOS);
                paramsCheckVOList.add(paramsCheck);
                continue;
            }
            paramsCheck.setWarnType(paramsArray[0]);
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUseFlag(Long applicationId, Integer userFlag) {
        Assert.notNull((Object)applicationId, (String)"\u96f6\u5de5\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)userFlag, (String)"\u767b\u8bb0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)applicationId);
        updateWrapper.set((Object)"use_flag", (Object)userFlag);
        this.applicationService.update((Wrapper)updateWrapper);
    }

    @Override
    public List<RegistrationVO> queryLast30BIList(Long orgId, List<Long> parentOrgId) {
        return ((RegistrationMapper)this.baseMapper).queryLast30BIList(orgId, parentOrgId);
    }
}

