/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.prosub.util.ParamCtrlUtil;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettleSalaryEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.enums.SignatureStatusEnum;
import com.ejianc.business.settle.service.IProcessSettleService;
import com.ejianc.business.settle.service.ISettleSalaryService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.ReferenceDetailVO;
import com.ejianc.business.settle.vo.ReferenceMapVO;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleSalaryVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"processSettle"})
public class ProcessSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "PROCESS_SETTLE";
    private static final String PRO_BILL_CODE = "PRO_PROCESS_SETTLE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProcessSettleService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private ISalaryApi salaryApi;
    @Autowired
    private ISettleSalaryService settleSalaryService;
    private final String PROCOST_PC_DETAIL_URL = "ejc-share-frontend/#/costShare/card?id=";
    private final String PAYMENT_APPLY_DETAIL_PC_URL_CONTRACT = "ejc-profinance-frontend/#/paymentList/contractCard?id=";
    private final String PAYMENT_APPLY_DETAIL_PC_URL_NO_CONTRACT = "ejc-profinance-frontend/#/noContractCard?id=";
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMdApi mdApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        List salaryVOList;
        String salaryParameterFlag;
        List<SettleDetailEntity> detailList;
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)(entity.getContractType() == 0 ? BILL_CODE : PRO_BILL_CODE), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setFilingStatus(0);
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
        }
        if (!(detailList = entity.getSettleDetailList()).isEmpty()) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (Object sd : detailList) {
                if ("del".equals(sd.getRowState())) continue;
                if (sd.getId() == null || entity.getId() == null) {
                    sd.setId(IdWorker.getId());
                }
                idMap.put(sd.getTid(), sd.getId());
                sd.setParentId(null);
            }
            for (Object sd : detailList) {
                if ("del".equals(sd.getRowState()) || !StringUtils.isNotEmpty((CharSequence)sd.getTpid())) continue;
                sd.setParentId((Long)idMap.get(sd.getTpid()));
            }
        }
        entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        this.service.saveOrUpdate((Object)entity, false);
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        List voList = vo.getSettleDetailList();
        if (!voList.isEmpty()) {
            for (SettleDetailVO detail : voList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)voList));
        }
        if ("1".equals(salaryParameterFlag = this.settleService.salaryParameterFlag()) && CollectionUtils.isNotEmpty((Collection)(salaryVOList = vo.getSettleSalaryList()))) {
            ArrayList<Long> delSalaryIdList = new ArrayList<Long>();
            ArrayList<Long> saveSalaryIdList = new ArrayList<Long>();
            for (SettleSalaryVO settleSalaryVO : salaryVOList) {
                if ("del".equals(settleSalaryVO.getRowState())) {
                    delSalaryIdList.add(settleSalaryVO.getSourceId());
                    continue;
                }
                saveSalaryIdList.add(settleSalaryVO.getSourceId());
            }
            if (CollectionUtils.isNotEmpty(delSalaryIdList)) {
                this.salaryApi.writeSalarySettleId(delSalaryIdList, "");
            }
            if (CollectionUtils.isNotEmpty((Collection)salaryVOList)) {
                this.salaryApi.writeSalarySettleId(saveSalaryIdList, String.valueOf(entity.getId()));
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u5f02\u5e38\uff01");
        }
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        List detailList = vo.getSettleDetailList();
        if (!detailList.isEmpty()) {
            for (SettleDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setSettleDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        List<Long> billIds = vos.stream().map(SettleVO::getId).collect(Collectors.toList());
        String checkResult = this.settleService.delCheck(billIds);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            return CommonResponse.error((String)checkResult);
        }
        String salaryParameterFlag = this.settleService.salaryParameterFlag();
        if ("1".equals(salaryParameterFlag)) {
            List delIds;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("settleId", new Parameter("in", billIds));
            List settleSalaryEntityList = this.settleSalaryService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)settleSalaryEntityList) && CollectionUtils.isNotEmpty(delIds = settleSalaryEntityList.stream().map(SettleSalaryEntity::getSourceId).collect(Collectors.toList()))) {
                this.salaryApi.writeSalarySettleId(delIds, "");
            }
        }
        this.service.removeByIds(billIds, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8fc7\u7a0b.getCode()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settle_type", new Parameter("eq", (Object)SettleTypeEnum.\u8fc7\u7a0b.getCode()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SettleVO.class);
        voList.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setSignStatusName(Objects.equals(vo.getSupplierSignStatus(), SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode()) ? "\u4e59\u65b9\u672a\u7b7e\u5b57" : "\u4e59\u65b9\u5df2\u7b7e\u5b57");
            vo.setSignatureStatusName(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("processSettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSettleData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/mnyCtrl"}, method={RequestMethod.POST})
    public CommonResponse<ParamsCheckVO> mnyCtrl(@RequestBody SettleVO settleVO) {
        ParamsCheckVO response = this.service.mnyCtrl(settleVO, false);
        if (response == null) {
            this.logger.error("\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u5931\u8d25");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = this.paramCheck(settleVO, response, false);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @RequestMapping(value={"/mnyCtrlById"}, method={RequestMethod.GET})
    public CommonResponse<ParamsCheckVO> mnyCtrlById(@RequestParam(value="id") Long id) {
        SettleEntity settle = (SettleEntity)((Object)this.service.selectById(id));
        if (settle == null) {
            return CommonResponse.error((String)"\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728\uff01");
        }
        SettleVO settleVO = (SettleVO)BeanMapper.map((Object)((Object)settle), SettleVO.class);
        ParamsCheckVO response = this.service.mnyCtrl(settleVO, true);
        if (response == null) {
            this.logger.error("\u8fc7\u7a0b\u7ed3\u7b97\u91d1\u989d\u63a7\u5236\u5931\u8d25");
            response = new ParamsCheckVO();
        }
        ParamsCheckVO responseData = this.paramCheck(settleVO, response, true);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    private ParamsCheckVO paramCheck(@RequestBody SettleVO settleVO, ParamsCheckVO responseData, boolean flag) {
        String responseDataWarnType = responseData.getWarnType();
        int resWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(responseDataWarnType, 1);
        ParamsCheckVO checkVO = this.service.numCtrl(settleVO, flag);
        String warnType = checkVO.getWarnType();
        if (StringUtils.isNotBlank((CharSequence)warnType) && !"none".equals(warnType)) {
            List list;
            int changeWarnTypeInt = ParamCtrlUtil.getWarnTypeInt(warnType, 2);
            if (changeWarnTypeInt > resWarnTypeInt) {
                return checkVO;
            }
            if (changeWarnTypeInt == resWarnTypeInt && CollectionUtils.isNotEmpty((Collection)(list = checkVO.getDataSource()))) {
                responseData.getDataSource().addAll(list);
            }
        }
        return responseData;
    }

    @GetMapping(value={"/getReferenceMap"})
    public CommonResponse<List<ReferenceMapVO>> getReferenceMap(@RequestParam String type, @RequestParam Long id) {
        Map<String, String> queryParam = this.getQueryDataParam(id.toString());
        CommonResponse dataResp = this.mdApi.queryDataList(queryParam);
        if (!dataResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u7ed3\u7b97\u5355id-{}\u83b7\u53d6\u5f15\u7528\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25{}", (Object)id, (Object)dataResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5f15\u7528\u7ed3\u7b97\u5355\u7684\u5355\u636e\u4fe1\u606f\u5217\u8868\u5931\u8d25\uff01");
        }
        List<ReferenceMapVO> resp = this.getReferenceMapData((Map)dataResp.getData());
        return CommonResponse.success(resp);
    }

    private Map<String, String> getQueryDataParam(String id) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        StringBuilder sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, bill_code, parent_org_name,bill_state,payment_contract_flag  from ejc_payment_apply ").append("where id in (select DISTINCT pay_id from ejc_payment_apply_detail where source_id = ").append(id).append(" and dr =0 ) and dr = 0");
        queryParam.put("BT220223000000003", sp.toString());
        sp = new StringBuilder();
        sp.append("select id, create_user_code, create_time, project_name AS bill_code, parent_org_name,bill_state  from ejc_procost_share ").append(" where id in (select DISTINCT share_id from ejc_procost_share_detail where source_id = ").append(id).append(" and dr = 0) and dr = 0");
        queryParam.put("BT220316000000002", sp.toString());
        return queryParam;
    }

    private List<ReferenceMapVO> getReferenceMapData(Map<String, List<JSONObject>> data) {
        ArrayList<ReferenceMapVO> resp = new ArrayList<ReferenceMapVO>();
        ReferenceMapVO tmp = null;
        ReferenceDetailVO tmpDetail = null;
        List<JSONObject> dataList = null;
        HashSet<String> userCodes = new HashSet<String>();
        for (String billType : data.keySet()) {
            dataList = data.get(billType);
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            tmp = new ReferenceMapVO();
            tmp.setId(billType);
            tmp.setModuleName("BT220223000000003".equals(billType) ? "\u4ed8\u6b3e\u7533\u8bf7\u5355" : "\u6210\u672c\u5f52\u96c6\u5355");
            tmp.setReferenceNum(Integer.valueOf(dataList.size()));
            for (JSONObject dataRow : dataList) {
                tmpDetail = new ReferenceDetailVO();
                tmpDetail.setId(dataRow.getString("id"));
                tmpDetail.setBillCode(dataRow.getString("bill_code"));
                tmpDetail.setBillState(BillStateEnum.getEnumByStateCode((Integer)dataRow.getInteger("bill_state")).getDescription());
                tmpDetail.setCreateTime(dataRow.getDate("create_time"));
                tmpDetail.setEmployeeName(dataRow.getString("create_user_code"));
                tmpDetail.setModuleName(tmp.getModuleName());
                tmpDetail.setOrgName(dataRow.getString("parent_org_name"));
                tmpDetail.setDetailPcUrl(this.BaseHost + ("BT220223000000003".equals(billType) ? (dataRow.getInteger("payment_contract_flag").equals(0) ? "ejc-profinance-frontend/#/paymentList/contractCard?id=" : "ejc-profinance-frontend/#/noContractCard?id=") : "ejc-share-frontend/#/costShare/card?id=") + tmpDetail.getId());
                tmp.getDetailList().add(tmpDetail);
                if (!StringUtils.isNotBlank((CharSequence)tmpDetail.getEmployeeName())) continue;
                userCodes.add(tmpDetail.getEmployeeName());
            }
            resp.add(tmp);
        }
        if (CollectionUtils.isNotEmpty(userCodes)) {
            CommonResponse userResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
            if (!userResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7528\u6237\u7f16\u7801\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)userResp.getMsg());
            } else {
                Map<String, UserVO> userMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item));
                resp.stream().forEach(item -> item.getDetailList().stream().forEach(detail -> {
                    if (userMap.containsKey(detail.getEmployeeName())) {
                        detail.setEmployeeName(((UserVO)userMap.get(detail.getEmployeeName())).getUserName());
                    }
                }));
            }
        }
        return resp;
    }
}

