package com.ejianc.business.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包总计划变更实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_plan_change")
public class PlanChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="bill_code")
    private String billCode; // 计划编码
    @TableField(value="total_plan_tax_mny")
    private BigDecimal totalPlanTaxMny; // 现计划金额
    @TableField(value="total_plan_mny")
    private BigDecimal totalPlanMny; // 现计划金额无税
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_user_name")
    private String changeUserName; // 变更人
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="original_plan_tax_mny")
    private BigDecimal originalPlanTaxMny; // 原计划金额
    @TableField(value="original_plan_mny")
    private BigDecimal originalPlanMny; // 原计划金额无税
    @TableField(value="source_plan_id")
    private Long sourcePlanId; // 源计划数据Id
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办单位id
    @TableField(value="department_name")
    private String departmentName; // 经办单位
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="sub_type")
    private Integer subType; // 分包类型 0-劳务分包 1-专业分包

    @TableField(exist=false)
    @SubEntity(serviceName="planDetailChangeService", pidName = "planId")//此处有pid="xxx"，默认值pid="pid"
    private List<PlanDetailChangeEntity> planDetailList = new ArrayList<>(); // 总计划子表变更
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getTotalPlanTaxMny() {
        return totalPlanTaxMny;
    }

    public void setTotalPlanTaxMny(BigDecimal totalPlanTaxMny) {
        this.totalPlanTaxMny = totalPlanTaxMny;
    }

    public BigDecimal getTotalPlanMny() {
        return totalPlanMny;
    }

    public void setTotalPlanMny(BigDecimal totalPlanMny) {
        this.totalPlanMny = totalPlanMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public BigDecimal getOriginalPlanTaxMny() {
        return originalPlanTaxMny;
    }

    public void setOriginalPlanTaxMny(BigDecimal originalPlanTaxMny) {
        this.originalPlanTaxMny = originalPlanTaxMny;
    }

    public BigDecimal getOriginalPlanMny() {
        return originalPlanMny;
    }

    public void setOriginalPlanMny(BigDecimal originalPlanMny) {
        this.originalPlanMny = originalPlanMny;
    }

    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<PlanDetailChangeEntity> getPlanDetailList() {
        return planDetailList;
    }

    public void setPlanDetailList(List<PlanDetailChangeEntity> planDetailList) {
        this.planDetailList = planDetailList;
    }
}
