package com.ejianc.business.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包总计划实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_plan")
public class PlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="bill_code")
    private String billCode; // 计划编码
    @TableField(value="total_plan_tax_mny")
    private BigDecimal totalPlanTaxMny; // 总计划金额
    @TableField(value="total_plan_mny")
    private BigDecimal totalPlanMny; // 总计划金额无税
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="change_state")
    private Integer changeState; // 变更状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="change_id")
    private Long changeId; // 当前对应的变更计划Id
    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="modify_user_name")
    private String modifyUserName; // 修改人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="sub_type")
    private Integer subType; // 分包类型 0-劳务分包 1-专业分包

    @TableField(exist=false)
    @SubEntity(serviceName="planDetailService" ,pidName = "planId")
    private List<PlanDetailEntity> planDetailList = new ArrayList<>(); // 分包总计划明细实体
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getTotalPlanTaxMny() {
        return totalPlanTaxMny;
    }

    public void setTotalPlanTaxMny(BigDecimal totalPlanTaxMny) {
        this.totalPlanTaxMny = totalPlanTaxMny;
    }

    public BigDecimal getTotalPlanMny() {
        return totalPlanMny;
    }

    public void setTotalPlanMny(BigDecimal totalPlanMny) {
        this.totalPlanMny = totalPlanMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }
    

    public List<PlanDetailEntity> getPlanDetailList() {
        return planDetailList;
    }

    public void setPlanDetailList(List<PlanDetailEntity> planDetailList) {
        this.planDetailList = planDetailList;
    }
}
