package com.ejianc.business.process.service;

import com.ejianc.business.process.bean.MeasureEntity;
import com.ejianc.business.process.vo.MeasureVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;

/**
 * 分包计量实体
 * 
 * @author generator
 * 
 */
public interface IMeasureService extends IBaseService<MeasureEntity> {

    // 劳务/专业分包合同-进度计量（移动端）  【合同金额】控【进度计量金额】  进度计量金额>合同金额*X*%  提醒等级：1-不控制-none，2-提醒-warn，3-无法保存-alert，默认提醒
    ParamsCheckVO mnyCtrl(MeasureVO measureVO, boolean flag);

    /**
     * 单据推送到供方协同服务
     *
     * @param measureEntity 待推送单据
     * @param billTypeCode 待推送单据的单据类型编码
     * @param cooperate 待推送单据的协同配置信息
     * @return
     */
    boolean pushBillToSupCenter(MeasureEntity measureEntity, String billTypeCode, CooperateVO cooperate);

    /**
     * 同步单据供供应商签字信息
     *
     * @param request
     */
    String updateBillSupSignSyncInfo(HttpServletRequest request);

    /**
     * 将推送至供方的单据作废
     *
     * @param measureEntity
     * @param billTypeCode
     * @return
     */
    boolean delPushBill(MeasureEntity measureEntity, String billTypeCode);
}
