package com.ejianc.business.prosub.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.service.IContractFileService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.stream.Collectors;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping
public class ContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private IContractFileService contractFileService;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/contractFileUpdate/updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));

        //将合同文件同步状态设置为已同步
        contract.setContractFileSyncFlag(true);

        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }

    @GetMapping(value = "/contractFileUpdate/getBillDataJson")
    public CommonResponse<ContractVO> getBillDataJson(@RequestParam Long id) {
        ContractEntity contract = contractService.selectById(id);
        ContractVO vo = BeanMapper.map(contract, ContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if(CollectionUtils.isNotEmpty(vo.getDetailList())) {
            //合同明细清单处理
            vo.setDetailList(vo.getDetailList().stream().filter(item -> null != item.getDetailNum()).collect(Collectors.toList()));
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(priceFmt.format(null != item.getDetailPrice() ? item.getDetailPrice() : BigDecimal.ZERO));
                item.setDetailTaxPriceStr(priceFmt.format(null != item.getDetailTaxPrice() ? item.getDetailTaxPrice() : BigDecimal.ZERO));
                item.setDetailMnyStr(mnyFmt.format(null != item.getDetailMny() ? item.getDetailMny() : BigDecimal.ZERO));
                item.setDetailTaxMnyStr(mnyFmt.format(null != item.getDetailTaxMny() ? item.getDetailTaxMny() : BigDecimal.ZERO));
                item.setDetailTaxStr(mnyFmt.format(null != item.getDetailTax() ? item.getDetailTax() : BigDecimal.ZERO));
                item.setDetailTaxRateStr(mnyFmt.format(null != item.getDetailTaxRate() ? item.getDetailTaxRate() : BigDecimal.ZERO));

                item.setDetailArtificialPriceStr(priceFmt.format(null != item.getDetailArtificialPrice() ? item.getDetailArtificialPrice() : BigDecimal.ZERO));
                item.setDetailArtificialTaxPriceStr(priceFmt.format(null != item.getDetailArtificialTaxPrice() ? item.getDetailArtificialTaxPrice() : BigDecimal.ZERO));
                item.setDetailArtificialMnyStr(mnyFmt.format(null != item.getDetailArtificialMny() ? item.getDetailArtificialMny() : BigDecimal.ZERO));
                item.setDetailArtificialTaxMnyStr(mnyFmt.format(null != item.getDetailArtificialTaxMny() ? item.getDetailArtificialTaxMny() : BigDecimal.ZERO));
                item.setDetailArtificialTaxStr(mnyFmt.format(null != item.getDetailArtificialTax() ? item.getDetailArtificialTax() : BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherCostList())) {
            //合同其他费用列表数据
            vo.getOtherCostList().stream().forEach(item -> {
                item.setCostPriceStr(priceFmt.format(null != item.getCostPrice() ? item.getCostPrice() : BigDecimal.ZERO));
                item.setCostTaxPriceStr(priceFmt.format(null != item.getCostTaxPrice() ? item.getCostTaxPrice() : BigDecimal.ZERO));
                item.setCostTaxRateStr(mnyFmt.format(null != item.getCostTaxPrice() ? item.getCostTaxPrice() : BigDecimal.ZERO));
                item.setCostTaxStr(mnyFmt.format(null != item.getCostTax() ? item.getCostTax() : BigDecimal.ZERO));
                item.setCostMnyStr(mnyFmt.format(null != item.getCostMny() ? item.getCostMny() : BigDecimal.ZERO));
                item.setCostTaxMnyStr(mnyFmt.format(null != item.getCostTaxMny() ? item.getCostTaxMny() : BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getPaymentList())) {
            //合同付款阶段
            vo.getPaymentList().stream().forEach(item -> {
                item.setPaymentScaleStr(mnyFmt.format(null != item.getPaymentScale() ? item.getPaymentScale() : BigDecimal.ZERO));
            });
        }
        return CommonResponse.success(vo);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "/billFileUpdate/getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId,
                                                        @RequestParam(value = "billType") String billType
    ) {

        JSONObject resp = contractFileService.getSignedFileInfo(billId, billType);
        return CommonResponse.success("查询成功！", resp);
    }
}
