package com.ejianc.business.prosub.pricelib.mapper;

import com.ejianc.business.prosub.bean.ContractDetailEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.prosub.pricelib.bean.PriceContractEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 分包价格库清单明细实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceContractMapper extends BaseCrudMapper<PriceContractEntity> {

    @Select("select * from ejc_prosub_contract where dr = 0 and (create_time >= #{time} or update_time >= #{time})")
    List<ContractEntity> getContractListByTime(Date time);

    @Select({
            "<script>",
            "select * from ejc_prosub_contract_detail where dr = 0 and contract_id in",
            "<foreach collection='contractIdList' item='contractId' open='(' separator=',' close=')'>",
            "#{contractId}",
            "</foreach>",
            "</script>"
    })
    List<ContractDetailEntity> getContractDetailListByContractId(@Param("contractIdList") List<Long> contractIdList);

}
