package com.ejianc.business.prosub.settlePayment.bean;

import java.util.ArrayList;
import java.util.Date;
import java.math.*;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 节点结算支付比例确认单主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_prosub_settle_payment")
public class SettlePaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="settle_type")
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="commit_user_name")
    private String commitUserName; //  提交人名称
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="effective_date")
    private Date effectiveDate; //  生效日期
    @TableField(value="settle_id")
    private Long settleId; // 节点结算主表ID
    @TableField(value="settle_code")
    private String settleCode; // 节点结算编码
    @TableField(value="settle_name")
    private String settleName; // 节点结算名称
    @TableField(value="settle_date")
    private Date settleDate; // 结算日期：默认显示当天,必须大于该合同的最近一次生效的结算日期（含过程结算、节点结算）；
    @TableField(value="bill_date")
    private Date billDate; // 单据日期
    @TableField(value="contract_id")
    private Long contractId; //  合同id
    @TableField(value="contract_name")
    private String contractName; // 
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value="org_id")
    private Long orgId; // 项目部id
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="org_name")
    private String orgName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value="supplier_name")
    private String supplierName; // 
    @TableField(value="payment_ratio_num")
    private Integer paymentRatioNum; // 确认支付比例次数
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; //  经办部门名称
    @TableField(value="memo")
    private String memo; // 备注 非必填，0-300字
    @TableField(value="settle_tax_mny")
    private BigDecimal settleTaxMny; // 本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 本期结算金额(无税)
    @TableField(value="last_settle_payment_tax_mny")
    private BigDecimal lastSettlePaymentTaxMny; //  不含本期累计结算支付金额
    @TableField(value="last_settle_payment_mny")
    private BigDecimal lastSettlePaymentMny; // 不含本期累计结算支付金额(无税)
    @TableField(value="settle_payment_tax_mny")
    private BigDecimal settlePaymentTaxMny; // 本次结算支付金额
    @TableField(value="settle_payment_mny")
    private BigDecimal settlePaymentMny; // 本次结算支付金额(无税)
    @TableField(value="total_settle_payment_tax_mny")
    private BigDecimal totalSettlePaymentTaxMny; //  累计结算支付金额
    @TableField(value="total_settle_payment_mny")
    private BigDecimal totalSettlePaymentMny; // 累计结算支付金额(无税)

    //以下字段用于计算结算支付金额
    @TableField("total_detail_settle_payment_tax_mny")
    private BigDecimal totalDetailSettlePaymentTaxMny;//清单中本期结算支付金额之和（含税）
    @TableField("total_detail_settle_payment_mny")
    private BigDecimal totalDetailSettlePaymentMny;//清单中本期结算支付金额之和（无税）
    @TableField(value = "picking_tax_mny")
    private BigDecimal pickingTaxMny; // 领料扣款金额
    @TableField(value = "picking_mny")
    private BigDecimal pickingMny; // 领料扣款金额(无税)
    @TableField(value = "oddjob_tax_mny")
    private BigDecimal oddjobTaxMny; // 零工金额金额
    @TableField(value = "oddjob_mny")
    private BigDecimal oddjobMny; // 零工金额金额(无税)
    @TableField(value = "deduct_tax_mny")
    private BigDecimal deductTaxMny; // 奖罚扣款单金额
    @TableField(value = "deduct_mny")
    private BigDecimal deductMny; // 奖罚扣款单金额(无税)
    @TableField(value = "other_tax_mny")
    private BigDecimal otherTaxMny; // 其他金额
    @TableField(value = "other_mny")
    private BigDecimal otherMny; // 其他金额(无税)

    @TableField(value="contract_total_settle_tax_mny")
    private BigDecimal contractTotalSettleTaxMny; // 合同累计结算金额(含税)
    @TableField(value="contract_total_settle_mny")
    private BigDecimal contractTotalSettleMny; // 合同累计结算金额(无税)
    @TableField(value="contract_total_pay_mny")
    private BigDecimal contractTotalPayMny; // 合同累计支付金额
    @TableField(value = "contract_settle_num")
    private String contractSettleNum; // 合同结算次数（节点结算使用字段）

    @TableField(exist = false)
    @SubEntity(serviceName = "settlePaymentDeductService", pidName = "settlePaymentId")
    private List<SettlePaymentDeductEntity> settlePaymentDeductList = new ArrayList<>(); // 结算子表-奖罚扣款单
    @TableField(exist = false)
    @SubEntity(serviceName = "settlePaymentDetailService", pidName = "settlePaymentId")
    private List<SettlePaymentDetailEntity> settlePaymentDetailList = new ArrayList<>(); // 结算子表-分包清单
    @TableField(exist = false)
    @SubEntity(serviceName = "settlePaymentOddjobService", pidName = "settlePaymentId")
    private List<SettlePaymentOddjobEntity> settlePaymentOddjobList = new ArrayList<>(); // 结算子表-零工登记
    @TableField(exist = false)
    @SubEntity(serviceName = "settlePaymentOtherService", pidName = "settlePaymentId")
    private List<SettlePaymentOtherEntity> settlePaymentOtherList = new ArrayList<>(); // 结算子表-其他费用
    @TableField(exist = false)
    @SubEntity(serviceName = "settlePaymentPickingService", pidName = "settlePaymentId")
    private List<SettlePaymentPickingEntity> settlePaymentPickingList = new ArrayList<>(); // 结算子表-领料结算





    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }
    public String getSettleName() {
        return settleName;
    }

    public void setSettleName(String settleName) {
        this.settleName = settleName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getPaymentRatioNum() {
        return paymentRatioNum;
    }

    public void setPaymentRatioNum(Integer paymentRatioNum) {
        this.paymentRatioNum = paymentRatioNum;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getLastSettlePaymentTaxMny() {
        return lastSettlePaymentTaxMny;
    }

    public void setLastSettlePaymentTaxMny(BigDecimal lastSettlePaymentTaxMny) {
        this.lastSettlePaymentTaxMny = lastSettlePaymentTaxMny;
    }
    public BigDecimal getLastSettlePaymentMny() {
        return lastSettlePaymentMny;
    }

    public void setLastSettlePaymentMny(BigDecimal lastSettlePaymentMny) {
        this.lastSettlePaymentMny = lastSettlePaymentMny;
    }
    public BigDecimal getSettlePaymentTaxMny() {
        return settlePaymentTaxMny;
    }

    public void setSettlePaymentTaxMny(BigDecimal settlePaymentTaxMny) {
        this.settlePaymentTaxMny = settlePaymentTaxMny;
    }
    public BigDecimal getSettlePaymentMny() {
        return settlePaymentMny;
    }

    public void setSettlePaymentMny(BigDecimal settlePaymentMny) {
        this.settlePaymentMny = settlePaymentMny;
    }
    public BigDecimal getTotalSettlePaymentTaxMny() {
        return totalSettlePaymentTaxMny;
    }

    public void setTotalSettlePaymentTaxMny(BigDecimal totalSettlePaymentTaxMny) {
        this.totalSettlePaymentTaxMny = totalSettlePaymentTaxMny;
    }
    public BigDecimal getTotalSettlePaymentMny() {
        return totalSettlePaymentMny;
    }

    public void setTotalSettlePaymentMny(BigDecimal totalSettlePaymentMny) {
        this.totalSettlePaymentMny = totalSettlePaymentMny;
    }

    public List<SettlePaymentDeductEntity> getSettlePaymentDeductList() {
        return settlePaymentDeductList;
    }

    public void setSettlePaymentDeductList(List<SettlePaymentDeductEntity> settlePaymentDeductList) {
        this.settlePaymentDeductList = settlePaymentDeductList;
    }

    public List<SettlePaymentDetailEntity> getSettlePaymentDetailList() {
        return settlePaymentDetailList;
    }

    public void setSettlePaymentDetailList(List<SettlePaymentDetailEntity> settlePaymentDetailList) {
        this.settlePaymentDetailList = settlePaymentDetailList;
    }

    public List<SettlePaymentOddjobEntity> getSettlePaymentOddjobList() {
        return settlePaymentOddjobList;
    }

    public void setSettlePaymentOddjobList(List<SettlePaymentOddjobEntity> settlePaymentOddjobList) {
        this.settlePaymentOddjobList = settlePaymentOddjobList;
    }

    public List<SettlePaymentOtherEntity> getSettlePaymentOtherList() {
        return settlePaymentOtherList;
    }

    public void setSettlePaymentOtherList(List<SettlePaymentOtherEntity> settlePaymentOtherList) {
        this.settlePaymentOtherList = settlePaymentOtherList;
    }

    public List<SettlePaymentPickingEntity> getSettlePaymentPickingList() {
        return settlePaymentPickingList;
    }

    public void setSettlePaymentPickingList(List<SettlePaymentPickingEntity> settlePaymentPickingList) {
        this.settlePaymentPickingList = settlePaymentPickingList;
    }

    public BigDecimal getTotalDetailSettlePaymentTaxMny() {
        return totalDetailSettlePaymentTaxMny;
    }

    public void setTotalDetailSettlePaymentTaxMny(BigDecimal totalDetailSettlePaymentTaxMny) {
        this.totalDetailSettlePaymentTaxMny = totalDetailSettlePaymentTaxMny;
    }

    public BigDecimal getTotalDetailSettlePaymentMny() {
        return totalDetailSettlePaymentMny;
    }

    public void setTotalDetailSettlePaymentMny(BigDecimal totalDetailSettlePaymentMny) {
        this.totalDetailSettlePaymentMny = totalDetailSettlePaymentMny;
    }

    public BigDecimal getPickingTaxMny() {
        return pickingTaxMny;
    }

    public void setPickingTaxMny(BigDecimal pickingTaxMny) {
        this.pickingTaxMny = pickingTaxMny;
    }

    public BigDecimal getPickingMny() {
        return pickingMny;
    }

    public void setPickingMny(BigDecimal pickingMny) {
        this.pickingMny = pickingMny;
    }

    public BigDecimal getOddjobTaxMny() {
        return oddjobTaxMny;
    }

    public void setOddjobTaxMny(BigDecimal oddjobTaxMny) {
        this.oddjobTaxMny = oddjobTaxMny;
    }

    public BigDecimal getOddjobMny() {
        return oddjobMny;
    }

    public void setOddjobMny(BigDecimal oddjobMny) {
        this.oddjobMny = oddjobMny;
    }

    public BigDecimal getDeductTaxMny() {
        return deductTaxMny;
    }

    public void setDeductTaxMny(BigDecimal deductTaxMny) {
        this.deductTaxMny = deductTaxMny;
    }

    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getContractTotalSettleTaxMny() {
        return contractTotalSettleTaxMny;
    }

    public void setContractTotalSettleTaxMny(BigDecimal contractTotalSettleTaxMny) {
        this.contractTotalSettleTaxMny = contractTotalSettleTaxMny;
    }

    public BigDecimal getContractTotalSettleMny() {
        return contractTotalSettleMny;
    }

    public void setContractTotalSettleMny(BigDecimal contractTotalSettleMny) {
        this.contractTotalSettleMny = contractTotalSettleMny;
    }

    public BigDecimal getContractTotalPayMny() {
        return contractTotalPayMny;
    }

    public void setContractTotalPayMny(BigDecimal contractTotalPayMny) {
        this.contractTotalPayMny = contractTotalPayMny;
    }

    public String getContractSettleNum() {
        return contractSettleNum;
    }

    public void setContractSettleNum(String contractSettleNum) {
        this.contractSettleNum = contractSettleNum;
    }
}
