package com.ejianc.business.prosub.warn;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.vo.ApplicationVO;
import com.ejianc.business.prosub.mapper.ContractMapper;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.subSalary.vo.SubSalaryVO;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.service.IProcessSettleService;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/prosubWarn/")
public class ProsubWarnController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String PC_URL = "/ejc-prosub-frontend/#/processSettle/prosub?id=";
    private static final String PC_A_URL = "/ejc-prosub-frontend/#/application/card?id=";


    @Autowired
    private IWarnCenterApi warnCenterApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IProcessSettleService processSettleService;
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    private ContractMapper contractMapper;


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }

        return CommonResponse.success("任务接受处理成功！");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        List<EarlyWarnTransVO> resp = new ArrayList<>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for(Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get("categoryName") ? defaultWarnInfo.get("categoryName").toString() + " - " : "")  + m.get("contractCode").toString());
            vo.setPcTitle("施工合同");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));


            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(
                    tmpContent.replaceAll("#contractName#", m.get("contractName").toString())
                            .replaceAll("#signDate#", m.get("signDate").toString())
            );

            resp.add(vo);
        }

        logger.info("发送预警参数：{}", JSON.toJSONString(resp));
        return resp;
    }


    /**
     * 下个月3日，上个月未做月度结算
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "processSettleWarnExecute")
    public CommonResponse<String> processSettleWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;
        List<ProjectPoolSetVO> proList = new ArrayList<>();
        CommonResponse<JSONArray> resp = projectSetApi.queryProjectPoolList(null,null,null);
        if(resp.isSuccess()){
            proList = JSONArray.parseArray(JSONObject.toJSONString(resp.getData()), ProjectPoolSetVO.class);
        } else {
            logger.error(resp.getMsg());
        }
        if (CollectionUtils.isEmpty(proList)){
            return CommonResponse.success();
        }
        Map<Long, List<ProjectPoolSetVO>> projectMap = proList.stream().collect(Collectors.groupingBy(ProjectPoolSetVO::getTenantId));
        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            //获取上月的起止日期
            SimpleDateFormat df1 =new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();

            int month = calendar.get(Calendar.MONTH) ;   //获取月份，0表示1月份

            calendar.add(Calendar.MONTH, -1);

            calendar.set(Calendar.DAY_OF_MONTH, 1);

            String berforeFirstDay = df1.format(calendar.getTime());//上月开始日期

            Calendar calendar1 = Calendar.getInstance();

            calendar1.set(Calendar.DAY_OF_MONTH, 1);

            calendar1.add(Calendar.DATE, -1);

            String berforeLastDay = df1.format(calendar1.getTime());//上月结束日期




            if (!projectMap.containsKey(tenantId)){
                continue;
            }
            List<ProjectPoolSetVO> projectList = projectMap.get(tenantId);
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("settleDate", new Parameter(QueryParam.BETWEEN,
                    berforeFirstDay+","+berforeLastDay));
            List<SettleEntity> settleEntities = processSettleService.queryList(param);
            logger.info("本次共获取上月月度结算单据数量{}条",settleEntities.size());

            List<SettleVO> settleVOs = BeanMapper.mapList(settleEntities, SettleVO.class);

            List<ProjectPoolSetVO> resultList = projectList.stream().filter(
                    (ProjectPoolSetVO) -> !settleVOs.stream().map(SettleVO::getProjectId).collect(Collectors.toList()).contains(ProjectPoolSetVO.getId()) && ProjectPoolSetVO.getProjectDate()!=null
            ).collect(Collectors.toList());

            logger.info("本次共获取上月未月度结算项目{}个",resultList.size());

            if (ListUtil.isNotEmpty(resultList)) {
                for (ProjectPoolSetVO pvo : resultList) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
                    Long orgId = pvo.getProjectDepartmentId();
                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                    if (orgVO == null) {
                        continue;
                    }
                    String innerCode = orgVO.getInnerCode();
                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的 innerCode 进行父级查找
                     * */
                    logger.info("parentIds______" + innerCode);
                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                        /** 反向查找 */
                        Long pOrgId = Long.parseLong(parentIds[i1]);
                        for (int j = 0; j < orgSettings.size(); j++) {
                            JSONObject set = orgSettings.getJSONObject(j);
                            if (pOrgId.equals(set.getLong("orgId"))) {
                                orgSet = set;
                                break;
                            }
                        }
                        if (orgSet != null) {
                            break;
                        }
                    }
                    /** 查找默认的 */
                    for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }
                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            if ("高".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
                            if ("低".equals(set.getString("warningLevel"))) {
                                if (set.getString("parameterValue") != null) {
                                    low = true;
                                    useSetLow = set;
                                }
                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            vo.setBillName("项目" + "-" +
                                    pvo.getName()+"-"+pvo.getCode());
                            vo.setPcTitle("专业分包合同");
                            vo.setPcUrl(PC_URL + pvo.getId());
                            vo.setOrgId(pvo.getProjectDepartmentId());
                            //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                            vo.setSendOrgId(pvo.getProjectDepartmentId() + "");
                            vo.setOrgName(orgVO.getName());
                            vo.setSourceId(pvo.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                                .replaceAll("#month#",month+"")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                                .replaceAll("#month#",month+"")
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", pvo.getName())
                                                .replaceAll("#month#",month+"")
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }


    /**
     * 零工申请，1周未完成零工登记
     *
     * 问题;已预计用工日期为时间去计算，但是预计用工日期可能为空
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "applicationWarnExecute")
    public CommonResponse<String> applicationWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
            List<Integer> billStatus = new ArrayList<>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStatus));
            param.getParams().put("useFlag", new Parameter(QueryParam.EQ, 0));

            List<ApplicationEntity> applicationEntities = applicationService.queryList(param);
            logger.info("本次共获取未零工登记单据数量{}条",applicationEntities.size());

            List<ApplicationVO> applicationVOS = BeanMapper.mapList(applicationEntities, ApplicationVO.class);


            if (ListUtil.isNotEmpty(applicationVOS)) {
                for (ApplicationVO pvo : applicationVOS) {
                    if (pvo.getPreUseWorkDate() != null) {
                        JSONObject orgSet = null;
                        JSONObject defaultSet = null;
                        Long orgId = pvo.getOrgId();
                        OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                        if (orgVO == null) {
                            continue;
                        }
                        String innerCode = orgVO.getInnerCode();
                        String[] parentIds = innerCode.split("\\|");
                        /**
                         * 如果当前组织没查到配置，则找其直接上级的配置，
                         * 再找不到，再找其上级，以此类推，
                         * 直至上级为空，还没找到则用默认配置，
                         * 默认配置为空，则不预警
                         * 使用当前组织的 innerCode 进行父级查找
                         * */
                        logger.info("parentIds______" + innerCode);
                        for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                            /** 反向查找 */
                            Long pOrgId = Long.parseLong(parentIds[i1]);
                            for (int j = 0; j < orgSettings.size(); j++) {
                                JSONObject set = orgSettings.getJSONObject(j);
                                if (pOrgId.equals(set.getLong("orgId"))) {
                                    orgSet = set;
                                    break;
                                }
                            }
                            if (orgSet != null) {
                                break;
                            }
                        }
                        /** 查找默认的 */
                        for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                            JSONObject set = orgSettings.getJSONObject(i1);
                            if (set.getBoolean("default")) {
                                defaultSet = set;
                                break;
                            }
                        }
                        if (orgSet == null) {
                            /** 使用默认配置 */
                            orgSet = defaultSet;
                        }
                        if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                            JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                            boolean high = false;
                            boolean meddle = false;
                            boolean low = false;
                            JSONObject useSetHigh = null;
                            JSONObject useSetMeddle = null;
                            JSONObject useSetLow = null;
                            for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                                JSONObject set = warningSettings.getJSONObject(i1);
                                if ("高".equals(set.getString("warningLevel"))) {
                                    if (new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getPreUseWorkDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                        high = true;
                                        useSetHigh = set;
                                    }
                                }
                                if ("中".equals(set.getString("warningLevel"))) {
                                    if (new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getPreUseWorkDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                        meddle = true;
                                        useSetMeddle = set;
                                    }
                                }
                                if ("低".equals(set.getString("warningLevel"))) {
                                    if (new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getPreUseWorkDate()).toString()).compareTo(set.getBigDecimal("parameterValue")) > -1) {
                                        low = true;
                                        useSetLow = set;
                                    }
                                }
                            }
                            //DecimalFormat df = new DecimalFormat("###,##0.00");
                            if (high || meddle || low) {
                                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                                vo.setBillName("项目" + "-" +
                                        pvo.getProjectName() + "-合同-" + pvo.getContractName());
                                vo.setPcTitle("零工申请");
                                vo.setPcUrl(PC_A_URL + pvo.getId());
                                vo.setOrgId(pvo.getOrgId());
                                //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                                vo.setSendOrgId(pvo.getOrgId() + "");
                                vo.setOrgName(orgVO.getName());
                                vo.setSourceId(pvo.getId().toString());
                                vo.setTenantId(tenantId);
                                vo.setWarnSetId(orgSet.getLong("warnId"));
                                vo.setEarlywarnName(orgSet.getString("warnName"));
                                vo.setWarnType(orgSet.getString("warnType"));
                                String tmpContent = orgSet.getString("warningContentTemplate");
                                BigDecimal days = new BigDecimal(DateUtil.getBetweenDays(new Date(), pvo.getPreUseWorkDate()).toString());
                                if (high) {
                                    vo.setWarnLevel("高");
                                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                    .replaceAll("#contractName#", pvo.getContractName())
                                                    .replaceAll("#day#", days + "")
                                    );
                                } else if (meddle) {
                                    vo.setWarnLevel("中");
                                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                    .replaceAll("#contractName#", pvo.getContractName())
                                                    .replaceAll("#day#", days + "")
                                    );
                                } else {
                                    vo.setWarnLevel("低");
                                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                    .replaceAll("#contractName#", pvo.getContractName())
                                                    .replaceAll("#day#", days + "")
                                    );
                                }
                                warnList.add(vo);
                            }
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }

    /**
     * 劳务分包-工人工资单
     * 合同状态在成本关门之前的项目（不关注工程状态），每月10号前进行预警，多少份合同没有做工人工资单
     * @param jsonParam
     * @return
     */
    @PostMapping(value = "salaryWarnExecute")
    public CommonResponse<String> salaryWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到 Task 参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            // 1、根据租户合同纬度，查询合同
            // 2、根据合同的单据所属组织，找到对应的预警设置，也就是这条合同适用于那个设置
            // 3、根据预警设置判断该合同数据属于哪个等级
            // 4、符合等级，则拼接预警数据，并保存到 list
            // 5、发送数据


            List<SubSalaryVO> subSalaryVOS = contractMapper.querySalaryWarn();
            logger.info("本次共获取未制作工资单项目{}个",subSalaryVOS.size());

            if (ListUtil.isNotEmpty(subSalaryVOS)) {
                for (SubSalaryVO pvo : subSalaryVOS) {
                    if (pvo.getId() != null) {
                        JSONObject orgSet = null;
                        JSONObject defaultSet = null;
                        Long orgId = pvo.getOrgId();
                        OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
                        if (orgVO == null) {
                            continue;
                        }
                        String innerCode = orgVO.getInnerCode();
                        String[] parentIds = innerCode.split("\\|");
                        /**
                         * 如果当前组织没查到配置，则找其直接上级的配置，
                         * 再找不到，再找其上级，以此类推，
                         * 直至上级为空，还没找到则用默认配置，
                         * 默认配置为空，则不预警
                         * 使用当前组织的 innerCode 进行父级查找
                         * */
                        logger.info("parentIds______" + innerCode);
                        for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
                            /** 反向查找 */
                            Long pOrgId = Long.parseLong(parentIds[i1]);
                            for (int j = 0; j < orgSettings.size(); j++) {
                                JSONObject set = orgSettings.getJSONObject(j);
                                if (pOrgId.equals(set.getLong("orgId"))) {
                                    orgSet = set;
                                    break;
                                }
                            }
                            if (orgSet != null) {
                                break;
                            }
                        }
                        /** 查找默认的 */
                        for (int i1 = 0; i1 < orgSettings.size(); i1++) {
                            JSONObject set = orgSettings.getJSONObject(i1);
                            if (set.getBoolean("default")) {
                                defaultSet = set;
                                break;
                            }
                        }
                        if (orgSet == null) {
                            /** 使用默认配置 */
                            orgSet = defaultSet;
                        }
                        if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {
                            JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                            boolean high = false;
                            boolean meddle = false;
                            boolean low = false;
                            JSONObject useSetHigh = null;
                            JSONObject useSetMeddle = null;
                            JSONObject useSetLow = null;
                            for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                                JSONObject set = warningSettings.getJSONObject(i1);
                                if ("高".equals(set.getString("warningLevel"))) {
                                       high = true;
                                        useSetHigh = set;
                                }
                                if ("中".equals(set.getString("warningLevel"))) {
                                       meddle = true;
                                       useSetMeddle = set;
                                }
                                if ("低".equals(set.getString("warningLevel"))) {
                                        low = true;
                                        useSetLow = set;
                                }
                            }
                            //DecimalFormat df = new DecimalFormat("###,##0.00");
                            if (high || meddle || low) {
                                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                                vo.setBillName("项目" + "-" +
                                        pvo.getProjectName() );
                                vo.setPcTitle("工资单");
                                vo.setPcUrl(null);
                                vo.setOrgId(pvo.getOrgId());
                                //发送消息，根据角色和组织找人，指定找人组织，多个以半角逗号分割
                                vo.setSendOrgId(pvo.getOrgId() + "");
                                vo.setOrgName(orgVO.getName());
                                vo.setSourceId(pvo.getId().toString());
                                vo.setTenantId(tenantId);
                                vo.setWarnSetId(orgSet.getLong("warnId"));
                                vo.setEarlywarnName(orgSet.getString("warnName"));
                                vo.setWarnType(orgSet.getString("warnType"));
                                String tmpContent = orgSet.getString("warningContentTemplate");
                                if (high) {
                                    vo.setWarnLevel("高");
                                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                    .replaceAll("#num#", pvo.getNum()+"")
                                    );
                                } else if (meddle) {
                                    vo.setWarnLevel("中");
                                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                    .replaceAll("#num#", pvo.getNum()+"")
                                    );
                                } else {
                                    vo.setWarnLevel("低");
                                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                                    vo.setEarlywarnContent(
                                            tmpContent.replaceAll("#projectName#", pvo.getProjectName())
                                                    .replaceAll("#num#", pvo.getNum()+"")
                                    );
                                }
                                warnList.add(vo);
                            }
                        }
                    }
                }
            }
        }
        return sendWarnToTask(warnList,warnCode);
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }



}
