package com.ejianc.business.settle.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 结算主实体
 *
 * @author generator
 */
@TableName("ejc_prosub_settle")
public class SettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 制单人Id
     */
    @TableField(value = "create_user_id")
    private Long createUserId;
    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value = "settle_type")
    private Integer settleType; // 结算类型：0-过程，1-完工，2-节点
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value = "org_id")
    private Long orgId; // 项目部id
    @TableField(value = "org_code")
    private String orgCode; // 项目部编码
    @TableField(value = "org_name")
    private String orgName; // 项目部名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 项目部所属组织id
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 项目部所属组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 项目部所属组织名称
    @TableField(value = "contract_id")
    private Long contractId; // 合同id
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_code")
    private String contractCode; // 合同编码
    @TableField(value = "contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value = "supplement_flag")
    private Integer supplementFlag; // 合同类别：0-主合同 1-补充协议
    @TableField(value = "project_id")
    private Long projectId; // 项目Id
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "project_code")
    private String projectCode; // 项目编号
    @TableField(value = "first_party_id")
    private Long firstPartyId;// 甲方Id
    @TableField(value = "first_party_name")
    private String firstPartyName;// 甲方名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 乙方id
    @TableField(value = "supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value = "supplier_sign_status")
    private Integer supplierSignStatus; // 乙方签字状态:已签字-1,未签字-0
    @TableField(value = "settle_date")
    private Date settleDate; // 结算日期：默认显示当天,必须大于该合同的最近一次生效的结算日期（含过程结算、节点结算）；
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人id
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门id
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "memo")
    private String memo; // 非必填，0-300字
    @TableField(value = "signature_status")
    private Integer signatureStatus; // 签章状态：1-未签章、2-待乙方签章、3-待甲方签章、4-已签章
    @TableField(value = "tax_mny")
    private BigDecimal taxMny; // 本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额
    @TableField(value = "mny")
    private BigDecimal mny; // 本期结算金额(无税)
    @TableField(value = "tax")
    private BigDecimal tax; // 本期结算税额
    @TableField(value = "detail_tax_mny")
    private BigDecimal detailTaxMny; // 分包清单金额
    @TableField(value = "detail_mny")
    private BigDecimal detailMny; // 分包清单金额(无税)
    @TableField(value = "detail_tax")
    private BigDecimal detailTax; // 分包清单税额
    @TableField(value = "picking_tax_mny")
    private BigDecimal pickingTaxMny; // 领料扣款金额
    @TableField(value = "picking_mny")
    private BigDecimal pickingMny; // 领料扣款金额(无税)
    @TableField(value = "picking_tax")
    private BigDecimal pickingTax; // 领料扣款税额
    @TableField(value = "oddjob_tax_mny")
    private BigDecimal oddjobTaxMny; // 零工金额金额
    @TableField(value = "oddjob_mny")
    private BigDecimal oddjobMny; // 零工金额金额(无税)
    @TableField(value = "oddjob_tax")
    private BigDecimal oddjobTax; // 零工金额税额
    @TableField(value = "deduct_tax_mny")
    private BigDecimal deductTaxMny; // 奖罚扣款单金额
    @TableField(value = "deduct_mny")
    private BigDecimal deductMny; // 奖罚扣款单金额(无税)
    @TableField(value = "deduct_tax")
    private BigDecimal deductTax; // 奖罚扣款单税额
    @TableField(value = "other_tax_mny")
    private BigDecimal otherTaxMny; // 其他金额
    @TableField(value = "other_mny")
    private BigDecimal otherMny; // 其他金额(无税)
    @TableField(value = "other_tax")
    private BigDecimal otherTax; // 其他税额
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value = "tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value = "salary_mny")
    private BigDecimal salaryMny; // 工人工资金额
    @TableField(value = "total_tax_mny")
    private BigDecimal totalTaxMny; // 累计过程结算金额
    @TableField(value = "total_mny")
    private BigDecimal totalMny; // 累计过程结算金额(无税)
    @TableField(value = "last_tax_mny")
    private BigDecimal lastTaxMny; // 不含本期累计过程结算金额
    @TableField(value = "last_mny")
    private BigDecimal lastMny; // 不含本期累计过程结算金额(无税)
    @TableField(value = "contract_pay_mny")
    private BigDecimal contractPayMny; // 合同已付金额
    @TableField(value = "contract_bill_tax_mny")
    private BigDecimal contractBillTaxMny; // 合同收票金额
    @TableField(value = "contract_bill_mny")
    private BigDecimal contractBillMny; // 合同收票金额(无税)
    @TableField(value = "picking_process_tax_mny")
    private BigDecimal pickingProcessTaxMny; // 领料过程结算金额
    @TableField(value = "picking_process_mny")
    private BigDecimal pickingProcessMny; // 领料过程结算金额（无税）
    @TableField(value = "picking_current_tax_mny")
    private BigDecimal pickingCurrentTaxMny; // 领料本期结算金额
    @TableField(value = "picking_current_mny")
    private BigDecimal pickingCurrentMny; // 领料本期结算金额（无税）
    @TableField(value = "oddjob_process_tax_mny")
    private BigDecimal oddjobProcessTaxMny; // 零工登记过程结算金额
    @TableField(value = "oddjob_process_mny")
    private BigDecimal oddjobProcessMny; // 零工登记过程结算金额（无税）
    @TableField(value = "oddjob_current_tax_mny")
    private BigDecimal oddjobCurrentTaxMny; // 零工登记本期结算金额
    @TableField(value = "oddjob_current_mny")
    private BigDecimal oddjobCurrentMny; // 零工登记本期结算金额（无税）
    @TableField(value = "deduct_process_tax_mny")
    private BigDecimal deductProcessTaxMny; // 奖罚扣款单过程结算金额
    @TableField(value = "deduct_process_mny")
    private BigDecimal deductProcessMny; // 奖罚扣款单过程结算金额（无税）
    @TableField(value = "deduct_current_tax_mny")
    private BigDecimal deductCurrentTaxMny; // 奖罚扣款单本期结算金额
    @TableField(value = "deduct_current_mny")
    private BigDecimal deductCurrentMny; // 奖罚扣款单本期结算金额（无税）
    @TableField(value = "other_process_tax_mny")
    private BigDecimal otherProcessTaxMny; // 其他过程结算金额
    @TableField(value = "other_process_mny")
    private BigDecimal otherProcessMny; // 其他过程结算金额（无税）
    @TableField(value = "other_current_tax_mny")
    private BigDecimal otherCurrentTaxMny; // 其他本期结算金额
    @TableField(value = "other_current_mny")
    private BigDecimal otherCurrentMny; // 其他本期结算金额（无税）

    @TableField(value = "total_process_tax_Mny")
    private BigDecimal totalProcessTaxMny; // 完工用累计过程结算金额
    @TableField(value = "total_process_mny")
    private BigDecimal totalProcessMny; // 完工用过程结算金额(无税)
    @TableField(value = "total_process_tax_difference")
    private BigDecimal totalProcessTaxDifference; // 过程结算差额
    @TableField(value = "total_process_difference")
    private BigDecimal totalProcessDifference; // 过程结算差额（无税）

    @TableField(value = "total_node_tax_mny")
    private BigDecimal totalNodeTaxMny; // 累计节点结算金额
    @TableField(value = "total_node_mny")
    private BigDecimal totalNodeMny; // 累计节点结算金额(无税)
    @TableField(value = "last_node_tax_mny")
    private BigDecimal lastNodeTaxMny; // 不含本期累计节点结算金额
    @TableField(value = "last_node_mny")
    private BigDecimal lastNodeMny; // 不含本期累计节点结算金额(无税)
    @TableField(value = "total_node_tax_difference")
    private BigDecimal totalNodeTaxDifference; // 节点结算差额
    @TableField(value = "total_node_difference")
    private BigDecimal totalNodeDifference; // 节点结算差额（无税）
    @TableField(value = "artificial_tax_mny")
    private BigDecimal artificialTaxMny; // 人工费金额（含税）
    @TableField(value = "settle_times")
    private Integer settleTimes; // 累计结算次数

    @TableField(value = "settle_payment_tax_mny")
    private BigDecimal settlePaymentTaxMny; // 本期结算支付金额（含税）
    @TableField(value = "settle_payment_mny")
    private BigDecimal settlePaymentMny; // 本期结算支付金额（无税）
    @TableField("total_settle_payment_tax_mny")
    private BigDecimal totalSettlePaymentTaxMny;//累计结算支付金额（含税）
    @TableField("total_settle_payment_mny")
    private BigDecimal totalSettlePaymentMny;//累计结算支付金额（无税）
    @TableField("total_detail_settle_payment_tax_mny")
    private BigDecimal totalDetailSettlePaymentTaxMny;//清单中本期结算支付金额之和（含税）
    @TableField("total_detail_settle_payment_mny")
    private BigDecimal totalDetailSettlePaymentMny;//清单中本期结算支付金额之和（无税）
    @TableField(value = "contract_settle_num")
    private String contractSettleNum; // 合同结算次数（节点结算使用字段）



    @TableField(exist = false)
    @SubEntity(serviceName = "settleDeductService", pidName = "settleId")
    private List<SettleDeductEntity> settleDeductList = new ArrayList<>(); // 结算子表-奖罚扣款单
    @TableField(exist = false)
    @SubEntity(serviceName = "settleDetailService", pidName = "settleId")
    private List<SettleDetailEntity> settleDetailList = new ArrayList<>(); // 结算子表-分包清单
    @TableField(exist = false)
    @SubEntity(serviceName = "settleOddjobService", pidName = "settleId")
    private List<SettleOddjobEntity> settleOddjobList = new ArrayList<>(); // 结算子表-零工登记
    @TableField(exist = false)
    @SubEntity(serviceName = "settleOtherService", pidName = "settleId")
    private List<SettleOtherEntity> settleOtherList = new ArrayList<>(); // 结算子表-其他费用
    @TableField(exist = false)
    @SubEntity(serviceName = "settlePickingService", pidName = "settleId")
    private List<SettlePickingEntity> settlePickingList = new ArrayList<>(); // 结算子表-领料结算
    @TableField(exist = false)
    @SubEntity(serviceName = "settleSalaryService", pidName = "settleId")
    private List<SettleSalaryEntity> settleSalaryList = new ArrayList<>(); // 结算子表-工人工资单


    /***  协同需要字段 START  ***/

    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;

    /**
     * 来源业务系统id
     */
    @TableField(exist = false)
    private String sourceSystemId;

    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;

    /**
     * 推送结算池标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "push_pool_flag")
    private String pushPoolFlag;

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    /***  协同需要字段 END  ***/

    /**
     * 结算单高亮附件路径
     */
    @TableField("contract_file_highlight_path")
    private String contractFileHighlightPath;

    /**
     * 结算单高亮附件Id
     */
    @TableField("contract_file_highlight_id")
    private Long contractFileHighlightId;

    /**
     * 结算单附件路径
     */
    @TableField("contract_file_path")
    private String contractFilePath;

    /**
     * 结算单附件Id
     */
    @TableField("contract_file_id")
    private Long contractFileId;

    /**
     * 完成签章附件Id
     */
    @TableField("signed_file_id")
    private Long signedFileId;


    @TableField(value = "relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value = "proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value = "push_cost_tax_mny")
    private BigDecimal pushCostTaxMny;//推送成本金额
    @TableField(value = "push_cost_mny")
    private BigDecimal pushCostMny;//推送成本金额（无税）
    @TableField(value = "push_cost_tax")
    private BigDecimal pushCostTax;//推送成本金额税额


    @TableField("filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public BigDecimal getPushCostTaxMny() {
        return pushCostTaxMny;
    }

    public void setPushCostTaxMny(BigDecimal pushCostTaxMny) {
        this.pushCostTaxMny = pushCostTaxMny;
    }

    public BigDecimal getPushCostMny() {
        return pushCostMny;
    }

    public void setPushCostMny(BigDecimal pushCostMny) {
        this.pushCostMny = pushCostMny;
    }

    public BigDecimal getPushCostTax() {
        return pushCostTax;
    }

    public void setPushCostTax(BigDecimal pushCostTax) {
        this.pushCostTax = pushCostTax;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(Integer signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getPickingTaxMny() {
        return pickingTaxMny;
    }

    public void setPickingTaxMny(BigDecimal pickingTaxMny) {
        this.pickingTaxMny = pickingTaxMny;
    }

    public BigDecimal getPickingMny() {
        return pickingMny;
    }

    public void setPickingMny(BigDecimal pickingMny) {
        this.pickingMny = pickingMny;
    }

    public BigDecimal getPickingTax() {
        return pickingTax;
    }

    public void setPickingTax(BigDecimal pickingTax) {
        this.pickingTax = pickingTax;
    }

    public BigDecimal getOddjobTaxMny() {
        return oddjobTaxMny;
    }

    public void setOddjobTaxMny(BigDecimal oddjobTaxMny) {
        this.oddjobTaxMny = oddjobTaxMny;
    }

    public BigDecimal getOddjobMny() {
        return oddjobMny;
    }

    public void setOddjobMny(BigDecimal oddjobMny) {
        this.oddjobMny = oddjobMny;
    }

    public BigDecimal getOddjobTax() {
        return oddjobTax;
    }

    public void setOddjobTax(BigDecimal oddjobTax) {
        this.oddjobTax = oddjobTax;
    }

    public BigDecimal getDeductTaxMny() {
        return deductTaxMny;
    }

    public void setDeductTaxMny(BigDecimal deductTaxMny) {
        this.deductTaxMny = deductTaxMny;
    }

    public BigDecimal getDeductMny() {
        return deductMny;
    }

    public void setDeductMny(BigDecimal deductMny) {
        this.deductMny = deductMny;
    }

    public BigDecimal getDeductTax() {
        return deductTax;
    }

    public void setDeductTax(BigDecimal deductTax) {
        this.deductTax = deductTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getSalaryMny() {
        return salaryMny;
    }

    public void setSalaryMny(BigDecimal salaryMny) {
        this.salaryMny = salaryMny;
    }

    public BigDecimal getTotalTaxMny() {
        return totalTaxMny;
    }

    public void setTotalTaxMny(BigDecimal totalTaxMny) {
        this.totalTaxMny = totalTaxMny;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getLastTaxMny() {
        return lastTaxMny;
    }

    public void setLastTaxMny(BigDecimal lastTaxMny) {
        this.lastTaxMny = lastTaxMny;
    }

    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }

    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }

    public BigDecimal getContractBillTaxMny() {
        return contractBillTaxMny;
    }

    public void setContractBillTaxMny(BigDecimal contractBillTaxMny) {
        this.contractBillTaxMny = contractBillTaxMny;
    }

    public BigDecimal getContractBillMny() {
        return contractBillMny;
    }

    public void setContractBillMny(BigDecimal contractBillMny) {
        this.contractBillMny = contractBillMny;
    }

    public BigDecimal getPickingProcessTaxMny() {
        return pickingProcessTaxMny;
    }

    public void setPickingProcessTaxMny(BigDecimal pickingProcessTaxMny) {
        this.pickingProcessTaxMny = pickingProcessTaxMny;
    }

    public BigDecimal getPickingProcessMny() {
        return pickingProcessMny;
    }

    public void setPickingProcessMny(BigDecimal pickingProcessMny) {
        this.pickingProcessMny = pickingProcessMny;
    }

    public BigDecimal getPickingCurrentTaxMny() {
        return pickingCurrentTaxMny;
    }

    public void setPickingCurrentTaxMny(BigDecimal pickingCurrentTaxMny) {
        this.pickingCurrentTaxMny = pickingCurrentTaxMny;
    }

    public BigDecimal getPickingCurrentMny() {
        return pickingCurrentMny;
    }

    public void setPickingCurrentMny(BigDecimal pickingCurrentMny) {
        this.pickingCurrentMny = pickingCurrentMny;
    }

    public BigDecimal getOddjobProcessTaxMny() {
        return oddjobProcessTaxMny;
    }

    public void setOddjobProcessTaxMny(BigDecimal oddjobProcessTaxMny) {
        this.oddjobProcessTaxMny = oddjobProcessTaxMny;
    }

    public BigDecimal getOddjobProcessMny() {
        return oddjobProcessMny;
    }

    public void setOddjobProcessMny(BigDecimal oddjobProcessMny) {
        this.oddjobProcessMny = oddjobProcessMny;
    }

    public BigDecimal getOddjobCurrentTaxMny() {
        return oddjobCurrentTaxMny;
    }

    public void setOddjobCurrentTaxMny(BigDecimal oddjobCurrentTaxMny) {
        this.oddjobCurrentTaxMny = oddjobCurrentTaxMny;
    }

    public BigDecimal getOddjobCurrentMny() {
        return oddjobCurrentMny;
    }

    public void setOddjobCurrentMny(BigDecimal oddjobCurrentMny) {
        this.oddjobCurrentMny = oddjobCurrentMny;
    }

    public BigDecimal getDeductProcessTaxMny() {
        return deductProcessTaxMny;
    }

    public void setDeductProcessTaxMny(BigDecimal deductProcessTaxMny) {
        this.deductProcessTaxMny = deductProcessTaxMny;
    }

    public BigDecimal getDeductProcessMny() {
        return deductProcessMny;
    }

    public void setDeductProcessMny(BigDecimal deductProcessMny) {
        this.deductProcessMny = deductProcessMny;
    }

    public BigDecimal getDeductCurrentTaxMny() {
        return deductCurrentTaxMny;
    }

    public void setDeductCurrentTaxMny(BigDecimal deductCurrentTaxMny) {
        this.deductCurrentTaxMny = deductCurrentTaxMny;
    }

    public BigDecimal getDeductCurrentMny() {
        return deductCurrentMny;
    }

    public void setDeductCurrentMny(BigDecimal deductCurrentMny) {
        this.deductCurrentMny = deductCurrentMny;
    }

    public BigDecimal getOtherProcessTaxMny() {
        return otherProcessTaxMny;
    }

    public void setOtherProcessTaxMny(BigDecimal otherProcessTaxMny) {
        this.otherProcessTaxMny = otherProcessTaxMny;
    }

    public BigDecimal getOtherProcessMny() {
        return otherProcessMny;
    }

    public void setOtherProcessMny(BigDecimal otherProcessMny) {
        this.otherProcessMny = otherProcessMny;
    }

    public BigDecimal getOtherCurrentTaxMny() {
        return otherCurrentTaxMny;
    }

    public void setOtherCurrentTaxMny(BigDecimal otherCurrentTaxMny) {
        this.otherCurrentTaxMny = otherCurrentTaxMny;
    }

    public BigDecimal getOtherCurrentMny() {
        return otherCurrentMny;
    }

    public void setOtherCurrentMny(BigDecimal otherCurrentMny) {
        this.otherCurrentMny = otherCurrentMny;
    }

    public BigDecimal getTotalProcessTaxMny() {
        return totalProcessTaxMny;
    }

    public void setTotalProcessTaxMny(BigDecimal totalProcessTaxMny) {
        this.totalProcessTaxMny = totalProcessTaxMny;
    }

    public BigDecimal getTotalProcessMny() {
        return totalProcessMny;
    }

    public void setTotalProcessMny(BigDecimal totalProcessMny) {
        this.totalProcessMny = totalProcessMny;
    }

    public BigDecimal getTotalProcessTaxDifference() {
        return totalProcessTaxDifference;
    }

    public void setTotalProcessTaxDifference(BigDecimal totalProcessTaxDifference) {
        this.totalProcessTaxDifference = totalProcessTaxDifference;
    }

    public BigDecimal getTotalProcessDifference() {
        return totalProcessDifference;
    }

    public void setTotalProcessDifference(BigDecimal totalProcessDifference) {
        this.totalProcessDifference = totalProcessDifference;
    }

    public BigDecimal getTotalNodeTaxMny() {
        return totalNodeTaxMny;
    }

    public void setTotalNodeTaxMny(BigDecimal totalNodeTaxMny) {
        this.totalNodeTaxMny = totalNodeTaxMny;
    }

    public BigDecimal getTotalNodeMny() {
        return totalNodeMny;
    }

    public void setTotalNodeMny(BigDecimal totalNodeMny) {
        this.totalNodeMny = totalNodeMny;
    }

    public BigDecimal getLastNodeTaxMny() {
        return lastNodeTaxMny;
    }

    public void setLastNodeTaxMny(BigDecimal lastNodeTaxMny) {
        this.lastNodeTaxMny = lastNodeTaxMny;
    }

    public BigDecimal getLastNodeMny() {
        return lastNodeMny;
    }

    public void setLastNodeMny(BigDecimal lastNodeMny) {
        this.lastNodeMny = lastNodeMny;
    }

    public BigDecimal getTotalNodeTaxDifference() {
        return totalNodeTaxDifference;
    }

    public void setTotalNodeTaxDifference(BigDecimal totalNodeTaxDifference) {
        this.totalNodeTaxDifference = totalNodeTaxDifference;
    }

    public BigDecimal getTotalNodeDifference() {
        return totalNodeDifference;
    }

    public void setTotalNodeDifference(BigDecimal totalNodeDifference) {
        this.totalNodeDifference = totalNodeDifference;
    }

    public BigDecimal getArtificialTaxMny() {
        return artificialTaxMny;
    }

    public void setArtificialTaxMny(BigDecimal artificialTaxMny) {
        this.artificialTaxMny = artificialTaxMny;
    }

    public Integer getSettleTimes() {
        return settleTimes;
    }

    public void setSettleTimes(Integer settleTimes) {
        this.settleTimes = settleTimes;
    }

    public List<SettleDeductEntity> getSettleDeductList() {
        return settleDeductList;
    }

    public void setSettleDeductList(List<SettleDeductEntity> settleDeductList) {
        this.settleDeductList = settleDeductList;
    }

    public List<SettleDetailEntity> getSettleDetailList() {
        return settleDetailList;
    }

    public void setSettleDetailList(List<SettleDetailEntity> settleDetailList) {
        this.settleDetailList = settleDetailList;
    }

    public List<SettleOddjobEntity> getSettleOddjobList() {
        return settleOddjobList;
    }

    public void setSettleOddjobList(List<SettleOddjobEntity> settleOddjobList) {
        this.settleOddjobList = settleOddjobList;
    }

    public List<SettleOtherEntity> getSettleOtherList() {
        return settleOtherList;
    }

    public void setSettleOtherList(List<SettleOtherEntity> settleOtherList) {
        this.settleOtherList = settleOtherList;
    }

    public List<SettlePickingEntity> getSettlePickingList() {
        return settlePickingList;
    }

    public void setSettlePickingList(List<SettlePickingEntity> settlePickingList) {
        this.settlePickingList = settlePickingList;
    }

    public List<SettleSalaryEntity> getSettleSalaryList() {
        return settleSalaryList;
    }

    public void setSettleSalaryList(List<SettleSalaryEntity> settleSalaryList) {
        this.settleSalaryList = settleSalaryList;
    }


    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public BigDecimal getSettlePaymentMny() {
        return settlePaymentMny;
    }

    public void setSettlePaymentMny(BigDecimal settlePaymentMny) {
        this.settlePaymentMny = settlePaymentMny;
    }

    public BigDecimal getTotalSettlePaymentMny() {
        return totalSettlePaymentMny;
    }

    public void setTotalSettlePaymentMny(BigDecimal totalSettlePaymentMny) {
        this.totalSettlePaymentMny = totalSettlePaymentMny;
    }

    public BigDecimal getSettlePaymentTaxMny() {
        return settlePaymentTaxMny;
    }

    public void setSettlePaymentTaxMny(BigDecimal settlePaymentTaxMny) {
        this.settlePaymentTaxMny = settlePaymentTaxMny;
    }

    public BigDecimal getTotalSettlePaymentTaxMny() {
        return totalSettlePaymentTaxMny;
    }

    public void setTotalSettlePaymentTaxMny(BigDecimal totalSettlePaymentTaxMny) {
        this.totalSettlePaymentTaxMny = totalSettlePaymentTaxMny;
    }

    public BigDecimal getTotalDetailSettlePaymentTaxMny() {
        return totalDetailSettlePaymentTaxMny;
    }

    public void setTotalDetailSettlePaymentTaxMny(BigDecimal totalDetailSettlePaymentTaxMny) {
        this.totalDetailSettlePaymentTaxMny = totalDetailSettlePaymentTaxMny;
    }

    public BigDecimal getTotalDetailSettlePaymentMny() {
        return totalDetailSettlePaymentMny;
    }

    public void setTotalDetailSettlePaymentMny(BigDecimal totalDetailSettlePaymentMny) {
        this.totalDetailSettlePaymentMny = totalDetailSettlePaymentMny;
    }

    public String getContractSettleNum() {
        return contractSettleNum;
    }

    public void setContractSettleNum(String contractSettleNum) {
        this.contractSettleNum = contractSettleNum;
    }
}
