package com.ejianc.business.settle.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.settle.bean.SettlePickingEntity;
import com.ejianc.business.settle.bean.SettleSalaryEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;
import java.util.List;

/**
 * 结算子表-领料结算
 *
 * @author generator
 */
public interface ISettlePickingService extends IBaseService<SettlePickingEntity> {

    /**
     * 查询领料结算列表数据（已生效、没有被过程结算引用、日期小于等于结算日期、日期倒序排列）
     *
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @param settleDate 结算日期
     * @return List<SettlePickingEntity>
     */
    List<SettlePickingEntity> queryPickingList(Integer settleType, Long contractId, Date settleDate);


    /**
     * 查询领料结算列表数据（已生效、没有被过程结算引用 日期倒序排列）
     * @param page 封装的请求参数
     * @param settleType 结算类型：0-过程，1-完工，2-节点
     * @param contractId 合同id
     * @return IPage<SettlePickingEntity>
     */
    IPage<SettlePickingEntity> selectPageSalary(Page<SettlePickingEntity> page, Integer settleType, Long contractId);

}
